/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.debug;

import android.content.Context;
import android.os.Build;
import android.view.Choreographer;
import android.widget.Toast;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.JSApplicationCausedNativeException;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.debug.DeveloperSettings;
import com.facebook.react.modules.debug.FpsDebugFrameCallback;
import java.util.Locale;
import javax.annotation.Nullable;

@ReactModule(name="AnimationsDebugModule")
public class AnimationsDebugModule
extends ReactContextBaseJavaModule {
    protected static final String NAME = "AnimationsDebugModule";
    @Nullable
    private FpsDebugFrameCallback mFrameCallback;
    @Nullable
    private final DeveloperSettings mCatalystSettings;

    public AnimationsDebugModule(ReactApplicationContext reactContext, DeveloperSettings catalystSettings) {
        super(reactContext);
        this.mCatalystSettings = catalystSettings;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @ReactMethod
    public void startRecordingFps() {
        if (this.mCatalystSettings == null || !this.mCatalystSettings.isAnimationFpsDebugEnabled()) {
            return;
        }
        if (this.mFrameCallback != null) {
            throw new JSApplicationCausedNativeException("Already recording FPS!");
        }
        AnimationsDebugModule.checkAPILevel();
        this.mFrameCallback = new FpsDebugFrameCallback(Choreographer.getInstance(), this.getReactApplicationContext());
        this.mFrameCallback.startAndRecordFpsAtEachFrame();
    }

    @ReactMethod
    public void stopRecordingFps(double animationStopTimeMs) {
        if (this.mFrameCallback == null) {
            return;
        }
        AnimationsDebugModule.checkAPILevel();
        this.mFrameCallback.stop();
        FpsDebugFrameCallback.FpsInfo fpsInfo = this.mFrameCallback.getFpsInfo((long)animationStopTimeMs);
        if (fpsInfo == null) {
            Toast.makeText((Context)this.getReactApplicationContext(), (CharSequence)"Unable to get FPS info", (int)1);
        } else {
            String fpsString = String.format(Locale.US, "FPS: %.2f, %d frames (%d expected)", fpsInfo.fps, fpsInfo.totalFrames, fpsInfo.totalExpectedFrames);
            String jsFpsString = String.format(Locale.US, "JS FPS: %.2f, %d frames (%d expected)", fpsInfo.jsFps, fpsInfo.totalJsFrames, fpsInfo.totalExpectedFrames);
            String debugString = fpsString + "\n" + jsFpsString + "\n" + "Total Time MS: " + String.format(Locale.US, "%d", fpsInfo.totalTimeMs);
            FLog.d((String)"React", (String)debugString);
            Toast.makeText((Context)this.getReactApplicationContext(), (CharSequence)debugString, (int)1).show();
        }
        this.mFrameCallback = null;
    }

    @Override
    public void onCatalystInstanceDestroy() {
        if (this.mFrameCallback != null) {
            this.mFrameCallback.stop();
            this.mFrameCallback = null;
        }
    }

    private static void checkAPILevel() {
        if (Build.VERSION.SDK_INT < 16) {
            throw new JSApplicationCausedNativeException("Animation debugging is not supported in API <16");
        }
    }
}

