/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.fresco;

import android.content.Context;
import android.support.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.common.soloader.SoLoaderShim;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.backends.okhttp3.OkHttpImagePipelineConfigFactory;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.common.ModuleDataCleaner;
import com.facebook.react.modules.fresco.SystraceRequestListener;
import com.facebook.react.modules.network.OkHttpClientProvider;
import com.facebook.soloader.SoLoader;
import java.util.HashSet;
import okhttp3.OkHttpClient;

@ReactModule(name="FrescoModule")
public class FrescoModule
extends ReactContextBaseJavaModule
implements ModuleDataCleaner.Cleanable {
    @Nullable
    private ImagePipelineConfig mConfig;
    private static boolean sHasBeenInitialized = false;

    public FrescoModule(ReactApplicationContext reactContext) {
        this(reactContext, null);
    }

    public FrescoModule(ReactApplicationContext reactContext, @Nullable ImagePipelineConfig config) {
        super(reactContext);
        this.mConfig = config;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!FrescoModule.hasBeenInitialized()) {
            SoLoaderShim.setHandler((SoLoaderShim.Handler)new FrescoHandler());
            if (this.mConfig == null) {
                this.mConfig = FrescoModule.getDefaultConfig((Context)this.getReactApplicationContext());
            }
            Context context = this.getReactApplicationContext().getApplicationContext();
            Fresco.initialize((Context)context, (ImagePipelineConfig)this.mConfig);
            sHasBeenInitialized = true;
        } else if (this.mConfig != null) {
            FLog.w((String)"React", (String)"Fresco has already been initialized with a different config. The new Fresco configuration will be ignored!");
        }
        this.mConfig = null;
    }

    @Override
    public String getName() {
        return "FrescoModule";
    }

    @Override
    public void clearSensitiveData() {
        Fresco.getImagePipeline().clearCaches();
    }

    public static boolean hasBeenInitialized() {
        return sHasBeenInitialized;
    }

    private static ImagePipelineConfig getDefaultConfig(Context context) {
        return FrescoModule.getDefaultConfigBuilder(context).build();
    }

    public static ImagePipelineConfig.Builder getDefaultConfigBuilder(Context context) {
        HashSet<SystraceRequestListener> requestListeners = new HashSet<SystraceRequestListener>();
        requestListeners.add(new SystraceRequestListener());
        return OkHttpImagePipelineConfigFactory.newBuilder((Context)context.getApplicationContext(), (OkHttpClient)OkHttpClientProvider.getOkHttpClient()).setDownsampleEnabled(false).setRequestListeners(requestListeners);
    }

    private static class FrescoHandler
    implements SoLoaderShim.Handler {
        private FrescoHandler() {
        }

        public void loadLibrary(String libraryName) {
            SoLoader.loadLibrary((String)libraryName);
        }
    }
}

