/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.yoga;

import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.soloader.SoLoader;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaBaselineFunction;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaExperimentalFeature;
import com.facebook.yoga.YogaFlexDirection;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaLogger;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaNodeAPI;
import com.facebook.yoga.YogaOverflow;
import com.facebook.yoga.YogaPositionType;
import com.facebook.yoga.YogaValue;
import com.facebook.yoga.YogaWrap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@DoNotStrip
public class YogaNode
implements YogaNodeAPI<YogaNode> {
    private YogaNode mParent;
    private List<YogaNode> mChildren;
    private YogaMeasureFunction mMeasureFunction;
    private YogaBaselineFunction mBaselineFunction;
    private long mNativePointer;
    private Object mData;
    private boolean mHasSetPadding = false;
    private boolean mHasSetMargin = false;
    private boolean mHasSetBorder = false;
    private boolean mHasSetPosition = false;
    @DoNotStrip
    private float mWidth = Float.NaN;
    @DoNotStrip
    private float mHeight = Float.NaN;
    @DoNotStrip
    private float mTop = Float.NaN;
    @DoNotStrip
    private float mLeft = Float.NaN;
    @DoNotStrip
    private float mMarginLeft = 0.0f;
    @DoNotStrip
    private float mMarginTop = 0.0f;
    @DoNotStrip
    private float mMarginRight = 0.0f;
    @DoNotStrip
    private float mMarginBottom = 0.0f;
    @DoNotStrip
    private float mPaddingLeft = 0.0f;
    @DoNotStrip
    private float mPaddingTop = 0.0f;
    @DoNotStrip
    private float mPaddingRight = 0.0f;
    @DoNotStrip
    private float mPaddingBottom = 0.0f;
    @DoNotStrip
    private int mLayoutDirection = 0;

    static native int jni_YGNodeGetInstanceCount();

    static native void jni_YGLog(int var0, String var1);

    private static native void jni_YGSetLogger(Object var0);

    public static void setLogger(YogaLogger logger) {
        YogaNode.jni_YGSetLogger(logger);
    }

    private static native void jni_YGSetExperimentalFeatureEnabled(int var0, boolean var1);

    public static void setExperimentalFeatureEnabled(YogaExperimentalFeature feature, boolean enabled) {
        YogaNode.jni_YGSetExperimentalFeatureEnabled(feature.intValue(), enabled);
    }

    private static native boolean jni_YGIsExperimentalFeatureEnabled(int var0);

    public static boolean isExperimentalFeatureEnabled(YogaExperimentalFeature feature) {
        return YogaNode.jni_YGIsExperimentalFeatureEnabled(feature.intValue());
    }

    private native long jni_YGNodeNew();

    public YogaNode() {
        this.mNativePointer = this.jni_YGNodeNew();
        if (this.mNativePointer == 0L) {
            throw new IllegalStateException("Failed to allocate native memory");
        }
    }

    private native void jni_YGNodeFree(long var1);

    protected void finalize() throws Throwable {
        try {
            this.jni_YGNodeFree(this.mNativePointer);
        }
        finally {
            super.finalize();
        }
    }

    private native void jni_YGNodeReset(long var1);

    @Override
    public void reset() {
        this.mHasSetPadding = false;
        this.mHasSetMargin = false;
        this.mHasSetBorder = false;
        this.mHasSetPosition = false;
        this.mWidth = Float.NaN;
        this.mHeight = Float.NaN;
        this.mTop = Float.NaN;
        this.mLeft = Float.NaN;
        this.mLayoutDirection = 0;
        this.mMeasureFunction = null;
        this.mData = null;
        this.jni_YGNodeReset(this.mNativePointer);
    }

    @Override
    public int getChildCount() {
        return this.mChildren == null ? 0 : this.mChildren.size();
    }

    @Override
    public YogaNode getChildAt(int i) {
        return this.mChildren.get(i);
    }

    private native void jni_YGNodeInsertChild(long var1, long var3, int var5);

    @Override
    public void addChildAt(YogaNode child, int i) {
        if (child.mParent != null) {
            throw new IllegalStateException("Child already has a parent, it must be removed first.");
        }
        if (this.mChildren == null) {
            this.mChildren = new ArrayList<YogaNode>(4);
        }
        this.mChildren.add(i, child);
        child.mParent = this;
        this.jni_YGNodeInsertChild(this.mNativePointer, child.mNativePointer, i);
    }

    private native void jni_YGNodeRemoveChild(long var1, long var3);

    @Override
    public YogaNode removeChildAt(int i) {
        YogaNode child = this.mChildren.remove(i);
        child.mParent = null;
        this.jni_YGNodeRemoveChild(this.mNativePointer, child.mNativePointer);
        return child;
    }

    @Override
    @Nullable
    public YogaNode getParent() {
        return this.mParent;
    }

    @Override
    public int indexOf(YogaNode child) {
        return this.mChildren == null ? -1 : this.mChildren.indexOf(child);
    }

    private native void jni_YGNodeCalculateLayout(long var1);

    @Override
    public void calculateLayout() {
        this.jni_YGNodeCalculateLayout(this.mNativePointer);
    }

    private native boolean jni_YGNodeHasNewLayout(long var1);

    @Override
    public boolean hasNewLayout() {
        return this.jni_YGNodeHasNewLayout(this.mNativePointer);
    }

    private native void jni_YGNodeMarkDirty(long var1);

    @Override
    public void dirty() {
        this.jni_YGNodeMarkDirty(this.mNativePointer);
    }

    private native boolean jni_YGNodeIsDirty(long var1);

    @Override
    public boolean isDirty() {
        return this.jni_YGNodeIsDirty(this.mNativePointer);
    }

    private native void jni_YGNodeMarkLayoutSeen(long var1);

    @Override
    public void markLayoutSeen() {
        this.jni_YGNodeMarkLayoutSeen(this.mNativePointer);
    }

    private native void jni_YGNodeCopyStyle(long var1, long var3);

    @Override
    public void copyStyle(YogaNode srcNode) {
        this.jni_YGNodeCopyStyle(this.mNativePointer, srcNode.mNativePointer);
    }

    private native int jni_YGNodeStyleGetDirection(long var1);

    @Override
    public YogaDirection getStyleDirection() {
        return YogaDirection.values()[this.jni_YGNodeStyleGetDirection(this.mNativePointer)];
    }

    private native void jni_YGNodeStyleSetDirection(long var1, int var3);

    @Override
    public void setDirection(YogaDirection direction) {
        this.jni_YGNodeStyleSetDirection(this.mNativePointer, direction.intValue());
    }

    private native int jni_YGNodeStyleGetFlexDirection(long var1);

    @Override
    public YogaFlexDirection getFlexDirection() {
        return YogaFlexDirection.values()[this.jni_YGNodeStyleGetFlexDirection(this.mNativePointer)];
    }

    private native void jni_YGNodeStyleSetFlexDirection(long var1, int var3);

    @Override
    public void setFlexDirection(YogaFlexDirection flexDirection) {
        this.jni_YGNodeStyleSetFlexDirection(this.mNativePointer, flexDirection.intValue());
    }

    private native int jni_YGNodeStyleGetJustifyContent(long var1);

    @Override
    public YogaJustify getJustifyContent() {
        return YogaJustify.values()[this.jni_YGNodeStyleGetJustifyContent(this.mNativePointer)];
    }

    private native void jni_YGNodeStyleSetJustifyContent(long var1, int var3);

    @Override
    public void setJustifyContent(YogaJustify justifyContent) {
        this.jni_YGNodeStyleSetJustifyContent(this.mNativePointer, justifyContent.intValue());
    }

    private native int jni_YGNodeStyleGetAlignItems(long var1);

    @Override
    public YogaAlign getAlignItems() {
        return YogaAlign.values()[this.jni_YGNodeStyleGetAlignItems(this.mNativePointer)];
    }

    private native void jni_YGNodeStyleSetAlignItems(long var1, int var3);

    @Override
    public void setAlignItems(YogaAlign alignItems) {
        this.jni_YGNodeStyleSetAlignItems(this.mNativePointer, alignItems.intValue());
    }

    private native int jni_YGNodeStyleGetAlignSelf(long var1);

    @Override
    public YogaAlign getAlignSelf() {
        return YogaAlign.values()[this.jni_YGNodeStyleGetAlignSelf(this.mNativePointer)];
    }

    private native void jni_YGNodeStyleSetAlignSelf(long var1, int var3);

    @Override
    public void setAlignSelf(YogaAlign alignSelf) {
        this.jni_YGNodeStyleSetAlignSelf(this.mNativePointer, alignSelf.intValue());
    }

    private native int jni_YGNodeStyleGetAlignContent(long var1);

    @Override
    public YogaAlign getAlignContent() {
        return YogaAlign.values()[this.jni_YGNodeStyleGetAlignContent(this.mNativePointer)];
    }

    private native void jni_YGNodeStyleSetAlignContent(long var1, int var3);

    @Override
    public void setAlignContent(YogaAlign alignContent) {
        this.jni_YGNodeStyleSetAlignContent(this.mNativePointer, alignContent.intValue());
    }

    private native int jni_YGNodeStyleGetPositionType(long var1);

    @Override
    public YogaPositionType getPositionType() {
        return YogaPositionType.values()[this.jni_YGNodeStyleGetPositionType(this.mNativePointer)];
    }

    private native void jni_YGNodeStyleSetPositionType(long var1, int var3);

    @Override
    public void setPositionType(YogaPositionType positionType) {
        this.jni_YGNodeStyleSetPositionType(this.mNativePointer, positionType.intValue());
    }

    private native void jni_YGNodeStyleSetFlexWrap(long var1, int var3);

    @Override
    public void setWrap(YogaWrap flexWrap) {
        this.jni_YGNodeStyleSetFlexWrap(this.mNativePointer, flexWrap.intValue());
    }

    private native int jni_YGNodeStyleGetOverflow(long var1);

    @Override
    public YogaOverflow getOverflow() {
        return YogaOverflow.values()[this.jni_YGNodeStyleGetOverflow(this.mNativePointer)];
    }

    private native void jni_YGNodeStyleSetOverflow(long var1, int var3);

    @Override
    public void setOverflow(YogaOverflow overflow) {
        this.jni_YGNodeStyleSetOverflow(this.mNativePointer, overflow.intValue());
    }

    private native void jni_YGNodeStyleSetFlex(long var1, float var3);

    @Override
    public void setFlex(float flex) {
        this.jni_YGNodeStyleSetFlex(this.mNativePointer, flex);
    }

    private native float jni_YGNodeStyleGetFlexGrow(long var1);

    @Override
    public float getFlexGrow() {
        return this.jni_YGNodeStyleGetFlexGrow(this.mNativePointer);
    }

    private native void jni_YGNodeStyleSetFlexGrow(long var1, float var3);

    @Override
    public void setFlexGrow(float flexGrow) {
        this.jni_YGNodeStyleSetFlexGrow(this.mNativePointer, flexGrow);
    }

    private native float jni_YGNodeStyleGetFlexShrink(long var1);

    @Override
    public float getFlexShrink() {
        return this.jni_YGNodeStyleGetFlexShrink(this.mNativePointer);
    }

    private native void jni_YGNodeStyleSetFlexShrink(long var1, float var3);

    @Override
    public void setFlexShrink(float flexShrink) {
        this.jni_YGNodeStyleSetFlexShrink(this.mNativePointer, flexShrink);
    }

    private native Object jni_YGNodeStyleGetFlexBasis(long var1);

    @Override
    public YogaValue getFlexBasis() {
        return (YogaValue)this.jni_YGNodeStyleGetFlexBasis(this.mNativePointer);
    }

    private native void jni_YGNodeStyleSetFlexBasis(long var1, float var3);

    @Override
    public void setFlexBasis(float flexBasis) {
        this.jni_YGNodeStyleSetFlexBasis(this.mNativePointer, flexBasis);
    }

    private native void jni_YGNodeStyleSetFlexBasisPercent(long var1, float var3);

    @Override
    public void setFlexBasisPercent(float percent) {
        this.jni_YGNodeStyleSetFlexBasisPercent(this.mNativePointer, percent);
    }

    private native Object jni_YGNodeStyleGetMargin(long var1, int var3);

    @Override
    public YogaValue getMargin(YogaEdge edge) {
        if (!this.mHasSetMargin) {
            return edge.intValue() < YogaEdge.START.intValue() ? YogaValue.ZERO : YogaValue.UNDEFINED;
        }
        return (YogaValue)this.jni_YGNodeStyleGetMargin(this.mNativePointer, edge.intValue());
    }

    private native void jni_YGNodeStyleSetMargin(long var1, int var3, float var4);

    @Override
    public void setMargin(YogaEdge edge, float margin) {
        this.mHasSetMargin = true;
        this.jni_YGNodeStyleSetMargin(this.mNativePointer, edge.intValue(), margin);
    }

    private native void jni_YGNodeStyleSetMarginPercent(long var1, int var3, float var4);

    @Override
    public void setMarginPercent(YogaEdge edge, float percent) {
        this.mHasSetMargin = true;
        this.jni_YGNodeStyleSetMarginPercent(this.mNativePointer, edge.intValue(), percent);
    }

    private native Object jni_YGNodeStyleGetPadding(long var1, int var3);

    @Override
    public YogaValue getPadding(YogaEdge edge) {
        if (!this.mHasSetPadding) {
            return edge.intValue() < YogaEdge.START.intValue() ? YogaValue.ZERO : YogaValue.UNDEFINED;
        }
        return (YogaValue)this.jni_YGNodeStyleGetPadding(this.mNativePointer, edge.intValue());
    }

    private native void jni_YGNodeStyleSetPadding(long var1, int var3, float var4);

    @Override
    public void setPadding(YogaEdge edge, float padding) {
        this.mHasSetPadding = true;
        this.jni_YGNodeStyleSetPadding(this.mNativePointer, edge.intValue(), padding);
    }

    private native void jni_YGNodeStyleSetPaddingPercent(long var1, int var3, float var4);

    @Override
    public void setPaddingPercent(YogaEdge edge, float percent) {
        this.mHasSetPadding = true;
        this.jni_YGNodeStyleSetPaddingPercent(this.mNativePointer, edge.intValue(), percent);
    }

    private native float jni_YGNodeStyleGetBorder(long var1, int var3);

    @Override
    public float getBorder(YogaEdge edge) {
        if (!this.mHasSetBorder) {
            return edge.intValue() < YogaEdge.START.intValue() ? 0.0f : Float.NaN;
        }
        return this.jni_YGNodeStyleGetBorder(this.mNativePointer, edge.intValue());
    }

    private native void jni_YGNodeStyleSetBorder(long var1, int var3, float var4);

    @Override
    public void setBorder(YogaEdge edge, float border) {
        this.mHasSetBorder = true;
        this.jni_YGNodeStyleSetBorder(this.mNativePointer, edge.intValue(), border);
    }

    private native Object jni_YGNodeStyleGetPosition(long var1, int var3);

    @Override
    public YogaValue getPosition(YogaEdge edge) {
        if (!this.mHasSetPosition) {
            return YogaValue.UNDEFINED;
        }
        return (YogaValue)this.jni_YGNodeStyleGetPosition(this.mNativePointer, edge.intValue());
    }

    private native void jni_YGNodeStyleSetPosition(long var1, int var3, float var4);

    @Override
    public void setPosition(YogaEdge edge, float position) {
        this.mHasSetPosition = true;
        this.jni_YGNodeStyleSetPosition(this.mNativePointer, edge.intValue(), position);
    }

    private native void jni_YGNodeStyleSetPositionPercent(long var1, int var3, float var4);

    @Override
    public void setPositionPercent(YogaEdge edge, float percent) {
        this.mHasSetPosition = true;
        this.jni_YGNodeStyleSetPositionPercent(this.mNativePointer, edge.intValue(), percent);
    }

    private native Object jni_YGNodeStyleGetWidth(long var1);

    @Override
    public YogaValue getWidth() {
        return (YogaValue)this.jni_YGNodeStyleGetWidth(this.mNativePointer);
    }

    private native void jni_YGNodeStyleSetWidth(long var1, float var3);

    @Override
    public void setWidth(float width) {
        this.jni_YGNodeStyleSetWidth(this.mNativePointer, width);
    }

    private native void jni_YGNodeStyleSetWidthPercent(long var1, float var3);

    @Override
    public void setWidthPercent(float percent) {
        this.jni_YGNodeStyleSetWidthPercent(this.mNativePointer, percent);
    }

    private native Object jni_YGNodeStyleGetHeight(long var1);

    @Override
    public YogaValue getHeight() {
        return (YogaValue)this.jni_YGNodeStyleGetHeight(this.mNativePointer);
    }

    private native void jni_YGNodeStyleSetHeight(long var1, float var3);

    @Override
    public void setHeight(float height) {
        this.jni_YGNodeStyleSetHeight(this.mNativePointer, height);
    }

    private native void jni_YGNodeStyleSetHeightPercent(long var1, float var3);

    @Override
    public void setHeightPercent(float percent) {
        this.jni_YGNodeStyleSetHeightPercent(this.mNativePointer, percent);
    }

    private native Object jni_YGNodeStyleGetMinWidth(long var1);

    @Override
    public YogaValue getMinWidth() {
        return (YogaValue)this.jni_YGNodeStyleGetMinWidth(this.mNativePointer);
    }

    private native void jni_YGNodeStyleSetMinWidth(long var1, float var3);

    @Override
    public void setMinWidth(float minWidth) {
        this.jni_YGNodeStyleSetMinWidth(this.mNativePointer, minWidth);
    }

    private native void jni_YGNodeStyleSetMinWidthPercent(long var1, float var3);

    @Override
    public void setMinWidthPercent(float percent) {
        this.jni_YGNodeStyleSetMinWidthPercent(this.mNativePointer, percent);
    }

    private native Object jni_YGNodeStyleGetMinHeight(long var1);

    @Override
    public YogaValue getMinHeight() {
        return (YogaValue)this.jni_YGNodeStyleGetMinHeight(this.mNativePointer);
    }

    private native void jni_YGNodeStyleSetMinHeight(long var1, float var3);

    @Override
    public void setMinHeight(float minHeight) {
        this.jni_YGNodeStyleSetMinHeight(this.mNativePointer, minHeight);
    }

    private native void jni_YGNodeStyleSetMinHeightPercent(long var1, float var3);

    @Override
    public void setMinHeightPercent(float percent) {
        this.jni_YGNodeStyleSetMinHeightPercent(this.mNativePointer, percent);
    }

    private native Object jni_YGNodeStyleGetMaxWidth(long var1);

    @Override
    public YogaValue getMaxWidth() {
        return (YogaValue)this.jni_YGNodeStyleGetMaxWidth(this.mNativePointer);
    }

    private native void jni_YGNodeStyleSetMaxWidth(long var1, float var3);

    @Override
    public void setMaxWidth(float maxWidth) {
        this.jni_YGNodeStyleSetMaxWidth(this.mNativePointer, maxWidth);
    }

    private native void jni_YGNodeStyleSetMaxWidthPercent(long var1, float var3);

    @Override
    public void setMaxWidthPercent(float percent) {
        this.jni_YGNodeStyleSetMaxWidthPercent(this.mNativePointer, percent);
    }

    private native Object jni_YGNodeStyleGetMaxHeight(long var1);

    @Override
    public YogaValue getMaxHeight() {
        return (YogaValue)this.jni_YGNodeStyleGetMaxHeight(this.mNativePointer);
    }

    private native void jni_YGNodeStyleSetMaxHeight(long var1, float var3);

    @Override
    public void setMaxHeight(float maxheight) {
        this.jni_YGNodeStyleSetMaxHeight(this.mNativePointer, maxheight);
    }

    private native void jni_YGNodeStyleSetMaxHeightPercent(long var1, float var3);

    @Override
    public void setMaxHeightPercent(float percent) {
        this.jni_YGNodeStyleSetMaxHeightPercent(this.mNativePointer, percent);
    }

    private native float jni_YGNodeStyleGetAspectRatio(long var1);

    public float getAspectRatio() {
        return this.jni_YGNodeStyleGetAspectRatio(this.mNativePointer);
    }

    private native void jni_YGNodeStyleSetAspectRatio(long var1, float var3);

    public void setAspectRatio(float aspectRatio) {
        this.jni_YGNodeStyleSetAspectRatio(this.mNativePointer, aspectRatio);
    }

    @Override
    public float getLayoutX() {
        return this.mLeft;
    }

    @Override
    public float getLayoutY() {
        return this.mTop;
    }

    @Override
    public float getLayoutWidth() {
        return this.mWidth;
    }

    @Override
    public float getLayoutHeight() {
        return this.mHeight;
    }

    @Override
    public float getLayoutMargin(YogaEdge edge) {
        switch (edge) {
            case LEFT: {
                return this.mMarginLeft;
            }
            case TOP: {
                return this.mMarginTop;
            }
            case RIGHT: {
                return this.mMarginRight;
            }
            case BOTTOM: {
                return this.mMarginBottom;
            }
            case START: {
                return this.getLayoutDirection() == YogaDirection.RTL ? this.mMarginRight : this.mMarginLeft;
            }
            case END: {
                return this.getLayoutDirection() == YogaDirection.RTL ? this.mMarginLeft : this.mMarginRight;
            }
        }
        throw new IllegalArgumentException("Cannot get layout margins of multi-edge shorthands");
    }

    @Override
    public float getLayoutPadding(YogaEdge edge) {
        switch (edge) {
            case LEFT: {
                return this.mPaddingLeft;
            }
            case TOP: {
                return this.mPaddingTop;
            }
            case RIGHT: {
                return this.mPaddingRight;
            }
            case BOTTOM: {
                return this.mPaddingBottom;
            }
            case START: {
                return this.getLayoutDirection() == YogaDirection.RTL ? this.mPaddingRight : this.mPaddingLeft;
            }
            case END: {
                return this.getLayoutDirection() == YogaDirection.RTL ? this.mPaddingLeft : this.mPaddingRight;
            }
        }
        throw new IllegalArgumentException("Cannot get layout paddings of multi-edge shorthands");
    }

    @Override
    public YogaDirection getLayoutDirection() {
        return YogaDirection.values()[this.mLayoutDirection];
    }

    private native void jni_YGNodeSetHasMeasureFunc(long var1, boolean var3);

    @Override
    public void setMeasureFunction(YogaMeasureFunction measureFunction) {
        this.mMeasureFunction = measureFunction;
        this.jni_YGNodeSetHasMeasureFunc(this.mNativePointer, measureFunction != null);
    }

    @DoNotStrip
    public final long measure(float width, int widthMode, float height, int heightMode) {
        if (!this.isMeasureDefined()) {
            throw new RuntimeException("Measure function isn't defined!");
        }
        return this.mMeasureFunction.measure(this, width, YogaMeasureMode.values()[widthMode], height, YogaMeasureMode.values()[heightMode]);
    }

    private native void jni_YGNodeSetHasBaselineFunc(long var1, boolean var3);

    @Override
    public void setBaselineFunction(YogaBaselineFunction baselineFunction) {
        this.mBaselineFunction = baselineFunction;
        this.jni_YGNodeSetHasBaselineFunc(this.mNativePointer, baselineFunction != null);
    }

    @DoNotStrip
    public final float baseline(float width, float height) {
        return this.mBaselineFunction.baseline(this, width, height);
    }

    @Override
    public boolean isMeasureDefined() {
        return this.mMeasureFunction != null;
    }

    @Override
    public void setData(Object data) {
        this.mData = data;
    }

    @Override
    public Object getData() {
        return this.mData;
    }

    static {
        SoLoader.loadLibrary((String)"yoga");
    }
}

