/*
 * Decompiled with CFR 0.152.
 */
package com.pushbots.push;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.pushbots.push.Pushbots;
import com.pushbots.push.utils.PBPrefs;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

class DeviceInfo {
    private static List<String> invalidAndroidUDID = new ArrayList<String>();

    DeviceInfo() {
    }

    public static String getOSVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getDevice() {
        return Build.MODEL;
    }

    public static String getResolution() {
        WindowManager wm = (WindowManager)Pushbots.mContext.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        return metrics.heightPixels + "x" + metrics.widthPixels;
    }

    public static String getCarrier() {
        TelephonyManager manager = (TelephonyManager)Pushbots.mContext.getSystemService("phone");
        String carrierName = manager.getNetworkOperatorName();
        return "".equals(carrierName) ? null : carrierName;
    }

    public static String getMCC() {
        TelephonyManager manager = (TelephonyManager)Pushbots.mContext.getSystemService("phone");
        return manager.getNetworkCountryIso();
    }

    public static String getLocale() {
        Locale locale = Locale.getDefault();
        return locale.getLanguage() + "_" + locale.getCountry();
    }

    public static int getTz() {
        TimeZone timezone = TimeZone.getDefault();
        return timezone.getRawOffset();
    }

    @SuppressLint(value={"WorldWriteableFiles"})
    public static String getUDID(Context paramContext) {
        String udid = Settings.Secure.getString((ContentResolver)paramContext.getContentResolver(), (String)"android_id");
        if (null != udid && !invalidAndroidUDID.contains(udid)) {
            return udid;
        }
        try {
            TelephonyManager tm = (TelephonyManager)paramContext.getSystemService("phone");
            String imei = tm.getDeviceId();
            if (null != imei) {
                return imei;
            }
        }
        catch (RuntimeException tm) {
            // empty catch block
        }
        String stored_udid = PBPrefs.getGeneratedUDID(paramContext);
        if (null != stored_udid) {
            return stored_udid;
        }
        stored_udid = UUID.randomUUID().toString();
        PBPrefs.setGeneratedUDID(paramContext, stored_udid);
        return stored_udid;
    }

    public static String getAppVersion() {
        String result = "1.0";
        try {
            result = Pushbots.mContext.getPackageManager().getPackageInfo((String)Pushbots.mContext.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return result;
    }

    static {
        invalidAndroidUDID.add("9774d56d682e549c");
    }
}

