/*
 * Decompiled with CFR 0.152.
 */
package com.pushbots.push;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import com.pushbots.push.DefaultPushHandler;
import com.pushbots.push.PBGenerate;
import com.pushbots.push.PBNotification;
import com.pushbots.push.PBNotificationBuildListener;
import com.pushbots.push.utils.Log;
import java.util.Random;

public class PBGenerateNotification
implements PBGenerate,
PBNotificationBuildListener {
    private Bundle extras;
    private Context mContext;
    private Intent intent;
    private NotificationManager manager;

    @Override
    public void generateNotification(Context context, Intent intent, Handler handler) {
        this.extras = intent.getExtras();
        this.mContext = context;
        this.intent = intent;
        if (this.extras == null) {
            return;
        }
        CharSequence appName = context.getPackageManager().getApplicationLabel(context.getApplicationInfo());
        if (appName == null) {
            appName = "Notification";
        }
        String notificationTitle = appName.toString();
        String notificationMessage = (String)this.extras.get("message");
        this.manager = (NotificationManager)context.getSystemService("notification");
        if (this.extras.containsKey("customNotificationTitle")) {
            String customTitle = (String)this.extras.get("customNotificationTitle");
            Log.d("notification title set to " + customTitle);
            notificationTitle = customTitle;
        }
        PBNotification not = new PBNotification(context, this.extras, notificationTitle, notificationMessage);
        not.setNotificationBuildListener(this);
        not.generateNotification();
    }

    private static boolean checkVibrationPermission(Context context) {
        String permission = "android.permission.VIBRATE";
        int res = context.checkCallingOrSelfPermission(permission);
        return res == 0;
    }

    @Override
    public void onPBNotificationReady(PBNotification not) {
        boolean vibrate;
        String cancel;
        String priority;
        if (this.extras.containsKey("cancel")) {
            Log.d("notification will NOT be canceled from status bar when it is clicked by the user.");
        } else {
            not.addCancel();
        }
        if (this.extras.containsKey("sound")) {
            String sound = (String)this.extras.get("sound");
            Log.d("notification Sound set to " + sound);
            not.addSound(this.mContext, sound);
        } else {
            not.addDefaultSound();
        }
        if (this.extras.containsKey("priority") && (priority = (String)this.extras.get("priority")).equals("high")) {
            not.addPriority(2);
        }
        if (this.extras.containsKey("vibration") && null != (cancel = (String)this.extras.get("vibration")) && cancel.equals("true")) {
            Log.d("Vibration Enabled.");
            if (PBGenerateNotification.checkVibrationPermission(this.mContext)) {
                not.addVibration();
            } else {
                Log.e("Vibration PERMISSION not set in Manifest.");
            }
        }
        if (this.extras.containsKey("vib") && (vibrate = Boolean.parseBoolean((String)this.extras.get("vib")))) {
            Log.d("Vibration Enabled.");
            if (PBGenerateNotification.checkVibrationPermission(this.mContext)) {
                not.addVibration();
            } else {
                Log.e("Vibration PERMISSION not set in Manifest.");
            }
        }
        Notification notification = not.getNotification();
        try {
            int messageId = new Random().nextInt();
            Bundle bundle = this.intent.getExtras();
            SharedPreferences sharedPref = this.mContext.getSharedPreferences("com.pushbots", 0);
            String handler = sharedPref.getString("custom_handler", null);
            Intent notifyIntent = new Intent("com.pushbots.MSG_OPEN");
            notifyIntent.putExtra("pushData", this.extras);
            notifyIntent.putExtra("com.pushbots.MSG_OPEN", bundle);
            if (handler != null) {
                try {
                    notifyIntent.setClass(this.mContext, Class.forName(handler));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                notifyIntent.setClass(this.mContext, DefaultPushHandler.class);
            }
            int requestID = (int)System.currentTimeMillis();
            notification.contentIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)requestID, (Intent)notifyIntent, (int)0x8000000);
            this.manager.notify(messageId, notification);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }
}

