/*
 * Decompiled with CFR 0.152.
 */
package com.pushbots.push;

import android.app.Notification;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import com.pushbots.push.NotificationBuildListener;
import com.pushbots.push.PBNotificationBuildListener;
import com.pushbots.push.PBNotificationIntent;
import com.pushbots.push.utils.Log;

public class PBNotification
implements NotificationBuildListener {
    private Notification mNotification;
    private Context mContext;
    private Bundle mData;
    private String mAppName;
    private String mTitle;
    private PBNotificationBuildListener mNotificationBuildListener;

    public PBNotification(Context context, Bundle data, String appName, String title) {
        this.mContext = context;
        this.mData = data;
        this.mAppName = appName;
        this.mTitle = title;
    }

    public void generateNotification() {
        int resId = this.getContext().getResources().getIdentifier("new_push_message", "string", this.getContext().getPackageName());
        if (0 != resId) {
            String newMessageString = this.getContext().getString(resId);
            this.generateNotificationInner(this.getContext(), this.getData(), this.mAppName, newMessageString);
            return;
        }
        this.generateNotificationInner(this.getContext(), this.getData(), this.mAppName, this.getTitle());
    }

    private void generateNotificationInner(Context context, Bundle data, String appName, String tickerTitle) {
        String tickerTitle1 = tickerTitle;
        PBNotificationIntent pbNotificationIntent = new PBNotificationIntent();
        pbNotificationIntent.setNotificationBuildListener(this);
        pbNotificationIntent.buildNotification(this.getContext(), this.getData(), this.mAppName, this.mTitle);
    }

    public void addPriority(int priority) {
        int i = priority;
        if (Math.abs(priority) > 2) {
            Log.w("Unsupported priority: " + priority + ", setting to default: 0");
            i = 0;
        }
        switch (i) {
            case -2: {
                priority = -1;
                break;
            }
            case -1: {
                priority = -2;
                break;
            }
            case 0: {
                priority = 0;
                break;
            }
            case 1: {
                priority = 1;
                break;
            }
            case 2: {
                priority = 2;
                break;
            }
            default: {
                priority = 0;
            }
        }
        this.mNotification.priority = priority;
    }

    public void addSound(Context context, String sound) {
        int soundId;
        if (sound != null && !sound.matches("^[0-9]") && 0 != (soundId = context.getResources().getIdentifier(sound, "raw", context.getPackageName()))) {
            this.mNotification.sound = Uri.parse((String)("android.resource" + context.getPackageName() + "/" + soundId));
            return;
        }
        soundId = context.getResources().getIdentifier("pushbots_notification_sound", "raw", context.getPackageName());
        if (0 != soundId) {
            this.mNotification.sound = Uri.parse((String)("android.resource" + context.getPackageName() + "/" + soundId));
        }
    }

    public void addDefaultSound() {
        this.mNotification.defaults |= 1;
    }

    public void addVibration() {
        this.mNotification.defaults |= 2;
    }

    public void addCancel() {
        this.mNotification.flags |= 0x10;
    }

    public Notification getNotification() {
        return this.mNotification;
    }

    protected Context getContext() {
        return this.mContext;
    }

    protected Bundle getData() {
        return this.mData;
    }

    protected String getTitle() {
        return this.mTitle;
    }

    public void setNotificationBuildListener(PBNotificationBuildListener notificationBuildListener) {
        this.mNotificationBuildListener = notificationBuildListener;
    }

    @Override
    public void onNotificationReady(Notification notification) {
        notification.defaults |= 4;
        this.mNotification = notification;
        this.mNotificationBuildListener.onPBNotificationReady(this);
    }
}

