/*
 * Decompiled with CFR 0.152.
 */
package com.pushbots.push;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.pushbots.push.DeviceInfo;
import com.pushbots.push.GCMRegistrar;
import com.pushbots.push.PBClient;
import com.pushbots.push.PBGenerate;
import com.pushbots.push.PBGenerateNotification;
import com.pushbots.push.PBLogger;
import com.pushbots.push.utils.Log;
import com.pushbots.push.utils.Logger;
import com.pushbots.push.utils.PBPrefs;
import com.pushbots.push.utils.utils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Pushbots {
    static Context mContext;
    private static String mAppId;
    private static String mProjectNumber;
    private static GCMRegistrar pushRegistrar;
    private static String currentDeviceUDID;
    private Class<? extends BroadcastReceiver> intentReceiver;
    private static PBGenerate notificationBuilder;
    private static registeredHandler regHandler;
    private Logger mLogger;
    private static boolean startedRegistration;
    private static boolean registerForGCMFired;
    private static boolean ranSessionInitThread;
    private static String registrationId;
    private static Pushbots mPushbots;

    static Context getContext() {
        return mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pushbots sharedInstance() {
        Class<Pushbots> clazz = Pushbots.class;
        synchronized (Pushbots.class) {
            if (mPushbots == null) {
                mPushbots = new Pushbots();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mPushbots;
        }
    }

    private Pushbots() {
        pushRegistrar = new GCMRegistrar();
        notificationBuilder = new PBGenerateNotification();
        this.mLogger = new PBLogger();
    }

    public void init(Context ctx) {
        this.initialize(ctx, null, null, null);
    }

    public void init(Context ctx, String log_level, String application_id, String sender_id) {
        Log.v("Entered custom init function " + application_id + sender_id);
        this.initialize(ctx, log_level, application_id, sender_id);
    }

    public void initialize(Context ctx, String log_level, String application_id, String sender_id) {
        mContext = ctx;
        utils.checkNotNull(ctx, "context");
        Context context = ctx.getApplicationContext();
        try {
            Logger.LogLevel logLevel;
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            if (log_level == null) {
                log_level = bundle.getString("pushbots_loglevel");
            }
            Log.i("Loglevel: " + log_level);
            if (log_level != null && (logLevel = this.getLogLevelFromString(log_level)) != null) {
                this.getLogger().setLevel(logLevel);
            }
            if (application_id == null && sender_id == null) {
                application_id = bundle.getString("pushbots_app_id");
                sender_id = bundle.getString("google_sender_id").substring(2);
            }
        }
        catch (Throwable t) {
            Log.e("Bundle error:" + t);
        }
        Log.i("PushBots Library v3.0.1");
        String stored_device_udid = PBPrefs.getUDID(ctx);
        if (TextUtils.isEmpty((CharSequence)stored_device_udid)) {
            stored_device_udid = DeviceInfo.getUDID(ctx);
        }
        Pushbots.setDeviceId(ctx, stored_device_udid);
        if (TextUtils.isEmpty((CharSequence)sender_id) || TextUtils.isEmpty((CharSequence)application_id)) {
            Log.e("Cannot find Google Sender Id or PushBots application Id in build.gradle");
            return;
        }
        if (!Pushbots.isValidApplicationId(application_id)) {
            Log.e("PushBots AppId is invalid.\nExample: '56f6ef1c4a9efa75938b4564'\n");
            return;
        }
        if (application_id.equals("56f6ef1c4a9efa75938b4564")) {
            Log.e("You're using PushBots example Id stated in documentation, Please update it and follow instructions in this link:");
            return;
        }
        mAppId = application_id;
        try {
            if (sender_id.length() < 8 || sender_id.length() > 16) {
                throw new IllegalArgumentException("Google Sender Id is invalid.");
            }
        }
        catch (Throwable t) {
            Log.e("Google Sender Id format is invalid. Please use the 10 to 14 digit number found in the Google Developer Console for your project.\nExample: '703322744261'\n" + t);
        }
        try {
            Class.forName("com.google.android.gms.gcm.GoogleCloudMessaging");
        }
        catch (ClassNotFoundException e) {
            Log.e("The GCM Google Play services client library was not found. Please make sure to include it in your project." + e);
        }
        try {
            Class.forName("android.support.v4.view.MenuCompat");
            try {
                Class.forName("android.support.v4.content.WakefulBroadcastReceiver");
                Class.forName("android.support.v4.app.NotificationManagerCompat");
            }
            catch (ClassNotFoundException e) {
                Log.e("The included Android Support Library v4 is to old or incomplete. Please update your project's android-support-v4.jar to the latest revision." + e);
            }
        }
        catch (ClassNotFoundException e) {
            Log.e("Could not find the Android Support Library v4. Please make sure android-support-v4.jar has been correctly added to your project." + e);
        }
        mProjectNumber = sender_id;
        Log.i("Application ID = " + application_id);
        Log.i("Google Sender Id = " + sender_id);
        String registeredApplicationId = PBPrefs.getApplicationId(ctx);
        if (registeredApplicationId != null) {
            if (!registeredApplicationId.equals(application_id)) {
                Log.d("APP ID has been changed, updating data.");
                PBPrefs.setApplicationId(ctx, application_id);
                PBPrefs.setObjectId(ctx, null);
            }
        } else {
            PBPrefs.setApplicationId(ctx, application_id);
        }
        PBPrefs.setCustomHandler(mContext, null);
    }

    private static boolean isValidApplicationId(String hexString) {
        if (hexString == null) {
            throw new IllegalArgumentException();
        }
        int len = hexString.length();
        if (len != 24) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public void registerForRemoteNotifications() {
        if (startedRegistration) {
            return;
        }
        startedRegistration = true;
        pushRegistrar.registerForPush(mContext, mProjectNumber, new GCMRegistrar.RegisteredHandler(){

            @Override
            public void complete(String id) {
                Log.i("Google Registration ID = \n" + id);
                PBPrefs.setToken(mContext, id);
                registrationId = id;
                registerForGCMFired = true;
                if (PBPrefs.getObjectId(mContext) != null) {
                    Pushbots.updateSubscribe(PBPrefs.getObjectId(mContext));
                } else {
                    Pushbots.subscribe();
                }
            }
        });
    }

    private static void subscribe() {
        if (!registerForGCMFired) {
            return;
        }
        ranSessionInitThread = true;
        Log.i("Subscribe on PushBots");
        try {
            JSONObject json = new JSONObject();
            json.put("token", (Object)registrationId);
            json.put("uuid", (Object)DeviceInfo.getUDID(mContext));
            json.put("platform", (Object)"1");
            json.put("timeZone", DeviceInfo.getTz());
            json.put("countryCode", (Object)DeviceInfo.getMCC());
            JSONObject metrics = new JSONObject();
            metrics.put("appVersion", (Object)DeviceInfo.getAppVersion());
            metrics.put("resolution", (Object)DeviceInfo.getResolution());
            metrics.put("deviceModel", (Object)DeviceInfo.getDevice());
            metrics.put("locale", (Object)DeviceInfo.getLocale());
            metrics.put("PushBotslibVersion", (Object)"3.0.1");
            metrics.put("osVersion", (Object)DeviceInfo.getOSVersion());
            metrics.put("carrier", (Object)DeviceInfo.getCarrier());
            json.put("metrics", (Object)metrics);
            PBClient.postAsync(mAppId, "2/subscriptions", json, new PBClient.ResponseHandler(){

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    if (response != null) {
                        Log.e("Request Error: " + response);
                    }
                }

                @Override
                void onSuccess(String response) {
                    try {
                        JSONObject jsonObject = new JSONObject(response);
                        Log.d("Pushbots ObjectId:" + jsonObject.get("_id"));
                        if (jsonObject.getString("_id") != null) {
                            PBPrefs.setObjectId(mContext, jsonObject.getString("_id"));
                            Pushbots.registeredCallback();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static void updateSubscribe(final String objectId) {
        if (!registerForGCMFired) {
            return;
        }
        ranSessionInitThread = true;
        Log.i("Update device data on PushBots");
        try {
            JSONObject json = new JSONObject();
            json.put("token", (Object)registrationId);
            json.put("appID", (Object)mAppId);
            json.put("uuid", (Object)DeviceInfo.getUDID(mContext));
            json.put("platform", (Object)"1");
            json.put("timeZone", DeviceInfo.getTz());
            json.put("countryCode", (Object)DeviceInfo.getMCC());
            JSONObject metrics = new JSONObject();
            metrics.put("appVersion", (Object)DeviceInfo.getAppVersion());
            metrics.put("resolution", (Object)DeviceInfo.getResolution());
            metrics.put("deviceModel", (Object)DeviceInfo.getDevice());
            metrics.put("locale", (Object)DeviceInfo.getLocale());
            metrics.put("PushBotslibVersion", (Object)"3.0.1");
            metrics.put("osVersion", (Object)DeviceInfo.getOSVersion());
            metrics.put("carrier", (Object)DeviceInfo.getCarrier());
            json.put("metrics", (Object)metrics);
            PBClient.putAsync(mAppId, "2/subscriptions/" + objectId, json, new PBClient.ResponseHandler(){

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    if (statusCode == 202) {
                        Log.w("Resetting ObjectId as device not found on PushBots, \nDevice will register when you close and re-open the app");
                        PBPrefs.setObjectId(mContext, null);
                    } else {
                        Log.e("Request Error: " + response);
                    }
                }

                @Override
                void onSuccess(String response) {
                    Log.d(objectId + " /" + response);
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void update(JSONObject json) {
        final String objectId = PBPrefs.getObjectId(mContext);
        if (objectId == null) {
            Log.i("Device must be registered on PushBots.");
            return;
        }
        PBClient.putAsync(mAppId, "2/subscriptions/" + objectId, json, new PBClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                Log.d(objectId + " /" + response);
            }

            @Override
            void onSuccess(String response) {
                Log.d(objectId + " /" + response);
            }
        });
    }

    public void toggleNotifications(boolean subscribed) {
        try {
            JSONObject json = new JSONObject();
            json.put("subscribed", subscribed);
            Pushbots.update(json);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void debug(boolean debug) {
        try {
            JSONObject json = new JSONObject();
            json.put("debug", debug);
            Pushbots.update(json);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void setAlias(String alias) {
        try {
            JSONObject json = new JSONObject();
            json.put("alias", (Object)alias);
            Pushbots.update(json);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void removeAlias() {
        try {
            JSONObject json = new JSONObject();
            json.put("remove_alias", true);
            Pushbots.update(json);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void tag(JSONArray tags) {
        try {
            JSONObject json = new JSONObject();
            json.put("tags_add", (Object)tags);
            Pushbots.update(json);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void untag(JSONArray tags) {
        try {
            JSONObject json = new JSONObject();
            json.put("tags_remove", (Object)tags);
            Pushbots.update(json);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void tag(String tag) {
        try {
            JSONArray tags = new JSONArray();
            tags.put((Object)tag);
            JSONObject json = new JSONObject();
            json.put("tags_add", (Object)tags);
            Pushbots.update(json);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void untag(String tag) {
        try {
            JSONArray tags = new JSONArray();
            tags.put((Object)tag);
            JSONObject json = new JSONObject();
            json.put("tags_remove", (Object)tags);
            Pushbots.update(json);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void PushNotificationOpened(Context context, Bundle bundle) {
        try {
            JSONObject json = new JSONObject();
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ", Locale.getDefault());
            df.setTimeZone(tz);
            String nowAsISO = df.format(new Date());
            SharedPreferences sharedPref = context.getSharedPreferences("com.pushbots", 0);
            String objectId = sharedPref.getString("pushbots_object_id", null);
            String appId = sharedPref.getString("application_id", null);
            json.put("date", (Object)nowAsISO);
            json.put("push_id", (Object)bundle.getString("pb_n_id"));
            json.put("device_id", (Object)objectId);
            json.put("platform", 1);
            PBClient.postAsync(appId, "2/pushOpened", json, new PBClient.ResponseHandler(){

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    Log.d(response);
                }

                @Override
                void onSuccess(String response) {
                    Log.d(response);
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void registered(registeredHandler inRegHandler) {
        regHandler = inRegHandler;
    }

    private static void registeredCallback() {
        if (regHandler != null) {
            Pushbots.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Pushbots.internalRegisteredCallback();
                }
            });
        }
    }

    static void runOnUiThread(Runnable action) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(action);
    }

    private static void internalRegisteredCallback() {
        if (regHandler == null) {
            return;
        }
        String regId = PBPrefs.getToken(mContext);
        String userId = PBPrefs.getObjectId(mContext);
        regHandler.registered(userId, regId);
    }

    private static void setDeviceId(Context paramContext, String paramString) {
        if (currentDeviceUDID != null && currentDeviceUDID.equals(paramString)) {
            return;
        }
        currentDeviceUDID = paramString;
        PBPrefs.setUDID(paramContext.getApplicationContext(), paramString);
    }

    public static Class<?> CustomHandler() {
        return Pushbots.mPushbots.intentReceiver;
    }

    public void setCustomHandler(Class<? extends BroadcastReceiver> paramClass) {
        try {
            Class.forName(paramClass.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            Log.e("Custom Handler function " + paramClass.getCanonicalName() + "doesn't exist");
            return;
        }
        PBPrefs.setCustomHandler(mContext, paramClass.getName());
        ComponentName localComponentName = new ComponentName(mContext.getPackageName(), paramClass.getCanonicalName());
        try {
            mContext.getPackageManager().getReceiverInfo(localComponentName, 128);
        }
        catch (PackageManager.NameNotFoundException localNameNotFoundException) {
            Log.e("AndroidManifest.xml missing required receiver: " + paramClass.getCanonicalName());
            return;
        }
        Pushbots.mPushbots.intentReceiver = paramClass;
    }

    public boolean isNotificationEnabled() {
        return PBPrefs.isNotificationEnabled(mContext);
    }

    public static void setNotificationEnabled(boolean status) {
        PBPrefs.setNotificationEnabled(mContext, status);
    }

    public static PBGenerate NotificationBuilder() {
        return notificationBuilder;
    }

    private Logger.LogLevel getLogLevelFromString(String logLevelString) {
        try {
            return Logger.LogLevel.valueOf(logLevelString.toUpperCase(Locale.getDefault()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public Logger getLogger() {
        return this.mLogger;
    }

    public String getUserId() {
        String objectId = PBPrefs.getObjectId(mContext);
        if (objectId == null) {
            Log.i("Device must be registered on PushBots.");
            return null;
        }
        return PBPrefs.getObjectId(mContext);
    }

    public String getGCMRegistrationId() {
        String objectId = PBPrefs.getObjectId(mContext);
        if (objectId == null) {
            Log.i("Device must be registered on PushBots.");
            return null;
        }
        return PBPrefs.getToken(mContext);
    }

    public String regID() {
        return this.getGCMRegistrationId();
    }

    static {
        currentDeviceUDID = "";
        mPushbots = null;
    }

    public static interface registeredHandler {
        public void registered(String var1, String var2);
    }
}

