/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.util.zza;
import com.google.android.gms.internal.zzbao;
import com.google.android.gms.internal.zzbap;
import com.google.android.gms.internal.zzbaq;
import com.google.android.gms.internal.zzbar;
import com.google.android.gms.internal.zzbat;
import com.google.android.gms.internal.zzbav;
import com.google.android.gms.internal.zzbaw;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbay;
import com.google.android.gms.internal.zzbbw;
import com.google.android.gms.internal.zzbdc;
import com.google.android.gms.internal.zzbdd;
import com.google.android.gms.internal.zzbdy;
import com.google.android.gms.internal.zzbed;
import com.google.android.gms.internal.zzbee;
import com.google.android.gms.internal.zzbef;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.internal.zzbeq;
import com.google.android.gms.internal.zzbey;
import com.google.android.gms.internal.zzctk;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzbdb
implements Handler.Callback {
    public static final Status zzaEc = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status zzaEd = new Status(4, "The user must be signed in to make this API call.");
    private long zzaDC = 5000L;
    private long zzaDB = 120000L;
    private long zzaEe = 10000L;
    private static final Object zzuF = new Object();
    private static zzbdb zzaEf;
    private final Context mContext;
    private final GoogleApiAvailability zzaBd;
    private int zzaEg = -1;
    private final AtomicInteger zzaEh = new AtomicInteger(1);
    private final AtomicInteger zzaEi = new AtomicInteger(0);
    private final Map<zzbat<?>, zzbdd<?>> zzaCB = new ConcurrentHashMap(5, 0.75f, 1);
    private zzbbw zzaEj = null;
    private final Set<zzbat<?>> zzaEk = new zza();
    private final Set<zzbat<?>> zzaEl = new zza();
    private final Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbdb zzay(Context context) {
        Object object = zzuF;
        synchronized (object) {
            if (zzaEf == null) {
                HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
                handlerThread.start();
                Looper looper = handlerThread.getLooper();
                zzaEf = new zzbdb(context.getApplicationContext(), looper, GoogleApiAvailability.getInstance());
            }
            return zzaEf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbdb zzqk() {
        Object object = zzuF;
        synchronized (object) {
            zzbo.zzb((Object)zzaEf, (Object)"Must guarantee manager is non-null before using getInstance");
            return zzaEf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzql() {
        Object object = zzuF;
        synchronized (object) {
            if (zzaEf != null) {
                zzbdb zzbdb2 = zzaEf;
                zzbdb2.zzaEi.incrementAndGet();
                zzbdb2.mHandler.sendMessageAtFrontOfQueue(zzbdb2.mHandler.obtainMessage(10));
            }
            return;
        }
    }

    private zzbdb(Context context, Looper looper, GoogleApiAvailability googleApiAvailability) {
        this.mContext = context;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
        this.zzaBd = googleApiAvailability;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6));
    }

    public final int zzqm() {
        return this.zzaEh.getAndIncrement();
    }

    public final void zzb(GoogleApi<?> googleApi) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, googleApi));
    }

    @WorkerThread
    private final void zzc(GoogleApi<?> googleApi) {
        zzbat<?> zzbat2 = googleApi.zzph();
        zzbdd<Object> zzbdd2 = this.zzaCB.get(zzbat2);
        if (zzbdd2 == null) {
            zzbdd2 = new zzbdd(this, googleApi);
            this.zzaCB.put(zzbat2, zzbdd2);
        }
        if (zzbdd2.zzmv()) {
            this.zzaEl.add(zzbat2);
        }
        zzbdd2.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(@NonNull zzbbw zzbbw2) {
        Object object = zzuF;
        synchronized (object) {
            if (this.zzaEj != zzbbw2) {
                this.zzaEj = zzbbw2;
                this.zzaEk.clear();
                this.zzaEk.addAll((Collection<zzbat<?>>)zzbbw2.zzpR());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzb(@NonNull zzbbw zzbbw2) {
        Object object = zzuF;
        synchronized (object) {
            if (this.zzaEj == zzbbw2) {
                this.zzaEj = null;
                this.zzaEk.clear();
            }
            return;
        }
    }

    public final Task<Void> zza(Iterable<? extends GoogleApi<?>> iterable) {
        zzbav zzbav2 = new zzbav(iterable);
        for (GoogleApi<?> googleApi : iterable) {
            zzbdd<?> zzbdd2 = this.zzaCB.get(googleApi.zzph());
            if (zzbdd2 != null && zzbdd2.isConnected()) continue;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, (Object)zzbav2));
            return zzbav2.getTask();
        }
        zzbav2.zzpu();
        return zzbav2.getTask();
    }

    public final void zzps() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3));
    }

    final void zzpl() {
        this.zzaEi.incrementAndGet();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(10));
    }

    @WorkerThread
    private final void zzqn() {
        for (zzbat<?> zzbat2 : this.zzaEl) {
            this.zzaCB.remove(zzbat2).signOut();
        }
        this.zzaEl.clear();
    }

    public final <O extends Api.ApiOptions> void zza(GoogleApi<O> googleApi, int n, zzbay<? extends Result, Api.zzb> zzbay2) {
        zzbao<zzbay<? extends Result, Api.zzb>> zzbao2 = new zzbao<zzbay<? extends Result, Api.zzb>>(n, zzbay2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)new zzbed(zzbao2, this.zzaEi.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions, TResult> void zza(GoogleApi<O> googleApi, int n, zzbeq<Api.zzb, TResult> zzbeq2, TaskCompletionSource<TResult> taskCompletionSource, zzbem zzbem2) {
        zzbaq<TResult> zzbaq2 = new zzbaq<TResult>(n, zzbeq2, taskCompletionSource, zzbem2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)new zzbed(zzbaq2, this.zzaEi.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions> Task<Void> zza(@NonNull GoogleApi<O> googleApi, @NonNull zzbee<Api.zzb, ?> zzbee2, @NonNull zzbey<Api.zzb, ?> zzbey2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzbap zzbap2 = new zzbap(new zzbef(zzbee2, zzbey2), (TaskCompletionSource<Void>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(8, (Object)new zzbed(zzbap2, this.zzaEi.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    public final <O extends Api.ApiOptions> Task<Void> zza(@NonNull GoogleApi<O> googleApi, @NonNull zzbdy<?> zzbdy2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzbar zzbar2 = new zzbar(zzbdy2, (TaskCompletionSource<Void>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(13, (Object)new zzbed(zzbar2, this.zzaEi.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public final boolean handleMessage(Message message) {
        block0 : switch (message.what) {
            case 1: {
                boolean bl = (Boolean)message.obj;
                zzbdb zzbdb2 = this;
                this.zzaEe = bl ? 10000L : 300000L;
                zzbdb2.mHandler.removeMessages(12);
                for (zzbat<?> zzbat2 : zzbdb2.zzaCB.keySet()) {
                    zzbdb2.mHandler.sendMessageDelayed(zzbdb2.mHandler.obtainMessage(12, zzbat2), zzbdb2.zzaEe);
                }
                break;
            }
            case 2: {
                zzbav zzbav2 = (zzbav)message.obj;
                zzbdb zzbdb3 = this;
                for (zzbat<?> zzbat3 : zzbav2.zzpt()) {
                    zzbdd<?> zzbdd2 = zzbdb3.zzaCB.get(zzbat3);
                    if (zzbdd2 == null) {
                        ConnectionResult connectionResult = new ConnectionResult(13);
                        zzbav2.zza(zzbat3, connectionResult);
                        break block0;
                    }
                    if (zzbdd2.isConnected()) {
                        zzbav2.zza(zzbat3, ConnectionResult.zzazX);
                        continue;
                    }
                    if (zzbdd2.zzqu() != null) {
                        zzbav2.zza(zzbat3, zzbdd2.zzqu());
                        continue;
                    }
                    zzbdd2.zza(zzbav2);
                }
                break;
            }
            case 3: {
                for (zzbdd<?> zzbdd3 : this.zzaCB.values()) {
                    zzbdd3.zzqt();
                    zzbdd3.connect();
                }
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                zzbed zzbed2 = (zzbed)message.obj;
                zzbdb zzbdb4 = this;
                zzbdd<?> zzbdd4 = zzbdb4.zzaCB.get(zzbed2.zzaET.zzph());
                if (zzbdd4 == null) {
                    zzbdb4.zzc(zzbed2.zzaET);
                    zzbdd4 = zzbdb4.zzaCB.get(zzbed2.zzaET.zzph());
                }
                if (zzbdd4.zzmv() && zzbdb4.zzaEi.get() != zzbed2.zzaES) {
                    zzbed2.zzaER.zzp(zzaEc);
                    zzbdd4.signOut();
                    break;
                }
                zzbdd4.zza(zzbed2.zzaER);
                break;
            }
            case 5: {
                ConnectionResult connectionResult = (ConnectionResult)message.obj;
                int n = message.arg1;
                zzbdb zzbdb5 = this;
                zzbdd<?> zzbdd5 = null;
                for (zzbdd<?> zzbdd6 : zzbdb5.zzaCB.values()) {
                    if (zzbdd6.getInstanceId() != n) continue;
                    zzbdd5 = zzbdd6;
                    break;
                }
                if (zzbdd5 != null) {
                    zzbdd<?> zzbdd6;
                    String string2 = String.valueOf(zzbdb5.zzaBd.getErrorString(connectionResult.getErrorCode()));
                    zzbdd6 = String.valueOf(connectionResult.getErrorMessage());
                    zzbdd5.zzt(new Status(17, new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(zzbdd6).length()).append("Error resolution was canceled by the user, original error message: ").append(string2).append(": ").append((String)((Object)zzbdd6)).toString()));
                    break;
                }
                Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(76).append("Could not find API instance ").append(n).append(" while trying to fail enqueued calls.").toString(), (Throwable)new Exception());
                break;
            }
            case 6: {
                zzbdb zzbdb6 = this;
                if (!(zzbdb6.mContext.getApplicationContext() instanceof Application)) break;
                zzbaw.zza((Application)((Application)zzbdb6.mContext.getApplicationContext()));
                zzbaw.zzpv().zza((zzbax)new zzbdc(zzbdb6));
                if (zzbaw.zzpv().zzab(true)) break;
                zzbdb6.zzaEe = 300000L;
                break;
            }
            case 7: {
                this.zzc((GoogleApi)message.obj);
                break;
            }
            case 9: {
                if (!this.zzaCB.containsKey(message.obj)) break;
                this.zzaCB.get(message.obj).resume();
                break;
            }
            case 10: {
                this.zzqn();
                break;
            }
            case 11: {
                if (!this.zzaCB.containsKey(message.obj)) break;
                this.zzaCB.get(message.obj).zzqd();
                break;
            }
            case 12: {
                if (!this.zzaCB.containsKey(message.obj)) break;
                this.zzaCB.get(message.obj).zzqx();
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    final PendingIntent zza(zzbat<?> zzbat2, int n) {
        zzbdd<?> zzbdd2 = this.zzaCB.get(zzbat2);
        if (zzbdd2 == null) {
            return null;
        }
        zzctk zzctk2 = zzbdd2.zzqy();
        if (zzctk2 == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)n, (Intent)zzctk2.zzmH(), (int)0x8000000);
    }

    final boolean zzc(ConnectionResult connectionResult, int n) {
        return this.zzaBd.zza(this.mContext, connectionResult, n);
    }

    public final void zza(ConnectionResult connectionResult, int n) {
        if (!this.zzc(connectionResult, n)) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n, 0, (Object)connectionResult));
        }
    }

    static /* synthetic */ Handler zza(zzbdb zzbdb2) {
        return zzbdb2.mHandler;
    }

    static /* synthetic */ Context zzb(zzbdb zzbdb2) {
        return zzbdb2.mContext;
    }

    static /* synthetic */ long zzc(zzbdb zzbdb2) {
        return zzbdb2.zzaDC;
    }

    static /* synthetic */ long zzd(zzbdb zzbdb2) {
        return zzbdb2.zzaDB;
    }

    static /* synthetic */ int zza(zzbdb zzbdb2, int n) {
        zzbdb2.zzaEg = n;
        return zzbdb2.zzaEg;
    }

    static /* synthetic */ Status zzqo() {
        return zzaEd;
    }

    static /* synthetic */ Object zzqp() {
        return zzuF;
    }

    static /* synthetic */ zzbbw zze(zzbdb zzbdb2) {
        return zzbdb2.zzaEj;
    }

    static /* synthetic */ Set zzf(zzbdb zzbdb2) {
        return zzbdb2.zzaEk;
    }

    static /* synthetic */ GoogleApiAvailability zzg(zzbdb zzbdb2) {
        return zzbdb2.zzaBd;
    }

    static /* synthetic */ long zzh(zzbdb zzbdb2) {
        return zzbdb2.zzaEe;
    }

    static /* synthetic */ int zzi(zzbdb zzbdb2) {
        return zzbdb2.zzaEg;
    }

    static /* synthetic */ Map zzj(zzbdb zzbdb2) {
        return zzbdb2.zzaCB;
    }
}

