/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.SystemClock;
import com.google.android.gms.internal.zzb;
import com.google.android.gms.internal.zzt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class zzw
implements com.google.android.gms.internal.zzb {
    private final Map<String, zza> zzaw = new LinkedHashMap<String, zza>(16, 0.75f, true);
    private long zzax = 0L;
    private final File zzay;
    private final int zzaz;

    public zzw(File file, int n) {
        this.zzay = file;
        this.zzaz = n;
    }

    public zzw(File file) {
        this(file, 0x500000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public synchronized zzb.zza zza(String string2) {
        zza zza2 = this.zzaw.get(string2);
        if (zza2 == null) {
            return null;
        }
        File file = this.zzf(string2);
        FilterInputStream filterInputStream = null;
        filterInputStream = new zzb(new BufferedInputStream(new FileInputStream(file)));
        zza.zzf(filterInputStream);
        byte[] byArray = zzw.zza(filterInputStream, (int)(file.length() - (long)((zzb)filterInputStream).zzaC));
        zzb.zza zza3 = zza2.zzb(byArray);
        try {
            filterInputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return zza3;
        catch (IOException iOException) {
            block12: {
                try {
                    zzt.zzb("%s: %s", file.getAbsolutePath(), iOException.toString());
                    this.remove(string2);
                    if (filterInputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (filterInputStream != null) {
                        try {
                            filterInputStream.close();
                        }
                        catch (IOException iOException2) {
                            return null;
                        }
                    }
                    throw throwable;
                }
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException3) {
                    return null;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public synchronized void initialize() {
        if (!this.zzay.exists()) {
            if (!this.zzay.mkdirs()) {
                zzt.zzc("Unable to create cache dir %s", this.zzay.getAbsolutePath());
            }
            return;
        }
        File[] fileArray = this.zzay.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            BufferedInputStream bufferedInputStream = null;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            zza zza2 = zza.zzf(bufferedInputStream);
            zza2.zzaA = file.length();
            this.zza(zza2.zzaB, zza2);
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {}
            continue;
            catch (IOException iOException) {
                block15: {
                    try {
                        if (file == null) break block15;
                        file.delete();
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bufferedInputStream != null) {
                                bufferedInputStream.close();
                            }
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                }
                try {
                    if (bufferedInputStream == null) continue;
                    bufferedInputStream.close();
                }
                catch (IOException iOException3) {}
            }
        }
    }

    @Override
    public synchronized void zza(String string2, zzb.zza zza2) {
        this.zzc(zza2.data.length);
        File file = this.zzf(string2);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            zza zza3 = new zza(string2, zza2);
            boolean bl = zza3.zza(bufferedOutputStream);
            if (!bl) {
                bufferedOutputStream.close();
                zzt.zzb("Failed to write header for %s", file.getAbsolutePath());
                throw new IOException();
            }
            bufferedOutputStream.write(zza2.data);
            bufferedOutputStream.close();
            this.zza(string2, zza3);
            return;
        }
        catch (IOException iOException) {
            boolean bl = file.delete();
            if (!bl) {
                zzt.zzb("Could not clean up file %s", file.getAbsolutePath());
            }
            return;
        }
    }

    public synchronized void remove(String string2) {
        boolean bl = this.zzf(string2).delete();
        this.removeEntry(string2);
        if (!bl) {
            zzt.zzb("Could not delete cache entry for key=%s, filename=%s", string2, this.zze(string2));
        }
    }

    private String zze(String string2) {
        int n = string2.length() / 2;
        String string3 = String.valueOf(string2.substring(0, n).hashCode());
        string3 = string3 + String.valueOf(string2.substring(n).hashCode());
        return string3;
    }

    public File zzf(String string2) {
        return new File(this.zzay, this.zze(string2));
    }

    private void zzc(int n) {
        if (this.zzax + (long)n < (long)this.zzaz) {
            return;
        }
        if (zzt.DEBUG) {
            zzt.zza("Pruning old cache entries.", new Object[0]);
        }
        long l = this.zzax;
        int n2 = 0;
        long l2 = SystemClock.elapsedRealtime();
        Iterator<Map.Entry<String, zza>> iterator = this.zzaw.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, zza> entry = iterator.next();
            zza zza2 = entry.getValue();
            boolean bl = this.zzf(zza2.zzaB).delete();
            if (bl) {
                this.zzax -= zza2.zzaA;
            } else {
                zzt.zzb("Could not delete cache entry for key=%s, filename=%s", zza2.zzaB, this.zze(zza2.zzaB));
            }
            iterator.remove();
            ++n2;
            if (!((float)(this.zzax + (long)n) < (float)this.zzaz * 0.9f)) continue;
            break;
        }
        if (zzt.DEBUG) {
            zzt.zza("pruned %d files, %d bytes, %d ms", n2, this.zzax - l, SystemClock.elapsedRealtime() - l2);
        }
    }

    private void zza(String string2, zza zza2) {
        if (!this.zzaw.containsKey(string2)) {
            this.zzax += zza2.zzaA;
        } else {
            zza zza3 = this.zzaw.get(string2);
            this.zzax += zza2.zzaA - zza3.zzaA;
        }
        this.zzaw.put(string2, zza2);
    }

    private void removeEntry(String string2) {
        zza zza2 = this.zzaw.get(string2);
        if (zza2 != null) {
            this.zzax -= zza2.zzaA;
            this.zzaw.remove(string2);
        }
    }

    private static byte[] zza(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3;
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < n && (n3 = inputStream.read(byArray, n2, n - n2)) != -1; n2 += n3) {
        }
        if (n2 != n) {
            throw new IOException("Expected " + n + " bytes, read " + n2 + " bytes");
        }
        return byArray;
    }

    private static int zza(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    static void zza(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 0 & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >> 24 & 0xFF);
    }

    static int zzb(InputStream inputStream) throws IOException {
        int n = 0 | zzw.zza(inputStream) << 0;
        n |= zzw.zza(inputStream) << 8;
        n |= zzw.zza(inputStream) << 16;
        return n |= zzw.zza(inputStream) << 24;
    }

    static void zza(OutputStream outputStream, long l) throws IOException {
        outputStream.write((byte)(l >>> 0));
        outputStream.write((byte)(l >>> 8));
        outputStream.write((byte)(l >>> 16));
        outputStream.write((byte)(l >>> 24));
        outputStream.write((byte)(l >>> 32));
        outputStream.write((byte)(l >>> 40));
        outputStream.write((byte)(l >>> 48));
        outputStream.write((byte)(l >>> 56));
    }

    static long zzc(InputStream inputStream) throws IOException {
        long l = 0L | ((long)zzw.zza(inputStream) & 0xFFL) << 0;
        l |= ((long)zzw.zza(inputStream) & 0xFFL) << 8;
        l |= ((long)zzw.zza(inputStream) & 0xFFL) << 16;
        l |= ((long)zzw.zza(inputStream) & 0xFFL) << 24;
        l |= ((long)zzw.zza(inputStream) & 0xFFL) << 32;
        l |= ((long)zzw.zza(inputStream) & 0xFFL) << 40;
        l |= ((long)zzw.zza(inputStream) & 0xFFL) << 48;
        return l |= ((long)zzw.zza(inputStream) & 0xFFL) << 56;
    }

    static void zza(OutputStream outputStream, String string2) throws IOException {
        byte[] byArray = string2.getBytes("UTF-8");
        zzw.zza(outputStream, (long)byArray.length);
        outputStream.write(byArray, 0, byArray.length);
    }

    static String zzd(InputStream inputStream) throws IOException {
        int n = (int)zzw.zzc(inputStream);
        byte[] byArray = zzw.zza(inputStream, n);
        return new String(byArray, "UTF-8");
    }

    static void zza(Map<String, String> map, OutputStream outputStream) throws IOException {
        if (map != null) {
            zzw.zza(outputStream, map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                zzw.zza(outputStream, entry.getKey());
                zzw.zza(outputStream, entry.getValue());
            }
        } else {
            zzw.zza(outputStream, 0);
        }
    }

    static Map<String, String> zze(InputStream inputStream) throws IOException {
        int n = zzw.zzb(inputStream);
        HashMap<String, String> hashMap = n == 0 ? Collections.emptyMap() : new HashMap<String, String>(n);
        for (int i = 0; i < n; ++i) {
            String string2 = zzw.zzd(inputStream).intern();
            String string3 = zzw.zzd(inputStream).intern();
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    private static class zzb
    extends FilterInputStream {
        private int zzaC = 0;

        private zzb(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            if (n != -1) {
                ++this.zzaC;
            }
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 != -1) {
                this.zzaC += n3;
            }
            return n3;
        }
    }

    static class zza {
        public long zzaA;
        public String zzaB;
        public String zza;
        public long zzb;
        public long zzc;
        public long zzd;
        public long zze;
        public Map<String, String> zzf;

        private zza() {
        }

        public zza(String string2, zzb.zza zza2) {
            this.zzaB = string2;
            this.zzaA = zza2.data.length;
            this.zza = zza2.zza;
            this.zzb = zza2.zzb;
            this.zzc = zza2.zzc;
            this.zzd = zza2.zzd;
            this.zze = zza2.zze;
            this.zzf = zza2.zzf;
        }

        public static zza zzf(InputStream inputStream) throws IOException {
            zza zza2 = new zza();
            int n = zzw.zzb(inputStream);
            if (n != 538247942) {
                throw new IOException();
            }
            zza2.zzaB = zzw.zzd(inputStream);
            zza2.zza = zzw.zzd(inputStream);
            if (zza2.zza.equals("")) {
                zza2.zza = null;
            }
            zza2.zzb = zzw.zzc(inputStream);
            zza2.zzc = zzw.zzc(inputStream);
            zza2.zzd = zzw.zzc(inputStream);
            zza2.zze = zzw.zzc(inputStream);
            zza2.zzf = zzw.zze(inputStream);
            return zza2;
        }

        public zzb.zza zzb(byte[] byArray) {
            zzb.zza zza2 = new zzb.zza();
            zza2.data = byArray;
            zza2.zza = this.zza;
            zza2.zzb = this.zzb;
            zza2.zzc = this.zzc;
            zza2.zzd = this.zzd;
            zza2.zze = this.zze;
            zza2.zzf = this.zzf;
            return zza2;
        }

        public boolean zza(OutputStream outputStream) {
            try {
                zzw.zza(outputStream, 538247942);
                zzw.zza(outputStream, this.zzaB);
                zzw.zza(outputStream, this.zza == null ? "" : this.zza);
                zzw.zza(outputStream, this.zzb);
                zzw.zza(outputStream, this.zzc);
                zzw.zza(outputStream, this.zzd);
                zzw.zza(outputStream, this.zze);
                zzw.zza(this.zzf, outputStream);
                outputStream.flush();
                return true;
            }
            catch (IOException iOException) {
                zzt.zzb("%s", iOException.toString());
                return false;
            }
        }
    }
}

