/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.security;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.zze;
import com.google.android.gms.common.zzg;
import java.lang.reflect.Method;

public class ProviderInstaller {
    private static final zze zzbEf = zze.zzuY();
    private static final Object zztX = new Object();
    private static Method zzbEg = null;
    public static final String PROVIDER_NAME = "GmsCore_OpenSSL";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installIfNeeded(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        zzac.zzb(context, (Object)"Context must not be null");
        zzbEf.zzaE(context);
        Context context2 = zzg.getRemoteContext(context);
        if (context2 == null) {
            Log.e((String)"ProviderInstaller", (String)"Failed to get remote context");
            throw new GooglePlayServicesNotAvailableException(8);
        }
        Object object = zztX;
        synchronized (object) {
            try {
                if (zzbEg == null) {
                    ProviderInstaller.zzbR(context2);
                }
                zzbEg.invoke(null, context2);
            }
            catch (Exception exception) {
                String string2 = String.valueOf(exception.getMessage());
                Log.e((String)"ProviderInstaller", (String)(string2.length() != 0 ? "Failed to install provider: ".concat(string2) : new String("Failed to install provider: ")));
                throw new GooglePlayServicesNotAvailableException(8);
            }
        }
    }

    public static void installIfNeededAsync(final Context context, final ProviderInstallListener providerInstallListener) {
        zzac.zzb(context, (Object)"Context must not be null");
        zzac.zzb(providerInstallListener, (Object)"Listener must not be null");
        zzac.zzdj("Must be called on the UI thread");
        AsyncTask<Void, Void, Integer> asyncTask = new AsyncTask<Void, Void, Integer>(){

            protected Integer zzb(Void ... voidArray) {
                try {
                    ProviderInstaller.installIfNeeded(context);
                }
                catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
                    return googlePlayServicesRepairableException.getConnectionStatusCode();
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return googlePlayServicesNotAvailableException.errorCode;
                }
                return 0;
            }

            protected void zzg(Integer n) {
                if (n == 0) {
                    providerInstallListener.onProviderInstalled();
                } else {
                    Intent intent = zzbEf.zzb(context, n, "pi");
                    providerInstallListener.onProviderInstallFailed(n, intent);
                }
            }

            protected /* synthetic */ void onPostExecute(Object object) {
                this.zzg((Integer)object);
            }

            protected /* synthetic */ Object doInBackground(Object[] objectArray) {
                return this.zzb((Void[])objectArray);
            }
        };
        asyncTask.execute((Object[])new Void[0]);
    }

    private static void zzbR(Context context) throws ClassNotFoundException, NoSuchMethodException {
        ClassLoader classLoader = context.getClassLoader();
        Class<?> clazz = classLoader.loadClass("com.google.android.gms.common.security.ProviderInstallerImpl");
        Class[] classArray = new Class[]{Context.class};
        zzbEg = clazz.getMethod("insertProvider", classArray);
    }

    public static interface ProviderInstallListener {
        public void onProviderInstalled();

        public void onProviderInstallFailed(int var1, Intent var2);
    }
}

