/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.Process;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Log;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class zzb
extends Service {
    @VisibleForTesting
    final ExecutorService zzbtK = Executors.newSingleThreadExecutor();
    private Binder zzckT;
    private final Object zzrJ = new Object();
    private int zzckU;
    private int zzckV = 0;

    public final synchronized IBinder onBind(Intent intent) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"Service received bind request");
        }
        if (this.zzckT == null) {
            this.zzckT = new zzb(this);
        }
        return this.zzckT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int onStartCommand(Intent intent, int n, int n2) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzckU = n2;
            ++this.zzckV;
        }
        object = this.zzD(intent);
        if (object == null) {
            this.zzC(intent);
            return 2;
        }
        if (this.zzE((Intent)object)) {
            this.zzC(intent);
            return 2;
        }
        this.zzbtK.execute(new Runnable((Intent)object, intent){
            final /* synthetic */ Intent val$intent;
            final /* synthetic */ Intent zzckW;
            {
                this.val$intent = intent;
                this.zzckW = intent2;
            }

            @Override
            public void run() {
                zzb.this.handleIntent(this.val$intent);
                zzb.this.zzC(this.zzckW);
            }
        });
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzC(Intent intent) {
        if (intent != null) {
            WakefulBroadcastReceiver.completeWakefulIntent((Intent)intent);
        }
        Object object = this.zzrJ;
        synchronized (object) {
            --this.zzckV;
            if (this.zzckV == 0) {
                this.zzqE(this.zzckU);
            }
        }
    }

    boolean zzqE(int n) {
        return this.stopSelfResult(n);
    }

    protected Intent zzD(Intent intent) {
        return intent;
    }

    public boolean zzE(Intent intent) {
        return false;
    }

    public abstract void handleIntent(Intent var1);

    public static class zzb
    extends Binder {
        private final zzb zzclc;

        zzb(zzb zzb2) {
            this.zzclc = zzb2;
        }

        public void zza(final zza zza2) {
            if (Binder.getCallingUid() != Process.myUid()) {
                throw new SecurityException("Binding only allowed within app");
            }
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                Log.d((String)"EnhancedIntentService", (String)"service received new intent via bind strategy");
            }
            if (this.zzclc.zzE(zza2.intent)) {
                zza2.finish();
            } else {
                if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                    Log.d((String)"EnhancedIntentService", (String)"intent being queued for bg execution");
                }
                this.zzclc.zzbtK.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                            Log.d((String)"EnhancedIntentService", (String)"bg processing of the intent starting now");
                        }
                        zzb.this.zzclc.handleIntent(zza2.intent);
                        zza2.finish();
                    }
                });
            }
        }
    }

    public static class zzc
    implements ServiceConnection {
        private final Context zzqn;
        private final Intent zzclf;
        private final ScheduledExecutorService zzclg;
        private final Queue<zza> zzclh = new LinkedList<zza>();
        private zzb zzcli;
        private boolean zzclj = false;

        public zzc(Context context, String string) {
            this(context, string, new ScheduledThreadPoolExecutor(0));
        }

        @VisibleForTesting
        zzc(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
            this.zzqn = context.getApplicationContext();
            this.zzclf = new Intent(string).setPackage(this.zzqn.getPackageName());
            this.zzclg = scheduledExecutorService;
        }

        public synchronized void zza(Intent intent, BroadcastReceiver.PendingResult pendingResult) {
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                Log.d((String)"EnhancedIntentService", (String)"new intent queued in the bind-strategy delivery");
            }
            this.zzclh.add(new zza(intent, pendingResult, this.zzclg));
            this.zzwH();
        }

        private synchronized void zzwH() {
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                Log.d((String)"EnhancedIntentService", (String)"flush queue called");
            }
            while (!this.zzclh.isEmpty()) {
                if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                    Log.d((String)"EnhancedIntentService", (String)"found intent to be delivered");
                }
                if (this.zzcli != null && this.zzcli.isBinderAlive()) {
                    if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                        Log.d((String)"EnhancedIntentService", (String)"binder is alive, sending the intent.");
                    }
                    zza zza2 = this.zzclh.poll();
                    this.zzcli.zza(zza2);
                    continue;
                }
                if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                    boolean bl = !this.zzclj;
                    Log.d((String)"EnhancedIntentService", (String)new StringBuilder(39).append("binder is dead. start connection? ").append(bl).toString());
                }
                if (!this.zzclj) {
                    this.zzclj = true;
                    try {
                        if (com.google.android.gms.common.stats.zza.zzyJ().zza(this.zzqn, this.zzclf, this, 65)) {
                            return;
                        }
                        Log.e((String)"EnhancedIntentService", (String)"binding to the service failed");
                    }
                    catch (SecurityException securityException) {
                        Log.e((String)"EnhancedIntentService", (String)"Exception while binding the service", (Throwable)securityException);
                    }
                    while (!this.zzclh.isEmpty()) {
                        this.zzclh.poll().finish();
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            zzc zzc2 = this;
            synchronized (zzc2) {
                this.zzclj = false;
                this.zzcli = (zzb)iBinder;
                if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                    String string = String.valueOf(componentName);
                    Log.d((String)"EnhancedIntentService", (String)new StringBuilder(20 + String.valueOf(string).length()).append("onServiceConnected: ").append(string).toString());
                }
                this.zzwH();
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                String string = String.valueOf(componentName);
                Log.d((String)"EnhancedIntentService", (String)new StringBuilder(23 + String.valueOf(string).length()).append("onServiceDisconnected: ").append(string).toString());
            }
            this.zzwH();
        }
    }

    static class zza {
        final Intent intent;
        private final BroadcastReceiver.PendingResult zzckY;
        private boolean zzckZ = false;
        private final ScheduledFuture<?> zzcla;

        zza(final Intent intent, BroadcastReceiver.PendingResult pendingResult, ScheduledExecutorService scheduledExecutorService) {
            this.intent = intent;
            this.zzckY = pendingResult;
            this.zzcla = scheduledExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    String string = String.valueOf(intent.getAction());
                    Log.w((String)"EnhancedIntentService", (String)new StringBuilder(61 + String.valueOf(string).length()).append("Service took too long to process intent: ").append(string).append(" App may get closed.").toString());
                    zza.this.finish();
                }
            }, 9500L, TimeUnit.MILLISECONDS);
        }

        synchronized void finish() {
            if (!this.zzckZ) {
                this.zzckY.finish();
                this.zzcla.cancel(false);
                this.zzckZ = true;
            }
        }
    }
}

