/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.decoder;

import android.graphics.Bitmap;
import com.facebook.common.internal.Closeables;
import com.facebook.common.references.CloseableReference;
import com.facebook.imageformat.GifFormatChecker;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imageformat.ImageFormatChecker;
import com.facebook.imagepipeline.animated.factory.AnimatedImageFactory;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imagepipeline.platform.PlatformDecoder;
import java.io.InputStream;

public class ImageDecoder {
    private final AnimatedImageFactory mAnimatedImageFactory;
    private final Bitmap.Config mBitmapConfig;
    private final PlatformDecoder mPlatformDecoder;

    public ImageDecoder(AnimatedImageFactory animatedImageFactory, PlatformDecoder platformDecoder, Bitmap.Config bitmapConfig) {
        this.mAnimatedImageFactory = animatedImageFactory;
        this.mBitmapConfig = bitmapConfig;
        this.mPlatformDecoder = platformDecoder;
    }

    public CloseableImage decodeImage(EncodedImage encodedImage, int length, QualityInfo qualityInfo, ImageDecodeOptions options) {
        ImageFormat imageFormat = encodedImage.getImageFormat();
        if (imageFormat == null || imageFormat == ImageFormat.UNKNOWN) {
            imageFormat = ImageFormatChecker.getImageFormat_WrapIOException((InputStream)encodedImage.getInputStream());
        }
        switch (imageFormat) {
            case UNKNOWN: {
                throw new IllegalArgumentException("unknown image format");
            }
            case JPEG: {
                return this.decodeJpeg(encodedImage, length, qualityInfo);
            }
            case GIF: {
                return this.decodeGif(encodedImage, options);
            }
            case WEBP_ANIMATED: {
                return this.decodeAnimatedWebp(encodedImage, options);
            }
        }
        return this.decodeStaticImage(encodedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableImage decodeGif(EncodedImage encodedImage, ImageDecodeOptions options) {
        InputStream is = encodedImage.getInputStream();
        if (is == null) {
            return null;
        }
        try {
            if (!options.forceStaticImage && GifFormatChecker.isAnimated((InputStream)is)) {
                CloseableImage closeableImage = this.mAnimatedImageFactory.decodeGif(encodedImage, options, this.mBitmapConfig);
                return closeableImage;
            }
            CloseableStaticBitmap closeableStaticBitmap = this.decodeStaticImage(encodedImage);
            return closeableStaticBitmap;
        }
        finally {
            Closeables.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableStaticBitmap decodeStaticImage(EncodedImage encodedImage) {
        try (CloseableReference<Bitmap> bitmapReference = this.mPlatformDecoder.decodeFromEncodedImage(encodedImage, this.mBitmapConfig);){
            CloseableStaticBitmap closeableStaticBitmap = new CloseableStaticBitmap(bitmapReference, ImmutableQualityInfo.FULL_QUALITY, encodedImage.getRotationAngle());
            return closeableStaticBitmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableStaticBitmap decodeJpeg(EncodedImage encodedImage, int length, QualityInfo qualityInfo) {
        try (CloseableReference<Bitmap> bitmapReference = this.mPlatformDecoder.decodeJPEGFromEncodedImage(encodedImage, this.mBitmapConfig, length);){
            CloseableStaticBitmap closeableStaticBitmap = new CloseableStaticBitmap(bitmapReference, qualityInfo, encodedImage.getRotationAngle());
            return closeableStaticBitmap;
        }
    }

    public CloseableImage decodeAnimatedWebp(EncodedImage encodedImage, ImageDecodeOptions options) {
        return this.mAnimatedImageFactory.decodeWebP(encodedImage, options, this.mBitmapConfig);
    }
}

