/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.net;

import android.os.Build;
import android.support.v4.net.TrafficStatsCompatApi24;
import android.support.v4.net.TrafficStatsCompatIcs;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketException;

public final class TrafficStatsCompat {
    private static final TrafficStatsCompatImpl IMPL = "N".equals(Build.VERSION.CODENAME) ? new Api24TrafficStatsCompatImpl() : (Build.VERSION.SDK_INT >= 14 ? new IcsTrafficStatsCompatImpl() : new BaseTrafficStatsCompatImpl());

    public static void clearThreadStatsTag() {
        IMPL.clearThreadStatsTag();
    }

    public static int getThreadStatsTag() {
        return IMPL.getThreadStatsTag();
    }

    public static void incrementOperationCount(int operationCount) {
        IMPL.incrementOperationCount(operationCount);
    }

    public static void incrementOperationCount(int tag, int operationCount) {
        IMPL.incrementOperationCount(tag, operationCount);
    }

    public static void setThreadStatsTag(int tag) {
        IMPL.setThreadStatsTag(tag);
    }

    public static void tagSocket(Socket socket) throws SocketException {
        IMPL.tagSocket(socket);
    }

    public static void untagSocket(Socket socket) throws SocketException {
        IMPL.untagSocket(socket);
    }

    public static void tagDatagramSocket(DatagramSocket socket) throws SocketException {
        IMPL.tagDatagramSocket(socket);
    }

    public static void untagDatagramSocket(DatagramSocket socket) throws SocketException {
        IMPL.untagDatagramSocket(socket);
    }

    private TrafficStatsCompat() {
    }

    static class Api24TrafficStatsCompatImpl
    extends IcsTrafficStatsCompatImpl {
        Api24TrafficStatsCompatImpl() {
        }

        @Override
        public void tagDatagramSocket(DatagramSocket socket) throws SocketException {
            TrafficStatsCompatApi24.tagDatagramSocket(socket);
        }

        @Override
        public void untagDatagramSocket(DatagramSocket socket) throws SocketException {
            TrafficStatsCompatApi24.untagDatagramSocket(socket);
        }
    }

    static class IcsTrafficStatsCompatImpl
    implements TrafficStatsCompatImpl {
        IcsTrafficStatsCompatImpl() {
        }

        @Override
        public void clearThreadStatsTag() {
            TrafficStatsCompatIcs.clearThreadStatsTag();
        }

        @Override
        public int getThreadStatsTag() {
            return TrafficStatsCompatIcs.getThreadStatsTag();
        }

        @Override
        public void incrementOperationCount(int operationCount) {
            TrafficStatsCompatIcs.incrementOperationCount(operationCount);
        }

        @Override
        public void incrementOperationCount(int tag, int operationCount) {
            TrafficStatsCompatIcs.incrementOperationCount(tag, operationCount);
        }

        @Override
        public void setThreadStatsTag(int tag) {
            TrafficStatsCompatIcs.setThreadStatsTag(tag);
        }

        @Override
        public void tagSocket(Socket socket) throws SocketException {
            TrafficStatsCompatIcs.tagSocket(socket);
        }

        @Override
        public void untagSocket(Socket socket) throws SocketException {
            TrafficStatsCompatIcs.untagSocket(socket);
        }

        @Override
        public void tagDatagramSocket(DatagramSocket socket) throws SocketException {
            TrafficStatsCompatIcs.tagDatagramSocket(socket);
        }

        @Override
        public void untagDatagramSocket(DatagramSocket socket) throws SocketException {
            TrafficStatsCompatIcs.untagDatagramSocket(socket);
        }
    }

    static class BaseTrafficStatsCompatImpl
    implements TrafficStatsCompatImpl {
        private ThreadLocal<SocketTags> mThreadSocketTags = new ThreadLocal<SocketTags>(){

            @Override
            protected SocketTags initialValue() {
                return new SocketTags();
            }
        };

        BaseTrafficStatsCompatImpl() {
        }

        @Override
        public void clearThreadStatsTag() {
            this.mThreadSocketTags.get().statsTag = -1;
        }

        @Override
        public int getThreadStatsTag() {
            return this.mThreadSocketTags.get().statsTag;
        }

        @Override
        public void incrementOperationCount(int operationCount) {
        }

        @Override
        public void incrementOperationCount(int tag, int operationCount) {
        }

        @Override
        public void setThreadStatsTag(int tag) {
            this.mThreadSocketTags.get().statsTag = tag;
        }

        @Override
        public void tagSocket(Socket socket) {
        }

        @Override
        public void untagSocket(Socket socket) {
        }

        @Override
        public void tagDatagramSocket(DatagramSocket socket) {
        }

        @Override
        public void untagDatagramSocket(DatagramSocket socket) {
        }

        private static class SocketTags {
            public int statsTag = -1;

            SocketTags() {
            }
        }
    }

    static interface TrafficStatsCompatImpl {
        public void clearThreadStatsTag();

        public int getThreadStatsTag();

        public void incrementOperationCount(int var1);

        public void incrementOperationCount(int var1, int var2);

        public void setThreadStatsTag(int var1);

        public void tagSocket(Socket var1) throws SocketException;

        public void untagSocket(Socket var1) throws SocketException;

        public void tagDatagramSocket(DatagramSocket var1) throws SocketException;

        public void untagDatagramSocket(DatagramSocket var1) throws SocketException;
    }
}

