/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.zzg;
import com.google.android.gms.auth.api.signin.internal.zzh;
import com.google.android.gms.auth.api.signin.zzb;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends zza
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    public static final Scope zzakh = new Scope("profile");
    public static final Scope zzaki = new Scope("email");
    public static final Scope zzakj = new Scope("openid");
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN = new Builder().requestScopes(SCOPE_GAMES, new Scope[0]).build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zzb();
    final int versionCode;
    private final ArrayList<Scope> zzakk;
    private Account zzahh;
    private boolean zzajv;
    private final boolean zzakl;
    private final boolean zzakm;
    private String zzajw;
    private String zzakn;
    private ArrayList<zzg> zzako;
    private Map<Integer, zzg> zzakp;
    private static Comparator<Scope> zzakg = new Comparator<Scope>(){

        public int zza(Scope scope, Scope scope2) {
            return scope.zzvt().compareTo(scope2.zzvt());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Scope)object, (Scope)object2);
        }
    };

    @Nullable
    public static GoogleSignInOptions zzcx(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(3, new ArrayList<Scope>(hashSet), account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null), new HashMap<Integer, zzg>());
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, ArrayList<zzg> arrayList2) {
        this(n, arrayList, account, bl, bl2, bl3, string2, string3, GoogleSignInOptions.zzx(arrayList2));
    }

    private GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map<Integer, zzg> map) {
        this.versionCode = n;
        this.zzakk = arrayList;
        this.zzahh = account;
        this.zzajv = bl;
        this.zzakl = bl2;
        this.zzakm = bl3;
        this.zzajw = string2;
        this.zzakn = string3;
        this.zzako = new ArrayList<zzg>(map.values());
        this.zzakp = map;
    }

    public ArrayList<Scope> zzrj() {
        return new ArrayList<Scope>(this.zzakk);
    }

    public Scope[] getScopeArray() {
        return this.zzakk.toArray(new Scope[this.zzakk.size()]);
    }

    public Account getAccount() {
        return this.zzahh;
    }

    public boolean isIdTokenRequested() {
        return this.zzajv;
    }

    public boolean zzrk() {
        return this.zzakl;
    }

    public boolean zzrl() {
        return this.zzakm;
    }

    public String getServerClientId() {
        return this.zzajw;
    }

    public String zzrm() {
        return this.zzakn;
    }

    public ArrayList<zzg> zzrn() {
        return this.zzako;
    }

    private static Map<Integer, zzg> zzx(@Nullable List<zzg> list) {
        HashMap<Integer, zzg> hashMap = new HashMap<Integer, zzg>();
        if (null == list) {
            return hashMap;
        }
        for (zzg zzg2 : list) {
            hashMap.put(zzg2.getType(), zzg2);
        }
        return hashMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.zzako.size() > 0 || googleSignInOptions.zzako.size() > 0) {
                return false;
            }
            if (this.zzakk.size() != googleSignInOptions.zzrj().size() || !this.zzakk.containsAll(googleSignInOptions.zzrj())) {
                return false;
            }
            return (this.zzahh == null ? googleSignInOptions.getAccount() == null : this.zzahh.equals((Object)googleSignInOptions.getAccount())) && (TextUtils.isEmpty((CharSequence)this.zzajw) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.getServerClientId()) : this.zzajw.equals(googleSignInOptions.getServerClientId())) && this.zzakm == googleSignInOptions.zzrl() && this.zzajv == googleSignInOptions.isIdTokenRequested() && this.zzakl == googleSignInOptions.zzrk();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Scope scope : this.zzakk) {
            arrayList.add(scope.zzvt());
        }
        Collections.sort(arrayList);
        return new zzh().zzq(arrayList).zzq(this.zzahh).zzq(this.zzajw).zzad(this.zzakm).zzad(this.zzajv).zzad(this.zzakl).zzru();
    }

    public String zzrg() {
        return this.zzri().toString();
    }

    private JSONObject zzri() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzakk, zzakg);
            for (Scope scope : this.zzakk) {
                jSONArray.put((Object)scope.zzvt());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zzahh != null) {
                jSONObject.put("accountName", (Object)this.zzahh.name);
            }
            jSONObject.put("idTokenRequested", this.zzajv);
            jSONObject.put("forceCodeForRefreshToken", this.zzakm);
            jSONObject.put("serverAuthRequested", this.zzakl);
            if (!TextUtils.isEmpty((CharSequence)this.zzajw)) {
                jSONObject.put("serverClientId", (Object)this.zzajw);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzakn)) {
                jSONObject.put("hostedDomain", (Object)this.zzakn);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public static final class Builder {
        private Set<Scope> zzakq = new HashSet<Scope>();
        private boolean zzakl;
        private boolean zzakm;
        private boolean zzajv;
        private String zzajw;
        private Account zzahh;
        private String zzakn;
        private Map<Integer, zzg> zzakr = new HashMap<Integer, zzg>();

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzac.zzw((Object)googleSignInOptions);
            this.zzakq = new HashSet<Scope>(googleSignInOptions.zzakk);
            this.zzakl = googleSignInOptions.zzakl;
            this.zzakm = googleSignInOptions.zzakm;
            this.zzajv = googleSignInOptions.zzajv;
            this.zzajw = googleSignInOptions.zzajw;
            this.zzahh = googleSignInOptions.zzahh;
            this.zzakn = googleSignInOptions.zzakn;
            this.zzakr = GoogleSignInOptions.zzx(googleSignInOptions.zzako);
        }

        public Builder requestId() {
            this.zzakq.add(zzakj);
            return this;
        }

        public Builder requestEmail() {
            this.zzakq.add(zzaki);
            return this;
        }

        public Builder requestProfile() {
            this.zzakq.add(zzakh);
            return this;
        }

        public Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.zzakq.add(scope);
            this.zzakq.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public Builder requestIdToken(String string2) {
            this.zzajv = true;
            this.zzajw = this.zzcy(string2);
            return this;
        }

        public Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public Builder requestServerAuthCode(String string2, boolean bl) {
            this.zzakl = true;
            this.zzajw = this.zzcy(string2);
            this.zzakm = bl;
            return this;
        }

        public Builder setAccountName(String string2) {
            this.zzahh = new Account(zzac.zzdr((String)string2), "com.google");
            return this;
        }

        public Builder setHostedDomain(String string2) {
            this.zzakn = zzac.zzdr((String)string2);
            return this;
        }

        public Builder addExtension(GoogleSignInOptionsExtension googleSignInOptionsExtension) {
            if (this.zzakr.containsKey(1)) {
                throw new IllegalStateException("Only one extension per type may be added");
            }
            this.zzakr.put(1, new zzg(googleSignInOptionsExtension));
            return this;
        }

        public GoogleSignInOptions build() {
            if (this.zzajv && (this.zzahh == null || !this.zzakq.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(3, new ArrayList<Scope>(this.zzakq), this.zzahh, this.zzajv, this.zzakl, this.zzakm, this.zzajw, this.zzakn, this.zzakr);
        }

        private String zzcy(String string2) {
            zzac.zzdr((String)string2);
            zzac.zzb((this.zzajw == null || this.zzajw.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

