// Generated by CoffeeScript 1.3.3
(function() {
  'use strict';

  var EventEmitter, FSWatcher, fs, sysPath,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  EventEmitter = require('events').EventEmitter;

  fs = require('fs');

  sysPath = require('path');

  exports.FSWatcher = FSWatcher = (function(_super) {

    __extends(FSWatcher, _super);

    function FSWatcher(options) {
      var _base, _ref,
        _this = this;
      this.options = options != null ? options : {};
      this.close = __bind(this.close, this);

      this.add = __bind(this.add, this);

      this._handle = __bind(this._handle, this);

      this._handleDir = __bind(this._handleDir, this);

      this._handleFile = __bind(this._handleFile, this);

      this._watch = __bind(this._watch, this);

      this._remove = __bind(this._remove, this);

      this._removeFromWatchedDir = __bind(this._removeFromWatchedDir, this);

      this._addToWatchedDir = __bind(this._addToWatchedDir, this);

      this._getWatchedDir = __bind(this._getWatchedDir, this);

      this.watched = Object.create(null);
      this.watchers = [];
      if ((_ref = (_base = this.options).persistent) == null) {
        _base.persistent = false;
      }
      this._ignored = (function() {
        switch (toString.call(_this.options.ignored)) {
          case '[object RegExp]':
            return function(string) {
              return this.options.ignored.test(string);
            };
          case '[object Function]':
            return _this.options.ignored;
          default:
            return function() {
              return false;
            };
        }
      })();
    }

    FSWatcher.prototype._getWatchedDir = function(directory) {
      var dir, _base, _ref;
      dir = directory.replace(/[\\\/]$/, '');
      return (_ref = (_base = this.watched)[dir]) != null ? _ref : _base[dir] = [];
    };

    FSWatcher.prototype._addToWatchedDir = function(directory, file) {
      var watchedFiles;
      watchedFiles = this._getWatchedDir(directory);
      return watchedFiles.push(file);
    };

    FSWatcher.prototype._removeFromWatchedDir = function(directory, file) {
      var watchedFiles,
        _this = this;
      watchedFiles = this._getWatchedDir(directory);
      return watchedFiles.some(function(watchedFile, index) {
        if (watchedFile === file) {
          watchedFiles.splice(index, 1);
          return true;
        }
      });
    };

    FSWatcher.prototype._remove = function(directory, item) {
      var fullPath, nestedDirectoryChildren,
        _this = this;
      fullPath = sysPath.join(directory, item);
      nestedDirectoryChildren = this._getWatchedDir(fullPath).slice();
      this._removeFromWatchedDir(directory, item);
      nestedDirectoryChildren.forEach(function(nestedItem) {
        return _this._remove(fullPath, nestedItem);
      });
      return this.emit('unlink', fullPath);
    };

    FSWatcher.prototype._watch = function(item, itemType, callback) {
      var basename, directory, options, parent, watcher,
        _this = this;
      if (callback == null) {
        callback = (function() {});
      }
      directory = sysPath.dirname(item);
      basename = sysPath.basename(item);
      parent = this._getWatchedDir(directory);
      options = {
        persistent: this.options.persistent
      };
      if (parent.indexOf(basename) >= 0) {
        return;
      }
      this._addToWatchedDir(directory, basename);
      if (process.platform === 'win32') {
        watcher = fs.watch(item, options, function(event, path) {
          return callback(item);
        });
        this.watchers.push(watcher);
      } else {
        options.interval = 100;
        fs.watchFile(item, options, function(curr, prev) {
          if (curr.mtime.getTime() !== prev.mtime.getTime()) {
            return callback(item);
          }
        });
      }
      if (itemType === 'file') {
        return this.emit('add', item);
      }
    };

    FSWatcher.prototype._handleFile = function(file) {
      var _this = this;
      return this._watch(file, 'file', function(file) {
        return _this.emit('change', file);
      });
    };

    FSWatcher.prototype._handleDir = function(directory) {
      var read,
        _this = this;
      read = function(directory) {
        return fs.readdir(directory, function(error, current) {
          var previous;
          if (error != null) {
            return _this.emit('error', error);
          }
          if (!current) {
            return;
          }
          previous = _this._getWatchedDir(directory);
          previous.filter(function(file) {
            return current.indexOf(file) < 0;
          }).forEach(function(file) {
            return _this._remove(directory, file);
          });
          return current.filter(function(file) {
            return previous.indexOf(file) < 0;
          }).forEach(function(file) {
            return _this._handle(sysPath.join(directory, file));
          });
        });
      };
      read(directory);
      return this._watch(directory, 'directory', read);
    };

    FSWatcher.prototype._handle = function(item) {
      var _this = this;
      if (this._ignored(item)) {
        return;
      }
      return fs.realpath(item, function(error, path) {
        if (error != null) {
          return _this.emit('error', error);
        }
        return fs.stat(item, function(error, stats) {
          if (error != null) {
            return _this.emit('error', error);
          }
          if (stats.isFile()) {
            _this._handleFile(item);
          }
          if (stats.isDirectory()) {
            return _this._handleDir(item);
          }
        });
      });
    };

    FSWatcher.prototype.add = function(files) {
      if (!Array.isArray(files)) {
        files = [files];
      }
      files.forEach(this._handle);
      return this;
    };

    FSWatcher.prototype.close = function() {
      var _this = this;
      this.watchers.forEach(function(watcher) {
        return watcher.close();
      });
      Object.keys(this.watched).forEach(function(directory) {
        return _this.watched[directory].forEach(function(file) {
          return fs.unwatchFile(sysPath.join(directory, file));
        });
      });
      this.watched = Object.create(null);
      return this;
    };

    return FSWatcher;

  })(EventEmitter);

  exports.watch = function(files, options) {
    return new FSWatcher(options).add(files);
  };

}).call(this);
