// Generated by CoffeeScript 1.3.3
var app, col, colors, defaultLetters, express, fs, gzip, racer, row, store, _i, _j;

express = require('express');

gzip = require('connect-gzip');

fs = require('fs');

racer = require('racer');

app = express.createServer().use(express.favicon()).use(gzip.staticGzip(__dirname));

store = racer.createStore({
  listen: app,
  mode: {
    type: 'stm'
  }
});

store.flush();

racer.js({
  entry: __dirname + '/client.js'
}, function(err, js) {
  return fs.writeFileSync(__dirname + '/script.js', js);
});

colors = ['red', 'yellow', 'blue', 'orange', 'green'];

defaultLetters = {};

for (row = _i = 0; _i <= 4; row = ++_i) {
  for (col = _j = 0; _j <= 25; col = ++_j) {
    defaultLetters[row * 26 + col] = {
      color: colors[row],
      value: String.fromCharCode(65 + col),
      position: {
        left: col * 24 + 72,
        top: row * 32 + 8
      }
    };
  }
}

defaultLetters = JSON.stringify(defaultLetters);

app.get('/:roomName?', function(req, res) {
  var model, normalizedName, roomName;
  roomName = req.params.roomName;
  if (!(roomName && /^[-\w ]+$/.test(roomName))) {
    return res.redirect('/lobby');
  }
  normalizedName = roomName.toLowerCase().replace(/[_ ]/g, '-');
  if (normalizedName !== roomName) {
    return res.redirect("/" + normalizedName);
  }
  model = store.createModel();
  return model.subscribe("rooms." + roomName, 'rooms.*.players', function(err, room) {
    model.ref('_room', room);
    model.set('_roomName', roomName);
    if (!room.get('letters')) {
      room.set('letters', JSON.parse(defaultLetters));
    }
    return model.bundle(function(bundle) {
      var boardHtml, close, id, letter, open, _ref;
      boardHtml = '';
      if (~req.headers['user-agent'].indexOf('MSIE')) {
        open = '<a href=# onclick="return false"';
        close = '</a>';
      } else {
        open = '<span';
        close = '</span>';
      }
      _ref = room.get("letters");
      for (id in _ref) {
        letter = _ref[id];
        boardHtml += "" + open + " draggable=true class=\"" + letter.color + " letter\" id=" + id + "\nstyle=left:" + letter.position.left + "px;top:" + letter.position.top + "px>" + letter.value + close;
      }
      return res.send("<!DOCTYPE html>\n<title>Letters game</title>\n<link rel=stylesheet href=style.css>\n<link rel=stylesheet href=\"http://fonts.googleapis.com/css?family=Anton\">\n<div id=back>\n  <div id=page>\n    <p id=info>\n    <div id=rooms>\n      <p>Rooms:\n      <ul id=roomlist></ul>\n    </div>\n    <div id=board>" + boardHtml + "</div>\n  </div>\n</div>\n<script>init=" + bundle + "</script>\n<script src=script.js></script>");
    });
  });
});

store.sockets.on('connection', function(socket) {
  return socket.on('join', function(room) {
    var playersPath;
    playersPath = "rooms." + room + ".players";
    store.incr(playersPath);
    return socket.on('disconnect', function() {
      return store.incr(playersPath, -1);
    });
  });
});

app.listen(3010);

console.log('Go to http://localhost:3010/lobby');

console.log('Go to http://localhost:3010/powder-room');
