var EventEmitter = require('events').EventEmitter;

module.exports = World;

function World () {
  this.data = {};
  this.versions = {};
  EventEmitter.call(this);
}

require('util').inherits(World, EventEmitter);

World.prototype.addData = function (data) {
  for (var ns in data) {
    var collection = data[ns];
    for (var id in collection) {
      var doc = collection[id];
      if (! this.contains(ns, doc)) {
        this.addDoc(ns, doc);
      }
    }
  }
};

World.prototype.addDoc = function (ns, doc) {
  var id = doc.id;
  var ver = doc._v_;
  this.versions[ns + '.' + id] = ver;
  delete doc._v_;
  var collection = this.data[ns];
  collection[id] = doc;
};

World.prototype.merge = function (fromWorld) {
  var memory = this.memory;
  var self = this;
  fromWorld.eachDoc( function (ns, doc, ver) {
    if (! self.contains(ns, doc)) {
      self.addDoc(ns, doc);
    }
  });
};

World.prototype.eachDoc = function (cb) {
  var data = this.data;
  var versions = this.versions;
  for (var ns in data) {
    var collection = data[ns];
    for (var id in collection) {
      var doc = collection[id];
      var ver = versions[ns + '.' + id];
      cb(ns, doc, ver);
    }
  }
};

World.prototype.contains = function (ns, doc) {
  var collection = this.data[ns];
  if (! collection) return false;
  return doc.id in collection;
};

World.prototype.listen = function (world) {
};
