/**
 * Checks, transforms, logs, and applies incoming transactions.
 */

var transaction = require('transaction');
var deepCopy = require('racer-util').deepCopy;

module.exports = TxnApplier;

var Stream = require('stream');

function TxnApplier (opts) {
  Stream.call(this);
  this.db = opts.db;
}

require('util').inherits(TxnApplier, Stream);

TxnApplier.prototype.writable = true;
TxnApplier.prototype.readable = true;

TxnApplier.prototype.write = function (txn) {
  var docPath = pathToDoc(transaction.getPath(txn));
  var ver = transaction.getVer(txn);
  var self = this;
  this.queueTxn(docPath, txn, function (err) {
    self.consumeTxnQueue(docPath, function (err, txn) {
      if (err) return self.emit('error', err);
      if (!txn) cleanupListening(docPath);
      self.onConsumedTxn(txn);
    });
  });
};

TxnApplier.prototype.queueTxn = function (docPath, txn, cb) {
};

TxnApplier.prototype.onConsumedTxn = function (txn) {
  var self = this;
  this.getOps(docPath, ver, null, function (err, ops) {
    if (err) return self.emit('error', err);
    // TODO Check if this txn was seen before

    var xfOp;
    var historicOp;
    var ver = transaction.getVer(txn);
    // Transform the operation
    for (var i = 0, l = ops.length; i < l; i++) {
      historicOp = ops[i];
      if (transaction.getId(historicOp) === transaction.getId(op)) {
        return self.emit('data', ['txnDup', [historicOp]]);
      }
      xfOp = xf(historicOp, xfOp || deepCopy(txn));
      transaction.setVer(xfOp, ver++);
    }
    self.logOp(xfOp, function (err) {
      if (err) return self.emit('error', err);
      self.applyOp(xfOp, function (err, newVer) {
        if (err) return self.emit('error', err);
        transaction.setVer(xfOp, newVer);
        self.emit('data', ['txnOk', [xfOp]]);
        self.publish(xfOp);
      });
    });
  });
};

TxnApplier.prototype.getOps = function (docPath, fromVer, toVer, cb) {
  throw new Error('Unimplemented');
};

TxnApplier.prototype.logOp = function (op, cb) {
};

TxnApplier.prototype.applyOp = function (op, cb) {
};
