When would it make sense to automatically fetch and load the document being
updated.

Possibly:

```coffee
store.readPathAccess 'users.*', (pathFragment, getDoc) ->
  user = getDoc()
  return @session
```

## Protecting Writes

```coffee
# Default access control to allow writes on everything
store.writeAccess '*', '*', -> true
```

```coffee
# When you are ready to start writing your own access control, you should
# delete the above line. After that no writes are allowed, and you have to
# whitelist the mutations your app will allow.

store.context 'userSettings', ->
  store.writeAccess 'set', 'users.*', (restOfArgs, txn) ->
    path = restOfArgs[0]
    docId = pathUtils.id path
    return @session.userId === docId || ~@session.roles.indexOf 'admin'

  # We also support authorizations that need to involve asynchronous io via a
  # final next callback.
  store.writeAccess 'push', 'users.*.roles', (userId, restOfArgs, txn, next) ->
    store.get "users.#{userId}.ownerId", (err, ownerId) =>
      next @session.userId === ownerId || ~@session.roles.indexOf 'admin'

  # This also supports compound transactions, which may involve a mix of
  # mutator methods. Each mutation looks up the matching mutator/pattern and
  # evaluates the auth logic for that combo. As sson as one of them fails, we
  # halt.
```
