exports = module.exports = autodep;

var stack = [];

/**
 * Given a function `fn` that returns a value that depends on calls to
 * model.get(somepath), this automatically sets up listeners to somepath
 * updates so that fn gets re-evaluated.
 */
function autodep (model, fn) {
  var _get = model.get;
  model.get = function (path) {
    stack.push(path);
    return _get.call(model, path);
  };

  fn.call(model);

  stack.pop();
  model.get = _get;
}
