ANSI_CODES =
  off: 0
  bold: 1
  italic: 3
  underline: 4
  blink: 5
  inverse: 7
  hidden: 8
  black: 30
  red: 31
  green: 32
  yellow: 33
  blue: 34
  magenta: 35
  cyan: 36
  white: 37
  black_bg: 40
  red_bg: 41
  green_bg: 42
  yellow_bg: 43
  blue_bg: 44
  magenta_bg: 45
  cyan_bg: 46
  white_bg: 47

styleTag = (name) -> "\033[#{ANSI_CODES[name]}m"
style = (styles, text) ->
  out = ''
  out += styleTag style for style in styles
  text = JSON.stringify text, null, 2 unless typeof text is 'string'
  return out + text + styleTag('off')

styles = []
__log__ = console.log
console.log = (args...) ->
  if args.length == 0
    return console.log
  _styles_ = styles
  styles = []
  __log__.apply console, (style _styles_, txt for txt in args)

for k of ANSI_CODES
  console.log k
  Object.defineProperty console, k, get: do (k) ->
    return ->
      styles.push k unless ~styles.indexOf k
      return console.log
