var ANSI_CODES = {
    off: 0
  , bold: 1
  , italic: 3
  , underline: 4
  , blink: 5
  , inverse: 7
  , hidden: 8
  , black: 30
  , red: 31
  , green: 32
  , yellow: 33
  , blue: 34
  , magenta: 35
  , cyan: 36
  , white: 37
  , black_bg: 40
  , red_bg: 41
  , green_bg: 42
  , yellow_bg: 43
  , blue_bg: 44
  , magenta_bg: 45
  , cyan_bg: 46
  , white_bg: 47
};

function styleTag (name) {
  return "\033[" + ANSI_CODES[name] + "m";
}

var obj = {
    log: function () {
      var styles = this.styles;
      for (var i = 0, l = styles.length; i < l; i++) {
        console.log(styleTag(styles[i]));
      }
      console.log.apply(console, arguments);
      console.log(styleTag('off'));
    }
  , styles: []
};
for (var style in ANSI_CODES) {
  Object.defineProperty(obj, style, {
    get: (function (style) {
      return function () {
        var copy = Object.create(obj);
        copy.styles = this.styles.slice();
        copy.styles.push(style);
        return copy;
      };
    })(style)
  });
  Object.defineProperty(console, style, {
    get: (function (style) {
      return function () { return obj[style]; }
    })(style)
  });
}
