// Generated by CoffeeScript 1.3.3
var JournalRedis, LOCK, LOCKED_COMMIT, LOCK_CLOCK_MASK, LOCK_TIMEOUT, LOCK_TIMEOUT_MASK, MAX_RETRIES, Promise, RETRY_DELAY, Serializer, UNLOCK, exports, getLocks, redis, redisInfo, transaction,
  __slice = [].slice;

redis = require('redis');

redisInfo = require('./redisInfo');

transaction = Serializer = Promise = null;

exports = module.exports = function(racer) {
  transaction = racer["protected"].transaction;
  Serializer = racer["protected"].Serializer;
  Promise = racer.util.Promise;
  return racer.registerAdapter('journal', 'Redis', JournalRedis);
};

exports.useWith = {
  server: true,
  browser: false
};

exports.decorate = 'racer';

exports.JournalRedis = JournalRedis = function(options) {
  var db, host, ignoreSubscribe, password, port, redisClient, redisStarts, startIdPromise, subClient, subscribeToStarts, throwOnErr;
  port = options.port, host = options.host, db = options.db, password = options.password;
  this._redisClient = redisClient = redis.createClient(port, host, options);
  this._subClient = subClient = redis.createClient(port, host, options);
  if (password) {
    throwOnErr = function(err) {
      if (err) {
        throw err;
      }
    };
    redisClient.auth(password, throwOnErr);
    subClient.auth(password, throwOnErr);
  }
  this._startIdPromise = startIdPromise = new Promise;
  this._lockQueue = {};
  redisStarts = null;
  ignoreSubscribe = false;
  (subscribeToStarts = function(db) {
    if (ignoreSubscribe) {
      return ignoreSubscribe = false;
    }
    if (db !== void 0) {
      return redisClient.select(db, function(err) {
        if (err) {
          throw err;
        }
        return subscribeToStarts();
      });
    }
    return redisInfo.subscribeToStarts(subClient, redisClient, function(err, starts) {
      var firstStart, startId;
      if (err) {
        throw err;
      }
      redisStarts = starts;
      firstStart = starts[0];
      startId = firstStart[0];
      return startIdPromise.clear().resolve(null, startId);
    });
  })(db);
  ignoreSubscribe = true;
  redisClient.on('connect', subscribeToStarts);
  redisClient.on('end', function() {
    redisStarts = null;
    return startIdPromise.clear();
  });
};

JournalRedis.prototype = {
  flush: function(cb) {
    var redisClient, startIdPromise;
    redisClient = this._redisClient;
    startIdPromise = this._startIdPromise;
    return redisClient.flushdb(function(err) {
      if (err) {
        return cb(err);
      }
      return redisInfo.onStart(redisClient, function(err) {
        if (err) {
          return cb(err);
        }
        startIdPromise.clear();
        return cb(null);
      });
    });
  },
  disconnect: function() {
    this._redisClient.end();
    return this._subClient.end();
  },
  startId: function(cb) {
    return this._startIdPromise.on(cb);
  },
  version: function(cb) {
    return this._redisClient.get('ver', function(err, ver) {
      if (err) {
        return cb(err);
      }
      return cb(null, parseInt(ver, 10));
    });
  },
  txnsSince: function(ver, clientId, pubSub, cb) {
    if (!pubSub.hasSubscriptions(clientId)) {
      return cb(null, []);
    }
    return this._redisClient.zrangebyscore('txns', ver, '+inf', 'withscores', function(err, vals) {
      var i, txn, txns, val, _i, _len;
      if (err) {
        return cb(err);
      }
      txn = null;
      txns = [];
      for (i = _i = 0, _len = vals.length; _i < _len; i = ++_i) {
        val = vals[i];
        if (i % 2) {
          if (!pubSub.subscribedTo(clientId, transaction.getPath(txn))) {
            continue;
          }
          transaction.setVer(txn, +val);
          txns.push(txn);
        } else {
          txn = JSON.parse(val);
        }
      }
      return cb(null, txns);
    });
  },
  eachTxnSince: function(ver, opts) {
    var done, each, lock, locks, op, path, paths, redisClient, sinceVer, txn, _i, _j, _len, _len1, _ref, _ref1,
      _this = this;
    redisClient = this._redisClient;
    (_ref = opts.meta, txn = _ref.txn), each = opts.each, done = opts.done;
    sinceVer = ver == null ? '' : ver + 1;
    if (transaction.isCompound(txn)) {
      paths = (function() {
        var _i, _len, _ref1, _results;
        _ref1 = transaction.ops(txn);
        _results = [];
        for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
          op = _ref1[_i];
          _results.push(transaction.op.getPath(op));
        }
        return _results;
      })();
    } else {
      paths = [transaction.getPath(txn)];
    }
    locks = [];
    for (_i = 0, _len = paths.length; _i < _len; _i++) {
      path = paths[_i];
      _ref1 = getLocks(path);
      for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
        lock = _ref1[_j];
        if (locks.indexOf(lock) === -1) {
          locks.push(lock);
        }
      }
    }
    return this._lock(locks, sinceVer, paths, MAX_RETRIES, RETRY_DELAY, function(err, numLocks, lockVal, txns) {
      var i, next;
      path = paths[0];
      if (!(i = txns != null ? txns.length : void 0)) {
        return done(null, {
          numLocks: numLocks,
          locks: locks,
          lockVal: lockVal
        });
      }
      next = function(err) {
        var _this = this;
        if (err) {
          if (err === 'conflict' || err === 'duplicate') {
            return redisClient["eval"].apply(redisClient, [UNLOCK, numLocks].concat(__slice.call(locks), [lockVal], [function(unlockErr) {
              return done(unlockErr ? unlockErr : err);
            }]));
          } else {
            return done(err);
          }
        }
        if (txn = txns[--i]) {
          return each(null, JSON.parse(txn), next);
        }
        return done(null, {
          numLocks: numLocks,
          locks: locks,
          lockVal: lockVal
        });
      };
      return next();
    });
  },
  add: function(txn, _arg, cb) {
    var lockVal, locks, numLocks, _ref,
      _this = this;
    numLocks = _arg.numLocks, locks = _arg.locks, lockVal = _arg.lockVal;
    return (_ref = this._redisClient)["eval"].apply(_ref, [LOCKED_COMMIT, numLocks].concat(__slice.call(locks), [lockVal], [JSON.stringify(txn)], [function(err, ver) {
      var path;
      if (err) {
        return cb(err);
      }
      if (ver === 0) {
        return cb('lockReleased');
      }
      cb(null, ver);
      path = transaction.getPath(txn);
      return _this._tryNextLock(path);
    }]));
  },
  _tryNextLock: function(path) {
    var args, queue;
    if (!(queue = this._lockQueue[path])) {
      return;
    }
    if (args = queue.shift()) {
      if (!queue.length) {
        delete this._lockQueue[path];
      }
      return this._lock.apply(this, args);
    }
  },
  _lock: function(locks, sinceVer, path, retries, delay, cb) {
    var numKeys, _ref,
      _this = this;
    numKeys = locks.length;
    return (_ref = this._redisClient)["eval"].apply(_ref, [LOCK, numKeys].concat(__slice.call(locks), [sinceVer], [function(err, _arg) {
      var lockVal, queue, txns, _base;
      lockVal = _arg[0], txns = _arg[1];
      if (err) {
        return cb(err);
      }
      if (lockVal) {
        return cb(null, numKeys, lockVal, txns);
      }
      if (retries) {
        queue = (_base = _this._lockQueue)[path] || (_base[path] = []);
        queue.push([locks, sinceVer, path, retries - 1, delay * 2, cb]);
        return setTimeout(function() {
          var args;
          _this._tryNextLock(path);
          if (args = queue.shift()) {
            return _this._lock.apply(_this, args);
          }
        }, delay);
      }
      return cb('lockMaxRetries', numLocks);
    }]));
  }
};

JournalRedis.getLocks = getLocks = function(path) {
  var lockPath, segment;
  lockPath = '';
  return ((function() {
    var _i, _len, _ref, _results;
    _ref = path.split('.');
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      segment = _ref[_i];
      _results.push(lockPath += '.' + segment);
    }
    return _results;
  })()).reverse();
};

JournalRedis.MAX_RETRIES = MAX_RETRIES = 10;

JournalRedis.RETRY_DELAY = RETRY_DELAY = 5;

JournalRedis.LOCK_TIMEOUT = LOCK_TIMEOUT = 3;

JournalRedis.LOCK_TIMEOUT_MASK = LOCK_TIMEOUT_MASK = 0x100000000;

JournalRedis.LOCK_CLOCK_MASK = LOCK_CLOCK_MASK = 0x100000;

JournalRedis.LOCK = LOCK = "local now = os.time()\nlocal path = KEYS[1]\nfor i, lock in pairs(redis.call('smembers', path)) do\n  if lock % " + LOCK_TIMEOUT_MASK + " < now then\n    redis.call('srem', path, lock)\n  else\n    return 0\n  end\nend\nfor i, path in pairs(KEYS) do\n  path = 'l' .. path\n  local val = redis.call('get', path)\n  if val then\n    if val % " + LOCK_TIMEOUT_MASK + " < now then\n      redis.call('del', path)\n    else\n      return 0\n    end\n  end\nend\nlocal lock = '0x' ..\n  string.format('%x', redis.call('incr', 'lockClock') % " + LOCK_CLOCK_MASK + ") ..\n  string.format('%x', now + " + LOCK_TIMEOUT + ")\nredis.call('set', 'l' .. path, lock)\nfor i, path in pairs(KEYS) do\n  redis.call('sadd', path, lock)\nend\nlocal txns\nif ARGV[1] ~= '' then txns = redis.call('zrangebyscore', 'txns', ARGV[1], '+inf') end\nreturn {lock, txns}";

JournalRedis.UNLOCK = UNLOCK = "local val = ARGV[1]\nlocal path = 'l' .. KEYS[1]\nif redis.call('get', path) == val then redis.call('del', path) end\nfor i, path in pairs(KEYS) do\n  redis.call('srem', path, val)\nend";

JournalRedis.LOCKED_COMMIT = LOCKED_COMMIT = "local val = ARGV[1]\nlocal path = 'l' .. KEYS[1]\nlocal fail = false\nif redis.call('get', path) == val then redis.call('del', path) else fail = true end\nfor i, path in pairs(KEYS) do\n  if redis.call('srem', path, val) == 0 then return 0 end\nend\nif fail then return 0 end\nlocal ver = redis.call('incr', 'ver')\nredis.call('zadd', 'txns', ver, ARGV[2])\nreturn ver";
