// Generated by CoffeeScript 1.3.3
var getStarts, setStarts;

module.exports = {
  onStart: function(client, callback) {
    return client.multi().llen('starts').get('ver').exec(function(err, values) {
      var startsLength, ver;
      if (err) {
        if (callback) {
          return callback(err);
        }
        throw err;
      }
      startsLength = values[0], ver = values[1];
      return setStarts(client, startsLength, ver || 0, callback);
    });
  },
  _getStarts: getStarts = function(client, callback) {
    return client.lrange('starts', 0, -1, function(err, starts) {
      var start;
      if (err) {
        return callback(err);
      }
      if (starts.length === 0) {
        return client.watch('starts', function(err) {
          if (err) {
            return callback(err);
          }
          return client.llen('starts', function(err, value) {
            if (err) {
              return callback(err);
            }
            if (value > 0) {
              return client.unwatch('starts', function() {
                return getStarts(client, callback);
              });
            }
            return setStarts(client, 0, 0, function(err) {
              if (err) {
                return callback(err);
              }
              return getStarts(client, callback);
            });
          });
        });
      }
      return callback(null, (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = starts.length; _i < _len; _i++) {
          start = starts[_i];
          _results.push(start.split(','));
        }
        return _results;
      })());
    });
  },
  subscribeToStarts: function(subClient, client, callback) {
    if (!subClient.__startsListener) {
      subClient.__startsListener = true;
      subClient.on('message', function(channel, message) {
        if (!(channel === '$redisInfo' && message === 'starts')) {
          return;
        }
        return getStarts(client, callback);
      });
    }
    subClient.subscribe('$redisInfo');
    return getStarts(client, callback);
  }
};

setStarts = function(client, startsLength, ver, callback) {
  return client.multi().lpush('starts', "" + (+(new Date)) + "." + startsLength + "," + ver).publish('$redisInfo', 'starts').exec(callback);
};
