// Generated by CoffeeScript 1.3.3
var ACK_TIMEOUT_MS, EventEmitter, finishAfter, hasKeys, pathRegExp, patternedInterface;

EventEmitter = require('events').EventEmitter;

finishAfter = hasKeys = pathRegExp = null;

ACK_TIMEOUT_MS = 1000;

module.exports = function(racer) {
  finishAfter = racer.util.async.finishAfter;
  hasKeys = racer.util.hasKeys;
  pathRegExp = racer["protected"].path.regExp;
  return {
    prefixInterface: patternedInterface('prefix'),
    patternInterface: patternedInterface('pattern')
  };
};

patternedInterface = function(ns) {
  return function(pubSub, subClient, pubClient, prefix, unprefix) {
    var forwardIndex, intf, pendingPsubAcks, pendingPunsubAcks, reverseIndex;
    forwardIndex = {};
    reverseIndex = {};
    intf = {};
    subClient.on('pmessage', function(nsPatternStar, str, payload) {
      var data, subs, subscriberId, type, _ref;
      if (!(subs = forwardIndex[nsPatternStar])) {
        return;
      }
      if (!subs.re.test(unprefix(str).slice(ns.length + 1))) {
        return;
      }
      _ref = JSON.parse(payload), type = _ref.type, data = _ref.data;
      for (subscriberId in subs.subscribers) {
        pubSub.emit(type, subscriberId, data);
      }
    });
    pendingPsubAcks = {};
    pendingPunsubAcks = {};
    subClient.on('psubscribe', function(nsPatternStar, numSubscribers) {
      var ack, acks;
      if (!(acks = pendingPsubAcks[nsPatternStar])) {
        return;
      }
      if (ack = acks.shift()) {
        if (!acks.length) {
          delete pendingPsubAcks[nsPatternStar];
        }
        clearTimeout(ack.timeout);
        return ack.cb(null);
      }
    });
    subClient.on('punsubscribe', function(nsPatternStar, numSubscribers) {
      var ack, acks;
      if (!(acks = pendingPunsubAcks[nsPatternStar])) {
        return;
      }
      if (ack = acks.shift()) {
        if (!acks.length) {
          delete pendingPunsubAcks[nsPatternStar];
        }
        clearTimeout(ack.timeout);
        return ack.cb(null);
      }
    });
    intf.subscribe = function(subscriberId, pattern, ackCb) {
      var acks, nsPattern, nsPatternStar, re, subsForPattern, timeout;
      re = pathRegExp(pattern);
      nsPattern = prefix(ns + '$' + pattern);
      nsPatternStar = nsPattern + '*';
      (reverseIndex[subscriberId] || (reverseIndex[subscriberId] = {}))[nsPatternStar] = re;
      if (!(subsForPattern = forwardIndex[nsPatternStar])) {
        subsForPattern = forwardIndex[nsPatternStar] = {
          subscribers: {},
          re: re
        };
        subsForPattern.subscribers[subscriberId] = true;
        if (ackCb) {
          acks = pendingPsubAcks[nsPatternStar] || (pendingPsubAcks[nsPatternStar] = []);
          timeout = setTimeout(function() {
            return ackCb(new Error("No ack for subscribe(" + subscriberId + ", " + pattern + ")"));
          }, ACK_TIMEOUT_MS);
          acks.push({
            cb: ackCb,
            timeout: timeout
          });
        }
        return subClient.psubscribe(nsPatternStar);
      } else {
        subsForPattern.subscribers[subscriberId] = true;
        return typeof ackCb === "function" ? ackCb(null) : void 0;
      }
    };
    intf.unsubscribe = function(subscriberId, pattern, ackCb) {
      var acks, nsPatternStar, patternsForSubscriber, punsubCount, re, subs, subscribers, subscribersForPattern, timeout, toPunsubscribe, _i, _j, _len, _len1;
      if (typeof pattern !== 'string') {
        ackCb = pattern;
        if (!(patternsForSubscriber = reverseIndex[subscriberId])) {
          return typeof ackCb === "function" ? ackCb(null) : void 0;
        }
        toPunsubscribe = [];
        for (nsPatternStar in patternsForSubscriber) {
          subscribersForPattern = forwardIndex[nsPatternStar];
          delete subscribersForPattern[subscriberId];
          if (!hasKeys(subscribersForPattern)) {
            delete forwardIndex[nsPatternStar];
            toPunsubscribe.push(nsPatternStar);
          }
        }
        delete reverseIndex[subscriberId];
        if (ackCb) {
          if (!(punsubCount = toPunsubscribe.length)) {
            return ackCb(null);
          }
          if (punsubCount > 1) {
            ackCb = finishAfter(punsubCount, ackCb);
          }
          for (_i = 0, _len = toPunsubscribe.length; _i < _len; _i++) {
            nsPatternStar = toPunsubscribe[_i];
            acks = pendingPunsubAcks[nsPatternStar] || (pendingPunsubAcks[nsPatternStar] = []);
            timeout = setTimeout(function() {
              return ackCb(new Error("No ack for unsubscribe(" + subscriberId + ")"));
            }, ACK_TIMEOUT_MS);
            acks.push({
              cb: ackCb,
              timeout: timeout
            });
          }
        }
        for (_j = 0, _len1 = toPunsubscribe.length; _j < _len1; _j++) {
          nsPatternStar = toPunsubscribe[_j];
          subClient.punsubscribe(nsPatternStar);
        }
      } else {
        nsPatternStar = prefix(ns + '$' + pattern) + '*';
        if (subs = reverseIndex[subscriberId]) {
          delete subs[nsPatternStar];
          if (!hasKeys(subs)) {
            delete reverseIndex[subscriberId];
          }
        }
        if (subs = forwardIndex[nsPatternStar]) {
          subscribers = subs.subscribers, re = subs.re;
          delete subscribers[subscriberId];
          if (!hasKeys(subscribers)) {
            delete forwardIndex[nsPatternStar];
          }
        }
        if (!(nsPatternStar in forwardIndex)) {
          if (ackCb) {
            acks = pendingPunsubAcks[nsPatternStar] || (pendingPunsubAcks[nsPatternStar] = []);
            timeout = setTimeout(function() {
              return ackCb(new Error("No ack for unsubscribe(" + subscriberId + ", " + pattern + ")"));
            }, ACK_TIMEOUT_MS);
            acks.push({
              cb: ackCb,
              timeout: timeout
            });
          }
          subClient.punsubscribe(nsPatternStar);
        }
      }
    };
    intf.publish = function(_arg) {
      var params, type;
      type = _arg.type, params = _arg.params;
      switch (type) {
        case 'txn':
        case 'ot':
          return pubClient.publish(prefix(ns + '$' + params.channel), JSON.stringify({
            type: type,
            data: params.data
          }));
      }
    };
    intf.hasSubscriptions = function(subscriberId) {
      return subscriberId in reverseIndex;
    };
    intf.subscribedTo = function(subscriberId, path) {
      var re, _, _ref;
      _ref = reverseIndex[subscriberId];
      for (_ in _ref) {
        re = _ref[_];
        if (re.test(path)) {
          return true;
        }
      }
      return false;
    };
    return intf;
  };
};
