// Generated by CoffeeScript 1.3.3
var stringInterface;

module.exports = stringInterface = function(pubSub, subClient, pubClient, prefix, unprefix) {
  var forwardIndex, pendingSubAcks, pendingUnsubAcks, reverseIndex;
  forwardIndex = {};
  reverseIndex = {};
  subClient.on('message', function(nsStr, payload) {
    var data, subscriberId, subscribers, type, _ref;
    if (subscribers = forwardIndex[nsStr]) {
      _ref = JSON.parse(payload), type = _ref.type, data = _ref.data;
      for (subscriberId in subscribers) {
        pubSub.emit(type, subscriberId, data);
      }
    }
  });
  pendingSubAcks = {};
  pendingUnsubAcks = {};
  subClient.on('subscribe', function(nsStr, numSubscribers) {
    var ack, acks;
    if (!(acks = pendingSubAcks[nsStr])) {
      return;
    }
    if (ack = acks.shift()) {
      if (!acks.length) {
        delete pendingSubAcks[nsStr];
      }
      clearTimeout(ack.timeout);
      return ack.cb(null);
    }
  });
  subClient.on('unsubscribe', function(nsStr, numSubscribers) {
    var ack, acks;
    if (!(acks = pendingUnsubAcks[nsStr])) {
      return;
    }
    if (ack = acks.shift()) {
      if (!acks.length) {
        delete pendingUnsubAcks[nsStr];
      }
      clearTimeout(ack.timeout);
      return ack.cb(null);
    }
  });
  return {
    subscribe: function(subscriberId, str, ackCb) {
      var acks, nsStr, subsForStr, timeout;
      nsStr = prefix(str);
      (reverseIndex[subscriberId] || (reverseIndex[subscriberId] = {}))[nsStr] = true;
      if (!(subsForStr = forwardIndex[nsStr])) {
        subsForStr = forwardIndex[nsStr] = {};
        subsForStr[subscriberId] = true;
        if (ackCb) {
          acks = pendingSubAcks[nsStr] || (pendingSubAcks[nsStr] = []);
          timeout = setTimeout(function() {
            return ackCb(new Error("No ack for subscribe(" + subscriberId + ", " + str + ")"));
          }, 200);
          acks.push({
            cb: ackCb,
            timeout: timeout
          });
        }
        return subClient.subscribe(nsStr);
      } else {
        subsForStr[subscriberId] = true;
        return typeof ackCb === "function" ? ackCb(null) : void 0;
      }
    },
    unsubscribe: function(subscriberId, str, ackCb) {
      var acks, nsStr, redisUnsubCount, stringsForSubscriber, stringsRedisUnsub, subs, subscribersForStr, timeout, _i, _j, _len, _len1;
      if (typeof str !== 'string') {
        ackCb = str;
        if (!(stringsForSubscriber = reverseIndex[subscriberId])) {
          return typeof ackCb === "function" ? ackCb(null) : void 0;
        }
        stringsRedisUnsub = [];
        for (nsStr in stringsForSubscriber) {
          subscribersForStr = forwardIndex[nsStr];
          delete subscribersForStr[subscriberId];
          if (!hasKeys(subscribersForStr)) {
            delete forwardIndex[nsStr];
            stringsRedisUnsub.push(nsStr);
          }
        }
        delete reverseIndex[subscriberId];
        if (ackCb) {
          if (!(redisUnsubCount = stringsRedisUnsub.length)) {
            return ackCb(null);
          }
          if (redisUnsubCount > 1) {
            ackCb = finishAfter(redisUnsubCount, ackCb);
          }
          for (_i = 0, _len = stringsRedisUnsub.length; _i < _len; _i++) {
            nsStr = stringsRedisUnsub[_i];
            acks = pendingUnsubAcks[nsStr] || (pendingUnsubAcks[nsStr] = []);
            timeout = setTimeout(function() {
              return ackCb(new Error("No ack for unsubscribe(" + subscriberId + ")"));
            }, ACK_TIMEOUT_MS);
            acks.push({
              cb: ackCb,
              timeout: timeout
            });
          }
        }
        for (_j = 0, _len1 = stringsRedisUnsub.length; _j < _len1; _j++) {
          nsStr = stringsRedisUnsub[_j];
          subClient.unsubscribe(nsStr);
        }
      } else {
        nsStr = prefix(str);
        if (subs = reverseIndex[subscriberId]) {
          delete subs[nsStr];
          if (!hasKeys(subs)) {
            delete reverseIndex[subscriberId];
          }
        }
        if (subs = forwardIndex[nsStr]) {
          delete subs[subscriberId];
          if (!hasKeys(subs)) {
            delete forwardIndex[nsStr];
          }
        }
        if (!(nsStr in forwardIndex)) {
          if (ackCb) {
            acks = pendingUnsubAcks[nsStr] || (pendingUnsubAcks[nsStr] = []);
            timeout = setTimeout(function() {
              return ackCb(new Error("No ack for unsubscribe(" + subscriberId + ", " + str + ")"));
            }, ACK_TIMEOUT_MS);
            acks.push({
              cb: ackCb,
              timeout: timeout
            });
          }
          subClient.unsubscribe(nsStr);
        }
      }
    },
    publish: function(_arg) {
      var params, type;
      type = _arg.type, params = _arg.params;
      switch (type) {
        case 'direct':
        case 'txn':
          return pubClient.publish(prefix(params.channel), JSON.stringify({
            type: type,
            data: params.data
          }));
      }
    },
    hasSubscriptions: function(subscriberId) {
      return subscriberId in reverseIndex;
    },
    subscribedTo: function(subscriberId, str) {
      var stringsForSubscriber;
      if (!(stringsForSubscriber = reverseIndex[subscriberId])) {
        return false;
      }
      return path in stringsForSubscriber;
    }
  };
};
