// Generated by CoffeeScript 1.3.3
var exports, patterned, redis, stringInterface;

redis = require('redis');

patterned = require('./channel-interface-patterned');

stringInterface = require('./channel-interface-string');

exports = module.exports = function(racer, options) {
  var patternInterface, prefixInterface, _ref;
  if (options == null) {
    options = {};
  }
  _ref = patterned(racer), patternInterface = _ref.patternInterface, prefixInterface = _ref.prefixInterface;
  racer.mixin({
    type: 'Store',
    events: {
      init: function(store) {
        var db, host, ns, nsLen, password, port, prefix, pubClient, pubSub, subClient, throwOnErr, unprefix, __publish,
          _this = this;
        port = options.port, host = options.host, db = options.db, password = options.password;
        subClient = redis.createClient(port, host, options);
        pubClient = redis.createClient(port, host, options);
        if (password) {
          throwOnErr = function(err) {
            if (err) {
              throw err;
            }
          };
          subClient.password(password, throwOnErr);
          pubClient.password(password, throwOnErr);
        }
        ns = (db || 0) + '.';
        nsLen = ns.length;
        prefix = function(x) {
          return ns + x;
        };
        unprefix = function(x) {
          return x.slice(nsLen);
        };
        pubSub = store._pubSub;
        pubSub.on('disconnect', function() {
          pubClient.end();
          return subClient.end();
        });
        if (options.pattern) {
          pubSub.addChannelInterface('pattern', patternInterface(pubSub, subClient, pubClient, prefix, unprefix));
        }
        if (options.prefix) {
          pubSub.addChannelInterface('prefix', prefixInterface(pubSub, subClient, pubClient, prefix, unprefix));
        }
        if (options.string) {
          pubSub.addChannelInterface('string', stringInterface(pubSub, subClient, pubClient, prefix, unprefix));
        }
        if (options.debug) {
          ['subscribe', 'unsubscribe', 'psubscribe', 'punsubscribe'].forEach(function(event) {
            return subClient.on(event, function(channel, count) {
              return console.log("" + (event.toUpperCase()) + " " + channel + " COUNT = " + count);
            });
          });
          subClient.on('message', function(channel, message) {
            return console.log("MESSAGE " + channel + " " + message);
          });
          subClient.on('pmessage', function(pattern, channel, message) {
            return console.log("PMESSAGE " + pattern + " " + channel + " " + message);
          });
          __publish = subClient.publish;
          return subClient.publish = function(channel, msg) {
            console.log("PUBLISH " + channel + " " + (JSON.stringify(message)));
            return __publish.call(subClient, channel, message);
          };
        }
      }
    }
  });
};

exports.useWith = {
  server: true,
  browser: false
};

exports.decorate = 'racer';
