var Connection, Doc, MicroEvent, connections, getConnection, io, open, types;
var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
if (typeof WEB !== "undefined" && WEB !== null) {
  types || (types = exports.types);
  if (!window.io) {
    throw new Error('Must load socket.io before this library');
  }
  io = window.io;
} else {
  types = require('../types');
  io = require('socket.io-client');
  MicroEvent = require('./microevent');
}
/** @constructor */;
Doc = function(connection, name, version, type, snapshot) {
  var inflightCallbacks, inflightOp, k, otApply, pendingCallbacks, pendingOp, serverOps, setSnapshot, tryFlushPendingOp, v, xf, _ref;
  this.name = name;
  this.version = version;
  this.type = type;
  if (this.type.compose == null) {
    throw new Error('Handling types without compose() defined is not currently implemented');
  }
  setSnapshot = __bind(function(s) {
    return this.snapshot = s;
  }, this);
  setSnapshot(snapshot);
  inflightOp = null;
  inflightCallbacks = [];
  pendingOp = null;
  pendingCallbacks = [];
  serverOps = {};
  xf = this.type.transformX || __bind(function(client, server) {
    var client_, server_;
    client_ = this.type.transform(client, server, 'left');
    server_ = this.type.transform(server, client, 'right');
    return [client_, server_];
  }, this);
  otApply = __bind(function(docOp, isRemote) {
    var oldSnapshot;
    oldSnapshot = this.snapshot;
    setSnapshot(this.type.apply(this.snapshot, docOp));
    if (isRemote) {
      this.emit('remoteop', docOp, oldSnapshot);
    }
    return this.emit('change', docOp, oldSnapshot);
  }, this);
  tryFlushPendingOp = __bind(function() {
    if (inflightOp === null && pendingOp !== null) {
      inflightOp = pendingOp;
      inflightCallbacks = pendingCallbacks;
      pendingOp = null;
      pendingCallbacks = [];
      return connection.send({
        'doc': this.name,
        'op': inflightOp,
        'v': this.version
      }, __bind(function(response, error) {
        var callback, oldInflightOp, undo, _i, _j, _len, _len2, _ref;
        oldInflightOp = inflightOp;
        inflightOp = null;
        if (error) {
          if (type.invert) {
            undo = this.type.invert(oldInflightOp);
            if (pendingOp) {
              _ref = xf(pendingOp, undo), pendingOp = _ref[0], undo = _ref[1];
            }
            otApply(undo, true);
          } else {
            throw new Error("Op apply failed (" + response.error + ") and the OT type does not define an invert function.");
          }
          for (_i = 0, _len = inflightCallbacks.length; _i < _len; _i++) {
            callback = inflightCallbacks[_i];
            callback(null, error);
          }
        } else {
          if (response.v !== this.version) {
            throw new Error('Invalid version from server');
          }
          serverOps[this.version] = oldInflightOp;
          this.version++;
          for (_j = 0, _len2 = inflightCallbacks.length; _j < _len2; _j++) {
            callback = inflightCallbacks[_j];
            callback(oldInflightOp, null);
          }
        }
        return tryFlushPendingOp();
      }, this));
    }
  }, this);
  this._onOpReceived = function(msg) {
    var docOp, op, _ref, _ref2;
    if (msg.v < this.version) {
      return;
    }
    if (msg.doc !== this.name) {
      throw new Error("Expected docName '" + this.name + "' but got " + msg.doc);
    }
    if (msg.v !== this.version) {
      throw new Error("Expected version " + this.version + " but got " + msg.v);
    }
    op = msg.op;
    serverOps[this.version] = op;
    docOp = op;
    if (inflightOp !== null) {
      _ref = xf(inflightOp, docOp), inflightOp = _ref[0], docOp = _ref[1];
    }
    if (pendingOp !== null) {
      _ref2 = xf(pendingOp, docOp), pendingOp = _ref2[0], docOp = _ref2[1];
    }
    this.version++;
    return otApply(docOp, true);
  };
  this.submitOp = function(op, callback) {
    if (this.type.normalize != null) {
      op = this.type.normalize(op);
    }
    setSnapshot(this.type.apply(this.snapshot, op));
    if (pendingOp !== null) {
      pendingOp = this.type.compose(pendingOp, op);
    } else {
      pendingOp = op;
    }
    if (callback) {
      pendingCallbacks.push(callback);
    }
    this.emit('change', op);
    return setTimeout(tryFlushPendingOp, 0);
  };
  this.flush = function() {
    return tryFlushPendingOp();
  };
  this.close = function(callback) {
    return connection.send({
      'doc': this.name,
      open: false
    }, __bind(function() {
      if (callback) {
        callback();
      }
      this.emit('closed');
    }, this));
  };
  if (this.type.api) {
    _ref = this.type.api;
    for (k in _ref) {
      v = _ref[k];
      this[k] = v;
    }
    if (typeof this._register === "function") {
      this._register();
    }
  } else {
    this.provides = {};
  }
  return this;
};
MicroEvent.mixin(Doc);
Connection = (function() {
  function Connection(origin) {
    this.onMessage = __bind(this.onMessage, this);
    this.connected = __bind(this.connected, this);
    this.disconnected = __bind(this.disconnected, this);    this.docs = {};
    this.numDocs = 0;
    this.handlers = {};
    this.socket = io.connect(origin, {
      'force new connection': true
    });
    this.socket.on('connect', this.connected);
    this.socket.on('disconnect', this.disconnected);
    this.socket.on('message', this.onMessage);
    this.socket.on('connect_failed', __bind(function(error) {
      var callback, callbacks, docName, h, t, _ref, _results;
      if (error === 'unauthorized') {
        error = 'forbidden';
      }
      this.socket = null;
      this.emit('connect failed', error);
      _ref = this.handlers;
      _results = [];
      for (docName in _ref) {
        h = _ref[docName];
        _results.push((function() {
          var _results2;
          _results2 = [];
          for (t in h) {
            callbacks = h[t];
            _results2.push((function() {
              var _i, _len, _results3;
              _results3 = [];
              for (_i = 0, _len = callbacks.length; _i < _len; _i++) {
                callback = callbacks[_i];
                _results3.push(callback(null, error));
              }
              return _results3;
            })());
          }
          return _results2;
        })());
      }
      return _results;
    }, this));
    if (this.socket.socket.connected) {
      setTimeout((__bind(function() {
        return this.connected();
      }, this)), 0);
    }
  }
  Connection.prototype.disconnected = function() {
    return this.emit('disconnect');
  };
  Connection.prototype.connected = function() {
    return this.emit('connect');
  };
  Connection.prototype.send = function(msg, callback) {
    var callbacks, docHandlers, docName, type, _base;
    if (this.socket === null) {
      throw new Error('Cannot send messages to a closed connection');
    }
    docName = msg.doc;
    if (docName === this.lastSentDoc) {
      delete msg.doc;
    } else {
      this.lastSentDoc = docName;
    }
    this.socket.json.send(msg);
    if (callback) {
      type = msg.open === true ? 'open' : msg.open === false ? 'close' : msg.create ? 'create' : msg.snapshot === null ? 'snapshot' : msg.op ? 'op response' : void 0;
      docHandlers = ((_base = this.handlers)[docName] || (_base[docName] = {}));
      callbacks = (docHandlers[type] || (docHandlers[type] = []));
      return callbacks.push(callback);
    }
  };
  Connection.prototype.onMessage = function(msg) {
    var c, callbacks, doc, docName, type, _i, _len, _ref;
    docName = msg.doc;
    if (docName !== void 0) {
      this.lastReceivedDoc = docName;
    } else {
      msg.doc = docName = this.lastReceivedDoc;
    }
    this.emit('message', msg);
    type = msg.open === true || (msg.open === false && msg.error) ? 'open' : msg.open === false ? 'close' : msg.snapshot !== void 0 ? 'snapshot' : msg.create ? 'create' : msg.op ? 'op' : msg.v !== void 0 ? 'op response' : void 0;
    callbacks = (_ref = this.handlers[docName]) != null ? _ref[type] : void 0;
    if (callbacks) {
      delete this.handlers[docName][type];
      for (_i = 0, _len = callbacks.length; _i < _len; _i++) {
        c = callbacks[_i];
        c(msg, msg.error);
      }
    }
    if (type === 'op') {
      doc = this.docs[docName];
      if (doc) {
        return doc._onOpReceived(msg);
      }
    }
  };
  Connection.prototype.makeDoc = function(params) {
    var doc, name, type;
    name = params.doc;
    if (this.docs[name]) {
      throw new Error("Doc " + name + " already open");
    }
    type = params.type;
    if (typeof type === 'string') {
      type = types[type];
    }
    doc = new Doc(this, name, params.v, type, params.snapshot);
    doc.created = !!params.create;
    this.docs[name] = doc;
    this.numDocs++;
    doc.on('closed', __bind(function() {
      delete this.docs[name];
      return this.numDocs--;
    }, this));
    return doc;
  };
  Connection.prototype['openExisting'] = function(docName, callback) {
    if (this.socket === null) {
      callback(null, 'connection closed');
      return;
    }
    if (this.docs[docName] != null) {
      return this.docs[docName];
    }
    return this.send({
      'doc': docName,
      'open': true,
      'snapshot': null
    }, __bind(function(response, error) {
      if (error) {
        return callback(null, error);
      } else {
        return callback(this.makeDoc(response));
      }
    }, this));
  };
  Connection.prototype.open = function(docName, type, callback) {
    var doc;
    if (this.socket === null) {
      callback(null, 'connection closed');
      return;
    }
    if (typeof type === 'function') {
      callback = type;
      type = 'text';
    }
    callback || (callback = function() {});
    if (typeof type === 'string') {
      type = types[type];
    }
    if (!type) {
      throw new Error("OT code for document type missing");
    }
    if ((docName != null) && (this.docs[docName] != null)) {
      doc = this.docs[docName];
      if (doc.type === type) {
        callback(doc);
      } else {
        callback(doc, 'Type mismatch');
      }
      return;
    }
    return this.send({
      'doc': docName,
      'open': true,
      'create': true,
      'snapshot': null,
      'type': type.name
    }, __bind(function(response, error) {
      if (error) {
        return callback(null, error);
      } else {
        if (response.snapshot === void 0) {
          response.snapshot = type.create();
        }
        response.type = type;
        return callback(this.makeDoc(response));
      }
    }, this));
  };
  Connection.prototype.create = function(type, callback) {
    return open(null, type, callback);
  };
  Connection.prototype.disconnect = function() {
    if (this.socket) {
      this.emit('disconnected');
      this.socket.disconnect();
      return this.socket = null;
    }
  };
  return Connection;
})();
MicroEvent.mixin(Connection);
connections = {};
getConnection = function(origin) {
  var c, location;
  if (typeof WEB !== "undefined" && WEB !== null) {
    location = window.location;
    if (origin == null) {
      origin = "" + location.protocol + "//" + location.hostname + "/sjs";
    }
  }
  if (!connections[origin]) {
    c = new Connection(origin);
    c.on('disconnected', function() {
      return delete connections[origin];
    });
    c.on('connect failed', function() {
      return delete connections[origin];
    });
    connections[origin] = c;
  }
  return connections[origin];
};
open = function(docName, type, origin, callback) {
  var c;
  if (typeof origin === 'function') {
    callback = origin;
    origin = null;
  }
  c = getConnection(origin);
  c.open(docName, type, function(doc, error) {
    if (doc === null) {
      if (c.numDocs === 0) {
        c.disconnect();
      }
      return callback(null, error);
    } else {
      doc.on('closed', function() {
        return setTimeout(function() {
          if (c.numDocs === 0) {
            return c.disconnect();
          }
        }, 0);
      });
      return callback(doc);
    }
  });
  return c.on('connect failed');
};
exports.Connection = Connection;
exports.Doc = Doc;
exports.open = open;