var defaultType;
defaultType = 'redis';
module.exports = function(options) {
  var Db, type, _ref;
  type = (_ref = options != null ? options.type : void 0) != null ? _ref : defaultType;
  Db = (function() {
    switch (type) {
      case 'redis':
        return require('./redis');
      case 'memory':
        return require('./memory');
      default:
        throw new Error("Invalid or unsupported database type: '" + type + "'");
    }
  })();
  return new Db(options);
};