module.exports = function() {
  var docs;
  docs = {};
  return {
    getOps: function(docName, start, end, callback) {
      var ops, _ref;
      ops = (_ref = docs[docName]) != null ? _ref.ops : void 0;
      if (ops != null) {
        if (end == null) {
          end = ops.length;
        }
        return callback(ops.slice(start, end));
      } else {
        return callback([]);
      }
    },
    create: function(docName, data, callback) {
      if (docs[docName]) {
        return callback(false, 'Document already exists');
      } else {
        if (data.snapshot === void 0) {
          throw new Error('snapshot missing from data');
        }
        if (data.type === void 0) {
          throw new Error('type missing from data');
        }
        if (typeof data.v !== 'number') {
          throw new Error('version missing from data');
        }
        if (typeof data.meta !== 'object') {
          throw new Error('meta missing from data');
        }
        docs[docName] = {
          ops: [],
          data: data
        };
        return callback(true);
      }
    },
    "delete": function(docName, callback) {
      if (docs[docName] != null) {
        delete docs[docName];
        if (callback != null) {
          return callback(true);
        }
      } else {
        if (callback != null) {
          return callback(false, 'Document does not exist');
        }
      }
    },
    append: function(docName, opData, docData, callback) {
      var doc, new_op_data;
      if (docData.snapshot === void 0) {
        throw new Error('snapshot missing from data');
      }
      if (docData.type === void 0) {
        throw new Error('type missing from data');
      }
      doc = docs[docName];
      if (doc == null) {
        throw new Error('doc missing');
      }
      if (opData.v !== doc.ops.length) {
        throw new Error('Version mismatch in db.append');
      }
      new_op_data = {
        op: opData.op,
        v: opData.v
      };
      if (opData.meta != null) {
        new_op_data.meta = opData.meta;
      }
      doc.ops.push(new_op_data);
      doc.data = docData;
      return callback();
    },
    getSnapshot: function(docName, callback) {
      var data, doc;
      doc = docs[docName];
      if (doc != null) {
        data = {
          snapshot: doc.data.snapshot,
          v: doc.data.v,
          type: doc.data.type,
          meta: doc.data.meta
        };
        return callback(data);
      } else {
        return callback(null, 'Document does not exist');
      }
    },
    getVersion: function(docName, callback) {
      var _ref, _ref2;
      return callback((_ref = (_ref2 = docs[docName]) != null ? _ref2.ops.length : void 0) != null ? _ref : null);
    },
    close: function() {}
  };
};