var RedisDb, defaultOptions, redis;
redis = require('redis');
defaultOptions = {
  prefix: 'ShareJS:',
  hostname: null,
  port: null,
  redisOptions: null,
  testing: false
};
module.exports = RedisDb = function(options) {
  var client, k, keyForDoc, keyForOps, v, _ref;
  if (!(this instanceof RedisDb)) {
    return new Db;
  }
  if (options == null) {
    options = {};
  }
  for (k in defaultOptions) {
    v = defaultOptions[k];
    if ((_ref = options[k]) == null) {
      options[k] = v;
    }
  }
  keyForOps = function(docName) {
    return "" + options.prefix + "ops:" + docName;
  };
  keyForDoc = function(docName) {
    return "" + options.prefix + "doc:" + docName;
  };
  client = redis.createClient(options.port, options.hostname, options.redisOptions);
  if (options.testing) {
    client.select(15);
  }
  this.create = function(docName, data, callback) {
    var value;
    value = JSON.stringify(data);
    return client.setnx(keyForDoc(docName), value, function(err, result) {
      if (err != null) {
        throw err;
      }
      if (callback) {
        if (result) {
          return callback(true);
        } else {
          return callback(false, 'Document already exists');
        }
      }
    });
  };
  this.getOps = function(docName, start, end, callback) {
    if (start === end) {
      callback([]);
      return;
    }
    if (end != null) {
      end--;
    } else {
      end = -1;
    }
    return client.lrange(keyForOps(docName), start, end, function(err, values) {
      var data, ops, value;
      if (err != null) {
        throw err;
      }
      v = start;
      ops = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = values.length; _i < _len; _i++) {
          value = values[_i];
          data = JSON.parse(value);
          data.v = v++;
          _results.push(data);
        }
        return _results;
      })();
      return callback(ops);
    });
  };
  this.append = function(docName, op_data, doc_data, callback) {
    var json, new_op_data, resultingVersion;
    if (doc_data.snapshot === void 0) {
      throw new Error('snapshot missing from data');
    }
    if (doc_data.type === void 0) {
      throw new Error('type missing from data');
    }
    resultingVersion = op_data.v + 1;
    if (doc_data.v !== resultingVersion) {
      throw new Error('version missing or incorrect in doc data');
    }
    new_op_data = {
      op: op_data.op,
      meta: op_data.meta
    };
    json = JSON.stringify(new_op_data);
    client.rpush(keyForOps(docName), json, function(err, response) {
      if (err != null) {
        throw err;
      }
      if (resultingVersion !== response) {
        throw "Version mismatch in db.append. '" + docName + "' is corrupted.";
      }
    });
    return client.set(keyForDoc(docName), JSON.stringify(doc_data), function(err, response) {
      if (err != null) {
        throw err;
      }
      return callback();
    });
  };
  this.getSnapshot = function(docName, callback) {
    return client.get(keyForDoc(docName), function(err, response) {
      var doc_data;
      if (err != null) {
        throw err;
      }
      if (response !== null) {
        doc_data = JSON.parse(response);
        return callback(doc_data);
      } else {
        return callback(null, 'Document does not exist');
      }
    });
  };
  this.getVersion = function(docName, callback) {
    return client.llen(keyForOps(docName), function(err, response) {
      if (err != null) {
        throw err;
      }
      if (response === 0) {
        return client.exists(keyForDoc(docName), function(err, response) {
          if (err != null) {
            throw err;
          }
          if (response) {
            return callback(0);
          } else {
            return callback(null);
          }
        });
      } else {
        return callback(response);
      }
    });
  };
  this["delete"] = function(docName, callback) {
    client.del(keyForOps(docName));
    return client.del(keyForDoc(docName), function(err, response) {
      if (err != null) {
        throw err;
      }
      if (callback) {
        if (response === 1) {
          return callback(true);
        } else {
          return callback(false, 'Document does not exist');
        }
      }
    });
  };
  this.close = function() {
    return client.quit();
  };
  return this;
};