var Events, Model, db, hat, i, p, queue, types;
var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
p = function() {};
i = function() {};
hat = require('hat');
queue = require('./syncqueue');
types = require('../types');
db = require('./db');
Events = require('./events');
module.exports = Model = function(db, options) {
  var auth, createClient, doAuth, events, getSnapshot, queues;
  if (!(this instanceof Model)) {
    return new Model(db);
  }
  if (options == null) {
    options = {};
  }
  this.getOps = function(docName, start, end, callback) {
    return db.getVersion(docName, function(v) {
      if (v === null) {
        return callback(null, 'Document does not exist');
      } else {
        return db.getOps(docName, start, end, callback);
      }
    });
  };
  this.getSnapshot = getSnapshot = function(docName, callback) {
    return db.getSnapshot(docName, function(data, error) {
      p("getSnapshot " + (i(data)));
      if (data != null) {
        if (data != null ? data.type : void 0) {
          data.type = types[data.type];
        }
        return callback(data);
      } else {
        return callback(data, error);
      }
    });
  };
  this.getVersion = db.getVersion;
  this.create = function(docName, type, meta, callback) {
    var newDocData;
    if (typeof type === 'string') {
      type = types[type];
    }
    if (typeof meta === 'function') {
      callback = meta;
      meta = {};
    }
    if (docName.match(/\//)) {
      callback(false, 'Invalid document name');
      return;
    }
    meta || (meta = {});
    newDocData = {
      snapshot: type.create(),
      type: type.name,
      meta: meta || {},
      v: 0
    };
    p("db.create " + docName + ", " + (i(newDocData)));
    return db.create(docName, newDocData, callback);
  };
  queues = {};
  this.applyOp = function(docName, opData, callback) {
    p("applyOp " + docName + " op " + (i(opData)));
    queues[docName] || (queues[docName] = queue(function(opData, callback) {
      p("applyOpInternal v" + opData.v + " " + (i(opData.op)) + " to " + docName + ".");
      return getSnapshot(docName, function(docData) {
        var meta, op, opVersion, snapshot, submit, type, version;
        if (!docData) {
          callback(null, 'Document does not exist');
          return;
        }
        opVersion = opData.v;
        op = opData.op;
        meta = opData.meta || {};
        meta.ts = Date.now();
        version = docData.v, snapshot = docData.snapshot, type = docData.type;
        p("applyOp hasdata v" + opVersion + " " + (i(op)) + " to " + docName + ".");
        submit = function() {
          var newDocData, newOpData;
          try {
            snapshot = docData.type.apply(docData.snapshot, op);
          } catch (error) {
            callback(null, error.message);
            return;
          }
          newOpData = {
            op: op,
            v: opVersion,
            meta: meta
          };
          newDocData = {
            snapshot: snapshot,
            type: type.name,
            v: opVersion + 1,
            meta: docData.meta
          };
          p("submit " + (i(newOpData)));
          return db.append(docName, newOpData, newDocData, function() {
            p("appended v" + opVersion + " to " + docName + ". Calling callback...");
            events.onApplyOp(docName, newOpData);
            return callback(opVersion, void 0);
          });
        };
        if (opVersion > version) {
          callback(null, 'Op at future version');
          return;
        }
        if (opVersion < version) {
          return db.getOps(docName, opVersion, version, function(ops) {
            var realOp, _i, _len;
            try {
              for (_i = 0, _len = ops.length; _i < _len; _i++) {
                realOp = ops[_i];
                p("XFORM Doc " + docName + " op " + (i(op)) + " by " + (i(realOp.op)));
                op = docData.type.transform(op, realOp.op, 'left');
                opVersion++;
                p("-> " + (i(op)));
              }
            } catch (error) {
              callback(null, error.message);
              return;
            }
            return submit();
          });
        } else {
          return submit();
        }
      });
    }));
    return process.nextTick(function() {
      return queues[docName](opData, callback);
    });
  };
  this["delete"] = function(docName, callback) {
    events.removeAllListeners(docName);
    return db["delete"](docName, callback);
  };
  events = new Events(this);
  this.listen = events.listen;
  this.removeListener = events.removeListener;
  this.listenFromVersion = events.listenFromVersion;
  auth = options.auth || function(client, action) {
    var _ref;
    if ((_ref = action.type) === 'connect' || _ref === 'read' || _ref === 'create' || _ref === 'update') {
      return action.accept();
    } else {
      return action.reject();
    }
  };
  doAuth = function(client, actionData, name, userCallback, acceptCallback) {
    var action, responded;
    action = actionData || {};
    action.name = name;
    action.type = (function() {
      switch (name) {
        case 'connect':
          return 'connect';
        case 'create':
          return 'create';
        case 'get snapshot':
        case 'get ops':
        case 'listen':
          return 'read';
        case 'submit op':
          return 'update';
        case 'delete':
          return 'delete';
        default:
          throw new Error("Invalid action name " + name);
      }
    })();
    responded = false;
    action.reject = function() {
      if (responded) {
        throw new Error('Multiple accept/reject calls made');
      }
      responded = true;
      return userCallback(null, 'forbidden');
    };
    action.accept = function() {
      if (responded) {
        throw new Error('Multiple accept/reject calls made');
      }
      responded = true;
      return acceptCallback();
    };
    return auth(client, action);
  };
  createClient = function(data) {
    return {
      id: hat(),
      connectTime: new Date,
      headers: data.headers,
      remoteAddress: data.remoteAddress
    };
  };
  this.clientConnect = function(data, callback) {
    var client;
    client = createClient(data);
    return doAuth(client, null, 'connect', callback, function() {
      return callback(client);
    });
  };
  this.clientGetOps = function(client, docName, start, end, callback) {
    return doAuth(client, {
      docName: docName,
      start: start,
      end: end
    }, 'get ops', callback, __bind(function() {
      return this.getOps(docName, start, end, callback);
    }, this));
  };
  this.clientGetSnapshot = function(client, docName, callback) {
    return doAuth(client, {
      docName: docName
    }, 'get snapshot', callback, __bind(function() {
      return this.getSnapshot(docName, callback);
    }, this));
  };
  this.clientCreate = function(client, docName, type, meta, callback) {
    if (typeof type === 'string') {
      type = types[type];
    }
    return doAuth(client, {
      docName: docName,
      docType: type,
      meta: meta
    }, 'create', callback, __bind(function() {
      return this.create(docName, type, meta, callback);
    }, this));
  };
  this.clientSubmitOp = function(client, docName, opData, callback) {
    opData.meta || (opData.meta = {});
    return doAuth(client, {
      docName: docName,
      op: opData.op,
      v: opData.v,
      meta: opData.meta
    }, 'submit op', callback, __bind(function() {
      return this.applyOp(docName, opData, callback);
    }, this));
  };
  this.clientDelete = function(client, docName, callback) {
    return doAuth(client, {
      docName: docName
    }, 'delete', callback, __bind(function() {
      return this["delete"](docName, callback);
    }, this));
  };
  this.clientListen = function(client, docName, listener, callback) {
    return doAuth(client, {
      docName: docName
    }, 'listen', callback, __bind(function() {
      return this.listen(docName, listener, callback);
    }, this));
  };
  this.clientListenFromVersion = function(client, docName, version, listener, callback) {
    return doAuth(client, {
      docName: docName,
      start: version,
      end: null
    }, 'get ops', callback, __bind(function() {
      return doAuth(client, {
        docName: docName,
        v: version
      }, 'listen', callback, __bind(function() {
        return this.listenFromVersion(docName, version, listener, callback);
      }, this));
    }, this));
  };
  return this;
};