var hat, i, p, socketio, util;
socketio = require('socket.io');
util = require('util');
hat = require('hat');
p = function() {};
i = function() {};
exports.attach = function(server, model, options) {
  var authClient, io;
  io = socketio.listen(server);
  io.configure(function() {
    return io.set('log level', 1);
  });
  authClient = function(handshakeData, callback) {
    var data;
    data = {
      headers: handshakeData.headers,
      remoteAddress: handshakeData.address.address,
      secure: handshakeData.secure
    };
    return model.clientConnect(data, function(client, error) {
      if (error) {
        return callback(null, false);
      } else {
        handshakeData.client = client;
        return callback(null, true);
      }
    });
  };
  io.of('/sjs').authorization(authClient).on('connection', function(socket) {
    var client, close, closed, docState, flush, handleClose, handleOp, handleOpenCreateSnapshot, lastReceivedDoc, lastSentDoc, messageListener, open, send;
    client = socket.handshake.client;
    if (socket.request != null) {
      p("New socket connected from " + socket.request.socket.remoteAddress + " with id " + socket.id);
    }
    lastSentDoc = null;
    lastReceivedDoc = null;
    docState = {};
    closed = false;
    send = function(msg) {
      if (msg.doc === lastSentDoc) {
        delete msg.doc;
      } else {
        lastSentDoc = msg.doc;
      }
      p("Sending " + (i(msg)));
      return socket.json.send(msg);
    };
    open = function(docName, version, callback) {
      var listener, openedAt;
      if (docState[docName].listener != null) {
        callback(null, 'Doc already opened');
      }
      p("Registering listener on " + docName + " by " + socket.id + " at " + version);
      docState[docName].listener = listener = function(opData) {
        var opMsg, _ref, _ref2;
        if (docState[docName].listener !== listener) {
          throw new Error('Consistency violation - doc listener invalid');
        }
        p("listener doc:" + docName + " opdata:" + (i(opData)) + " v:" + version);
        if ((((_ref2 = opData.meta) != null ? _ref2.source : void 0) === (_ref = socket.id) && _ref !== void 0)) {
          return;
        }
        opMsg = {
          doc: docName,
          op: opData.op,
          v: opData.v,
          meta: opData.meta
        };
        return send(opMsg);
      };
      openedAt = function(version, error) {
        if (version === null) {
          error || (error = 'Document does not exist');
        }
        if (error) {
          callback(null, error);
        } else {
          callback(version);
        }
      };
      if (version != null) {
        return model.clientListenFromVersion(client, docName, version, listener, openedAt);
      } else {
        return model.clientListen(client, docName, listener, openedAt);
      }
    };
    close = function(docName, callback) {
      var listener;
      p("Closing " + docName);
      listener = docState[docName].listener;
      if (listener == null) {
        callback('Doc already closed');
        return;
      }
      model.removeListener(docName, listener);
      docState[docName].listener = null;
      return callback();
    };
    handleOpenCreateSnapshot = function(query, callback) {
      var docData, docName, fail, finish, msg, step1Create, step2Snapshot, step3Open;
      if (query.doc == null) {
        throw new Error('No docName specified');
      }
      if (query.create === true) {
        if (typeof query.type !== 'string') {
          throw new Error('create:true requires type specified');
        }
      }
      if (query.meta !== void 0) {
        if (!(typeof query.meta === 'object' && Array.isArray(query.meta) === false)) {
          throw new Error('meta must be an object');
        }
      }
      docName = query.doc;
      msg = {
        doc: docName
      };
      fail = function(errorMsg) {
        if (msg.open === true) {
          close(docName);
        }
        if (query.open === true) {
          msg.open = false;
        }
        if (query.snapshot !== void 0) {
          msg.snapshot = null;
        }
        delete msg.create;
        msg.error = errorMsg;
        return send(msg);
      };
      step1Create = function() {
        if (query.create !== true) {
          step2Snapshot();
          return;
        }
        if (docData) {
          msg.create = false;
          return step2Snapshot();
        } else {
          return model.clientCreate(client, docName, query.type, query.meta || {}, function(result, errorMsg) {
            if ((errorMsg != null) && errorMsg !== 'Document already exists') {
              fail(errorMsg);
              return;
            }
            msg.create = result;
            return step2Snapshot();
          });
        }
      };
      step2Snapshot = function() {
        if (query.snapshot !== null || msg.create === true) {
          step3Open();
          return;
        }
        if (docData) {
          msg.v = docData.v;
          if (query.type !== docData.type.name) {
            msg.type = docData.type.name;
          }
          msg.snapshot = docData.snapshot;
        } else {
          fail('Document does not exist');
          return;
        }
        return step3Open();
      };
      step3Open = function() {
        if (query.open !== true) {
          finish();
          return;
        }
        if (query.type && docData !== null && query.type !== docData.type.name) {
          fail('Type mismatch');
          return;
        }
        return open(docName, query.v, function(version, error) {
          if (error) {
            return fail(error);
          } else {
            p("Opened " + docName + " at " + version + " by " + socket.id);
            msg.open = true;
            msg.v = version;
            return finish();
          }
        });
      };
      finish = function() {
        send(msg);
        return callback();
      };
      docData = void 0;
      if (query.snapshot === null || (query.open === true && query.type)) {
        return model.clientGetSnapshot(client, query.doc, function(d, errorMsg) {
          if ((errorMsg != null) && errorMsg !== 'Document does not exist') {
            fail(errorMsg);
          } else {
            docData = d;
            return step1Create();
          }
        });
      } else {
        return step1Create();
      }
    };
    handleClose = function(query, callback) {
      return close(query.doc, function(error) {
        if (error) {
          send({
            doc: query.doc,
            open: false,
            error: error
          });
        } else {
          send({
            doc: query.doc,
            open: false
          });
        }
        return callback();
      });
    };
    handleOp = function(query, callback) {
      var op_data;
      if (query.doc == null) {
        throw new Error('No docName specified');
      }
      if (query.v == null) {
        throw new Error('No version specified');
      }
      op_data = {
        v: query.v,
        op: query.op
      };
      op_data.meta = query.meta || {};
      op_data.meta.source = socket.id;
      return model.clientSubmitOp(client, query.doc, op_data, function(appliedVersion, error) {
        var msg;
        msg = error != null ? (p("Sending error to socket: " + error), {
          doc: query.doc,
          v: null,
          error: error
        }) : {
          doc: query.doc,
          v: appliedVersion
        };
        send(msg);
        return callback();
      });
    };
    flush = function(state) {
      var callback, query;
      if (state.busy || state.queue.length === 0) {
        return;
      }
      state.busy = true;
      query = state.queue.shift();
      callback = function() {
        state.busy = false;
        return flush(state);
      };
      p("processing query " + (i(query)));
      try {
        if (query.open === false) {
          return handleClose(query, callback);
        } else if (query.open !== void 0 || query.snapshot !== void 0 || query.create) {
          return handleOpenCreateSnapshot(query, callback);
        } else if (query.op != null) {
          return handleOp(query, callback);
        } else {
          return util.debug("Unknown message received: " + (util.inspect(query)));
        }
      } catch (error) {
        util.debug(error.stack);
        return callback();
      }
    };
    messageListener = function(query) {
      var _name;
      if (closed) {
        console.warn("WARNING: received query from socket after the socket disconnected.");
        console.warn(socket);
        return;
      }
      try {
        if (typeof query === 'string') {
          query = JSON.parse(query);
        }
        if (query.doc === null) {
          lastReceivedDoc = null;
          query.doc = hat();
        } else if (query.doc !== void 0) {
          lastReceivedDoc = query.doc;
        } else {
          if (!lastReceivedDoc) {
            throw new Error('msg.doc missing. Probably the client reconnected without telling us - this is a socket.io bug.');
          }
          query.doc = lastReceivedDoc;
        }
      } catch (error) {
        util.debug(error.stack);
        return;
      }
      docState[_name = query.doc] || (docState[_name] = {
        listener: null,
        queue: [],
        busy: false
      });
      docState[query.doc].queue.push(query);
      return flush(docState[query.doc]);
    };
    socket.on('message', messageListener);
    return socket.on('disconnect', function() {
      var docName, state;
      p("socket " + socket.id + " disconnected");
      closed = true;
      for (docName in docState) {
        state = docState[docName];
        state.busy = true;
        state.queue = [];
        if (state.listener != null) {
          model.removeListener(docName, state.listener);
        }
      }
      socket.removeListener('message', messageListener);
      return docState = {};
    });
  });
  return server;
};