var text;
if (typeof WEB === 'undefined') {
  text = require('./text');
}
text['api'] = {
  'provides': {
    'text': true
  },
  'getLength': function() {
    return this.snapshot.length;
  },
  'getText': function() {
    return this.snapshot;
  },
  'insert': function(text, pos, callback) {
    var op;
    if (pos == null) {
      pos = 0;
    }
    op = [
      {
        'p': pos,
        'i': text
      }
    ];
    this.submitOp(op, callback);
    return op;
  },
  'del': function(length, pos, callback) {
    var op;
    op = [
      {
        'p': pos,
        'd': this.snapshot.slice(pos, pos + length)
      }
    ];
    this.submitOp(op, callback);
    return op;
  },
  '_register': function() {
    return this.on('remoteop', function(op) {
      var component, _i, _len, _results;
      _results = [];
      for (_i = 0, _len = op.length; _i < _len; _i++) {
        component = op[_i];
        _results.push(component['i'] !== void 0 ? this.emit('insert', component['i'], component['p']) : this.emit('delete', component['d'], component['p']));
      }
      return _results;
    });
  }
};