var type;
if (typeof WEB !== "undefined" && WEB !== null) {
  type = exports.types['text-composable'];
} else {
  type = require('./text-composable');
}
type.api = {
  provides: {
    'text': true
  },
  'getLength': function() {
    return this.snapshot.length;
  },
  'getText': function() {
    return this.snapshot;
  },
  'insert': function(text, pos, callback) {
    var op;
    if (pos == null) {
      pos = 0;
    }
    op = type.normalize([
      pos, {
        'i': text
      }, this.snapshot.length - pos
    ]);
    this.submitOp(op, callback);
    return op;
  },
  'del': function(length, pos, callback) {
    var op;
    op = type.normalize([
      pos, {
        'd': this.snapshot.slice(pos, pos + length)
      }, this.snapshot.length - pos - length
    ]);
    this.submitOp(op, callback);
    return op;
  },
  _register: function() {
    return this.on('remoteop', function(op) {
      var component, pos, _i, _len, _results;
      pos = 0;
      _results = [];
      for (_i = 0, _len = op.length; _i < _len; _i++) {
        component = op[_i];
        _results.push(typeof component === 'number' ? pos += component : component.i !== void 0 ? (this.emit('insert', component.i, pos), pos += component.i.length) : this.emit('delete', component.d, pos));
      }
      return _results;
    });
  }
};