var json, toPathArray;
if (typeof WEB === 'undefined') {
  json = require('./json');
}
toPathArray = function(str) {
  if (typeof str === 'string') {
    return str.split('.');
  } else {
    return str;
  }
};
json['api'] = {
  'provides': {
    'json': true
  },
  'getObject': function() {
    return this.snapshot;
  },
  'set': function(path, value) {
    path = toPathArray(path);
    throw new Error('Not implemented');
  },
  'get': function() {
    var elem, elemType, p, path, _i, _len;
    path = toPathArray(path);
    elem = this.snapshot;
    for (_i = 0, _len = path.length; _i < _len; _i++) {
      p = path[_i];
      elemType = typeof elem;
      if (elemType === 'string' || elemType === 'number' || elemType === 'undefined' || elem === null) {
        throw new Error("Cannot index into element " + elem + " - Path or object invalid.");
      } else {
        elem = elem[p];
      }
    }
    return elem;
  },
  'wrap': function(path) {
    var Doc;
    path = toPathArray(path);
    Doc = function() {
      this.submitOp = function(op) {
        return this.snapshot = type.apply(this.snapshot, op);
      };
      this._register();
      return this;
    };
    Doc.prototype = type.api;
    return MicroEvent.mixin(Doc);
  },
  '_register': function() {
    return this['on']('remoteop', function(op) {
      var component, _i, _len, _results;
      _results = [];
      for (_i = 0, _len = op.length; _i < _len; _i++) {
        component = op[_i];
        _results.push(component['i'] !== void 0 ? this['emit']('insert', component['i'], component['p']) : this['emit']('delete', component['d'], component['p']));
      }
      return _results;
    });
  }
};