(function() {
  
/** @preserve ShareJS v0.2.2
http://sharejs.org

Copyright 2011 ShareJS Authors

BSD licensed:
https://github.com/josephg/ShareJS/raw/master/LICENSE
*/
;
  var MicroEvent, WEB, append, appendPart, checkOp, componentLength, exports, makeTake, nextTick, takePart, transformer, type;
  var __slice = Array.prototype.slice;
  exports = {};
  /**
   @const
   @type {boolean}
*/;
  WEB = true;
  nextTick = (typeof process !== "undefined" && process !== null ? process.nextTick : void 0) || function(fn) {
    return setTimeout(fn, 0);
  };
  MicroEvent = (function() {
    function MicroEvent() {}
    MicroEvent.prototype.on = function(event, fct) {
      var _base;
      this._events || (this._events = {});
      (_base = this._events)[event] || (_base[event] = []);
      this._events[event].push(fct);
      return this;
    };
    MicroEvent.prototype.removeListener = function(event, fct) {
      var i, listeners, _base;
      this._events || (this._events = {});
      listeners = ((_base = this._events)[event] || (_base[event] = []));
      i = 0;
      while (i < listeners.length) {
        if (listeners[i] === fct) {
          listeners[i] = void 0;
        }
        i++;
      }
      nextTick(function() {
        var x;
        return listeners = (function() {
          var _i, _len, _results;
          _results = [];
          for (_i = 0, _len = listeners.length; _i < _len; _i++) {
            x = listeners[_i];
            if (x) {
              _results.push(x);
            }
          }
          return _results;
        })();
      });
      return this;
    };
    MicroEvent.prototype.emit = function() {
      var args, event, fn, _i, _len, _ref, _ref2;
      event = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
      if (!((_ref = this._events) != null ? _ref[event] : void 0)) {
        return this;
      }
      _ref2 = this._events[event];
      for (_i = 0, _len = _ref2.length; _i < _len; _i++) {
        fn = _ref2[_i];
        if (fn) {
          fn.apply(this, args);
        }
      }
      return this;
    };
    return MicroEvent;
  })();
  MicroEvent.mixin = function(obj) {
    var proto;
    proto = obj.prototype || obj;
    proto.on = proto['on'] = MicroEvent.prototype.on;
    proto.removeListener = proto['removeListener'] = MicroEvent.prototype.removeListener;
    proto.emit = MicroEvent.prototype.emit;
    return obj;
  };
  if (typeof module !== "undefined" && module !== null ? module.exports : void 0) {
    module.exports = MicroEvent;
  }
  type = {};
  type.name = 'text-tp2';
  type.tp2 = true;
  type.initialVersion = function() {
    return [];
  };
  checkOp = function(op) {
    var c, last, _i, _len, _results;
    if (!Array.isArray(op)) {
      throw new Error('Op must be an array of components');
    }
    last = null;
    _results = [];
    for (_i = 0, _len = op.length; _i < _len; _i++) {
      c = op[_i];
      if (typeof c === 'object') {
        if (c.i !== void 0) {
          if (!((typeof c.i === 'string' && c.i.length > 0) || (typeof c.i === 'number' && c.i > 0))) {
            throw new Error('Inserts must insert a string or a +ive number');
          }
        } else if (c.d !== void 0) {
          if (!(typeof c.d === 'number' && c.d > 0)) {
            throw new Error('Deletes must be a +ive number');
          }
        } else {
          throw new Error('Operation component must define .i or .d');
        }
      } else {
        if (typeof c !== 'number') {
          throw new Error('Op components must be objects or numbers');
        }
        if (!(c > 0)) {
          throw new Error('Skip components must be a positive number');
        }
        if (typeof last === 'number') {
          throw new Error('Adjacent skip components should be combined');
        }
      }
      _results.push(last = c);
    }
    return _results;
  };
  type.toText = function(doc) {
    var elem, strings;
    strings = (function() {
      var _i, _len, _results;
      _results = [];
      for (_i = 0, _len = doc.length; _i < _len; _i++) {
        elem = doc[_i];
        if (typeof elem === 'string') {
          _results.push(elem);
        }
      }
      return _results;
    })();
    return strings.join('');
  };
  type._takePart = takePart = function(doc, position, maxlength) {
    var part, result;
    if (position.index >= doc.length) {
      throw new Error('Operation goes past the end of the document');
    }
    part = doc[position.index];
    result = typeof part === 'string' ? part.slice(position.offset, position.offset + maxlength) : Math.min(maxlength, part - position.offset);
    if ((part.length || part) - position.offset > maxlength) {
      position.offset += maxlength;
    } else {
      position.index++;
      position.offset = 0;
    }
    return result;
  };
  type._appendPart = appendPart = function(doc, p) {
    if (doc.length === 0) {
      doc.push(p);
    } else if (typeof doc[doc.length - 1] === typeof p) {
      doc[doc.length - 1] += p;
    } else {
      doc.push(p);
    }
  };
  type.apply = function(doc, op) {
    var component, newDoc, part, position, remainder, _i, _len;
    if (!Array.isArray(doc)) {
      throw new Error('Snapshot is invalid');
    }
    checkOp(op);
    newDoc = [];
    position = {
      index: 0,
      offset: 0
    };
    for (_i = 0, _len = op.length; _i < _len; _i++) {
      component = op[_i];
      if (typeof component === 'number') {
        remainder = component;
        while (remainder > 0) {
          part = takePart(doc, position, remainder);
          appendPart(newDoc, part);
          remainder -= part.length || part;
        }
      } else if (component.i !== void 0) {
        appendPart(newDoc, component.i);
      } else if (component.d !== void 0) {
        remainder = component.d;
        while (remainder > 0) {
          part = takePart(doc, position, remainder);
          remainder -= part.length || part;
        }
        appendPart(newDoc, component.d);
      }
    }
    return newDoc;
  };
  type._append = append = function(op, component) {
    var last;
    if (component === 0 || component.i === '' || component.i === 0 || component.d === 0) {} else if (op.length === 0) {
      return op.push(component);
    } else {
      last = op[op.length - 1];
      if (typeof component === 'number' && typeof last === 'number') {
        return op[op.length - 1] += component;
      } else if (component.i !== void 0 && (last.i != null) && typeof last.i === typeof component.i) {
        return last.i += component.i;
      } else if (component.d !== void 0 && (last.d != null)) {
        return last.d += component.d;
      } else {
        return op.push(component);
      }
    }
  };
  makeTake = function(op) {
    var index, offset, peekType, take;
    index = 0;
    offset = 0;
    take = function(maxlength, insertsIndivisible) {
      var c, current, e, result;
      if (index === op.length) {
        return null;
      }
      e = op[index];
      if (typeof (current = e) === 'number' || typeof (current = e.i) === 'number' || (current = e.d) !== void 0) {
        if (!(maxlength != null) || current - offset <= maxlength || (insertsIndivisible && e.i !== void 0)) {
          c = current - offset;
          ++index;
          offset = 0;
        } else {
          offset += maxlength;
          c = maxlength;
        }
        if (e.i !== void 0) {
          return {
            i: c
          };
        } else if (e.d !== void 0) {
          return {
            d: c
          };
        } else {
          return c;
        }
      } else {
        if (!(maxlength != null) || e.i.length - offset <= maxlength || insertsIndivisible) {
          result = {
            i: e.i.slice(offset)
          };
          ++index;
          offset = 0;
        } else {
          result = {
            i: e.i.slice(offset, offset + maxlength)
          };
          offset += maxlength;
        }
        return result;
      }
    };
    peekType = function() {
      return op[index];
    };
    return [take, peekType];
  };
  componentLength = function(component) {
    if (typeof component === 'number') {
      return component;
    } else if (typeof component.i === 'string') {
      return component.i.length;
    } else {
      return component.d || component.i;
    }
  };
  type.normalize = function(op) {
    var component, newOp, _i, _len;
    newOp = [];
    for (_i = 0, _len = op.length; _i < _len; _i++) {
      component = op[_i];
      append(newOp, component);
    }
    return newOp;
  };
  transformer = function(op, otherOp, goForwards, side) {
    var chunk, component, length, newOp, peek, take, _i, _len, _ref, _ref2;
    checkOp(op);
    checkOp(otherOp);
    newOp = [];
    _ref = makeTake(op), take = _ref[0], peek = _ref[1];
    for (_i = 0, _len = otherOp.length; _i < _len; _i++) {
      component = otherOp[_i];
      length = componentLength(component);
      if (component.i !== void 0) {
        if (goForwards) {
          if (side === 'left') {
            while (((_ref2 = peek()) != null ? _ref2.i : void 0) !== void 0) {
              append(newOp, take());
            }
          }
          append(newOp, length);
        } else {
          while (length > 0) {
            chunk = take(length, true);
            if (chunk === null) {
              throw new Error('The transformed op is invalid');
            }
            if (chunk.d !== void 0) {
              throw new Error('The transformed op deletes locally inserted characters - it cannot be purged of the insert.');
            }
            if (typeof chunk === 'number') {
              length -= chunk;
            } else {
              append(newOp, chunk);
            }
          }
        }
      } else {
        while (length > 0) {
          chunk = take(length, true);
          if (chunk === null) {
            throw new Error('The op traverses more elements than the document has');
          }
          append(newOp, chunk);
          if (!chunk.i) {
            length -= componentLength(chunk);
          }
        }
      }
    }
    while ((component = take())) {
      if (component.i === void 0) {
        throw new Error("Remaining fragments in the op: " + component);
      }
      append(newOp, component);
    }
    return newOp;
  };
  type.transform = function(op, otherOp, side) {
    if (!(side === 'left' || side === 'right')) {
      throw new Error("side (" + side + ") should be 'left' or 'right'");
    }
    return transformer(op, otherOp, true, side);
  };
  type.prune = function(op, otherOp) {
    return transformer(op, otherOp, false);
  };
  type.compose = function(op1, op2) {
    var chunk, chunkLength, component, length, result, take, _, _i, _len, _ref;
    checkOp(op1);
    checkOp(op2);
    result = [];
    _ref = makeTake(op1), take = _ref[0], _ = _ref[1];
    for (_i = 0, _len = op2.length; _i < _len; _i++) {
      component = op2[_i];
      if (typeof component === 'number') {
        length = component;
        while (length > 0) {
          chunk = take(length);
          if (chunk === null) {
            throw new Error('The op traverses more elements than the document has');
          }
          append(result, chunk);
          length -= componentLength(chunk);
        }
      } else if (component.i !== void 0) {
        append(result, {
          i: component.i
        });
      } else {
        length = component.d;
        while (length > 0) {
          chunk = take(length);
          if (chunk === null) {
            throw new Error('The op traverses more elements than the document has');
          }
          chunkLength = componentLength(chunk);
          if (chunk.i !== void 0) {
            append(result, {
              i: chunkLength
            });
          } else {
            append(result, {
              d: chunkLength
            });
          }
          length -= chunkLength;
        }
      }
    }
    while ((component = take())) {
      if (component.i === void 0) {
        throw new Error("Remaining fragments in op1: " + component);
      }
      append(result, component);
    }
    return result;
  };
  if (WEB != null) {
    exports.types || (exports.types = {});
    exports.types['text-tp2'] = type;
  } else {
    module.exports = type;
  }
}).call(this);
