(function() {
  var i, p, randomWord, type, util;
  type = sharejs.types.text;
  //randomWord = require('./randomWord');
  type.generateRandomOp = function(docStr) {
    var length, op, pct, pos, str;
    pct = 0.9;
    op = [];
    while (Math.random() < pct) {
      pct /= 2;
      if (Math.random() > 0.5) {
        pos = Math.floor(Math.random() * (docStr.length + 1));
        str = randomWord() + ' ';
        type._append(op, {
          i: str,
          p: pos
        });
        docStr = docStr.slice(0, pos) + str + docStr.slice(pos);
      } else {
        pos = Math.floor(Math.random() * docStr.length);
        length = Math.min(Math.floor(Math.random() * 4), docStr.length - pos);
        type._append(op, {
          d: docStr.slice(pos, pos + length),
          p: pos
        });
        docStr = docStr.slice(0, pos) + docStr.slice(pos + length);
      }
    }
    return [op, docStr];
  };
  this.compress = {
    'sanity checks': function(test) {
      test.deepEqual([], type.compress([]));
      test.deepEqual([
        {
          i: 'blah',
          p: 3
        }
      ], type.compress([
        {
          i: 'blah',
          p: 3
        }
      ]));
      test.deepEqual([
        {
          d: 'blah',
          p: 3
        }
      ], type.compress([
        {
          d: 'blah',
          p: 3
        }
      ]));
      test.deepEqual([
        {
          d: 'blah',
          p: 3
        }, {
          i: 'blah',
          p: 10
        }
      ], type.compress([
        {
          d: 'blah',
          p: 3
        }, {
          i: 'blah',
          p: 10
        }
      ]));
      return test.done();
    },
    'compress inserts': function(test) {
      test.deepEqual([
        {
          i: 'xyzabc',
          p: 10
        }
      ], type.compress([
        {
          i: 'abc',
          p: 10
        }, {
          i: 'xyz',
          p: 10
        }
      ]));
      test.deepEqual([
        {
          i: 'axyzbc',
          p: 10
        }
      ], type.compress([
        {
          i: 'abc',
          p: 10
        }, {
          i: 'xyz',
          p: 11
        }
      ]));
      test.deepEqual([
        {
          i: 'abcxyz',
          p: 10
        }
      ], type.compress([
        {
          i: 'abc',
          p: 10
        }, {
          i: 'xyz',
          p: 13
        }
      ]));
      return test.done();
    },
    'dont compress separate inserts': function(test) {
      var t;
      t = function(op) {
        return test.deepEqual(op, type.compress(op));
      };
      t([
        {
          i: 'abc',
          p: 10
        }, {
          i: 'xyz',
          p: 9
        }
      ]);
      t([
        {
          i: 'abc',
          p: 10
        }, {
          i: 'xyz',
          p: 14
        }
      ]);
      return test.done();
    },
    'compress deletes': function(test) {
      test.deepEqual([
        {
          d: 'xyabc',
          p: 8
        }
      ], type.compress([
        {
          d: 'abc',
          p: 10
        }, {
          d: 'xy',
          p: 8
        }
      ]));
      test.deepEqual([
        {
          d: 'xabcy',
          p: 9
        }
      ], type.compress([
        {
          d: 'abc',
          p: 10
        }, {
          d: 'xy',
          p: 9
        }
      ]));
      test.deepEqual([
        {
          d: 'abcxy',
          p: 10
        }
      ], type.compress([
        {
          d: 'abc',
          p: 10
        }, {
          d: 'xy',
          p: 10
        }
      ]));
      return test.done();
    },
    'dont compress separate deletes': function(test) {
      var t;
      t = function(op) {
        return test.deepEqual(op, type.compress(op));
      };
      t([
        {
          d: 'abc',
          p: 10
        }, {
          d: 'xyz',
          p: 6
        }
      ]);
      t([
        {
          d: 'abc',
          p: 10
        }, {
          d: 'xyz',
          p: 11
        }
      ]);
      return test.done();
    }
  };
  this.compose = {
    'sanity checks': function(test) {
      test.deepEqual(type.compose([], []), []);
      test.deepEqual(type.compose([
        {
          i: 'x',
          p: 0
        }
      ], []), [
        {
          i: 'x',
          p: 0
        }
      ]);
      test.deepEqual(type.compose([], [
        {
          i: 'x',
          p: 0
        }
      ]), [
        {
          i: 'x',
          p: 0
        }
      ]);
      test.deepEqual(type.compose([
        {
          i: 'y',
          p: 100
        }
      ], [
        {
          i: 'x',
          p: 0
        }
      ]), [
        {
          i: 'y',
          p: 100
        }, {
          i: 'x',
          p: 0
        }
      ]);
      return test.done();
    }
  };
  this.transform = {
    'sanity checks': function(test) {
      test.deepEqual([], type.transform([], [], 'client'));
      test.deepEqual([], type.transform([], [], 'server'));
      test.deepEqual([
        {
          i: 'y',
          p: 100
        }, {
          i: 'x',
          p: 0
        }
      ], type.transform([
        {
          i: 'y',
          p: 100
        }, {
          i: 'x',
          p: 0
        }
      ], [], 'client'));
      test.deepEqual([], type.transform([], [
        {
          i: 'y',
          p: 100
        }, {
          i: 'x',
          p: 0
        }
      ], 'server'));
      return test.done();
    },
    'insert': function(test) {
      test.deepEqual([
        [
          {
            i: 'x',
            p: 10
          }
        ], [
          {
            i: 'a',
            p: 1
          }
        ]
      ], type.transformX([
        {
          i: 'x',
          p: 9
        }
      ], [
        {
          i: 'a',
          p: 1
        }
      ]));
      test.deepEqual([
        [
          {
            i: 'x',
            p: 11
          }
        ], [
          {
            i: 'a',
            p: 10
          }
        ]
      ], type.transformX([
        {
          i: 'x',
          p: 10
        }
      ], [
        {
          i: 'a',
          p: 10
        }
      ]));
      test.deepEqual([
        [
          {
            i: 'x',
            p: 10
          }
        ], [
          {
            d: 'a',
            p: 9
          }
        ]
      ], type.transformX([
        {
          i: 'x',
          p: 11
        }
      ], [
        {
          d: 'a',
          p: 9
        }
      ]));
      test.deepEqual([
        [
          {
            i: 'x',
            p: 10
          }
        ], [
          {
            d: 'a',
            p: 10
          }
        ]
      ], type.transformX([
        {
          i: 'x',
          p: 11
        }
      ], [
        {
          d: 'a',
          p: 10
        }
      ]));
      test.deepEqual([
        [
          {
            i: 'x',
            p: 11
          }
        ], [
          {
            d: 'a',
            p: 12
          }
        ]
      ], type.transformX([
        {
          i: 'x',
          p: 11
        }
      ], [
        {
          d: 'a',
          p: 11
        }
      ]));
      test.deepEqual([
        {
          i: 'x',
          p: 10
        }
      ], type.transform([
        {
          i: 'x',
          p: 10
        }
      ], [
        {
          d: 'a',
          p: 11
        }
      ], 'client'));
      test.deepEqual([
        {
          i: 'x',
          p: 10
        }
      ], type.transform([
        {
          i: 'x',
          p: 10
        }
      ], [
        {
          d: 'a',
          p: 10
        }
      ], 'client'));
      test.deepEqual([
        {
          i: 'x',
          p: 10
        }
      ], type.transform([
        {
          i: 'x',
          p: 10
        }
      ], [
        {
          d: 'a',
          p: 10
        }
      ], 'server'));
      return test.done();
    },
    'delete': function(test) {
      test.deepEqual([
        [
          {
            d: 'abc',
            p: 8
          }
        ], [
          {
            d: 'xy',
            p: 4
          }
        ]
      ], type.transformX([
        {
          d: 'abc',
          p: 10
        }
      ], [
        {
          d: 'xy',
          p: 4
        }
      ]));
      test.deepEqual([
        [
          {
            d: 'ac',
            p: 10
          }
        ], []
      ], type.transformX([
        {
          d: 'abc',
          p: 10
        }
      ], [
        {
          d: 'b',
          p: 11
        }
      ]));
      test.deepEqual([
        [], [
          {
            d: 'ac',
            p: 10
          }
        ]
      ], type.transformX([
        {
          d: 'b',
          p: 11
        }
      ], [
        {
          d: 'abc',
          p: 10
        }
      ]));
      test.deepEqual([
        [
          {
            d: 'a',
            p: 10
          }
        ], []
      ], type.transformX([
        {
          d: 'abc',
          p: 10
        }
      ], [
        {
          d: 'bc',
          p: 11
        }
      ]));
      test.deepEqual([
        [
          {
            d: 'c',
            p: 10
          }
        ], []
      ], type.transformX([
        {
          d: 'abc',
          p: 10
        }
      ], [
        {
          d: 'ab',
          p: 10
        }
      ]));
      test.deepEqual([
        [
          {
            d: 'a',
            p: 10
          }
        ], [
          {
            d: 'd',
            p: 10
          }
        ]
      ], type.transformX([
        {
          d: 'abc',
          p: 10
        }
      ], [
        {
          d: 'bcd',
          p: 11
        }
      ]));
      test.deepEqual([
        [
          {
            d: 'd',
            p: 10
          }
        ], [
          {
            d: 'a',
            p: 10
          }
        ]
      ], type.transformX([
        {
          d: 'bcd',
          p: 11
        }
      ], [
        {
          d: 'abc',
          p: 10
        }
      ]));
      test.deepEqual([
        [
          {
            d: 'abc',
            p: 10
          }
        ], [
          {
            d: 'xy',
            p: 10
          }
        ]
      ], type.transformX([
        {
          d: 'abc',
          p: 10
        }
      ], [
        {
          d: 'xy',
          p: 13
        }
      ]));
      return test.done();
    }
  };
  this.transformCursor = {
    'sanity': function(test) {
      test.strictEqual(0, type.transformCursor(0, [], true));
      test.strictEqual(0, type.transformCursor(0, [], false));
      test.strictEqual(100, type.transformCursor(100, []));
      return test.done();
    },
    'vs insert': function(test) {
      test.strictEqual(0, type.transformCursor(0, [
        {
          i: 'asdf',
          p: 100
        }
      ], true));
      test.strictEqual(0, type.transformCursor(0, [
        {
          i: 'asdf',
          p: 100
        }
      ], false));
      test.strictEqual(204, type.transformCursor(200, [
        {
          i: 'asdf',
          p: 100
        }
      ], true));
      test.strictEqual(204, type.transformCursor(200, [
        {
          i: 'asdf',
          p: 100
        }
      ], false));
      test.strictEqual(104, type.transformCursor(100, [
        {
          i: 'asdf',
          p: 100
        }
      ], true));
      test.strictEqual(100, type.transformCursor(100, [
        {
          i: 'asdf',
          p: 100
        }
      ], false));
      return test.done();
    },
    'vs delete': function(test) {
      test.strictEqual(0, type.transformCursor(0, [
        {
          d: 'asdf',
          p: 100
        }
      ], true));
      test.strictEqual(0, type.transformCursor(0, [
        {
          d: 'asdf',
          p: 100
        }
      ], false));
      test.strictEqual(0, type.transformCursor(0, [
        {
          d: 'asdf',
          p: 100
        }
      ]));
      test.strictEqual(196, type.transformCursor(200, [
        {
          d: 'asdf',
          p: 100
        }
      ]));
      test.strictEqual(100, type.transformCursor(100, [
        {
          d: 'asdf',
          p: 100
        }
      ]));
      test.strictEqual(100, type.transformCursor(102, [
        {
          d: 'asdf',
          p: 100
        }
      ]));
      test.strictEqual(100, type.transformCursor(104, [
        {
          d: 'asdf',
          p: 100
        }
      ]));
      test.strictEqual(101, type.transformCursor(105, [
        {
          d: 'asdf',
          p: 100
        }
      ]));
      return test.done();
    }
  };
  this.normalize = {
    'sanity': function(test) {
      var testUnchanged;
      testUnchanged = function(op) {
        return test.deepEqual(op, type.normalize(op));
      };
      testUnchanged([]);
      testUnchanged([
        {
          i: 'asdf',
          p: 100
        }
      ]);
      testUnchanged([
        {
          i: 'asdf',
          p: 100
        }, {
          d: 'fdsa',
          p: 123
        }
      ]);
      return test.done();
    },
    'add missing p:0': function(test) {
      test.deepEqual([
        {
          i: 'abc',
          p: 0
        }
      ], type.normalize([
        {
          i: 'abc'
        }
      ]));
      test.deepEqual([
        {
          d: 'abc',
          p: 0
        }
      ], type.normalize([
        {
          d: 'abc'
        }
      ]));
      test.deepEqual([
        {
          i: 'abc',
          p: 0
        }, {
          d: 'abc',
          p: 0
        }
      ], type.normalize([
        {
          i: 'abc'
        }, {
          d: 'abc'
        }
      ]));
      return test.done();
    },
    'Convert op to an array': function(test) {
      test.deepEqual([
        {
          i: 'abc',
          p: 0
        }
      ], type.normalize({
        i: 'abc',
        p: 0
      }));
      test.deepEqual([
        {
          d: 'abc',
          p: 0
        }
      ], type.normalize({
        d: 'abc',
        p: 0
      }));
      return test.done();
    },
    'really simple op': function(test) {
      test.deepEqual([
        {
          i: 'abc',
          p: 0
        }
      ], type.normalize({
        i: 'abc'
      }));
      return test.done();
    }
  };
  this.randomizer = function(test) {
//    require('../helpers').randomizerTest(type);
    return test.done();
  };
}).call(this);
