{EventEmitter} = require 'events'
Memory = require './Memory'
{triplet} = require './path'
{bufferifyMethods} = require './util/async'
DEFAULT_FLUSH_PERIOD = 200

# TODO Add expiry and expire
DocumentCache = module.exports = ({db: @_db, @flushPeriod, @flushWithOplog, getVersion: @_getVersion}) ->
  EventEmitter.call this

  @flushPeriod ||= DEFAULT_FLUSH_PERIOD

  @clear()

  @startFlushDb()

  return

DocumentCache:: =
  __proto__: EventEmitter::

  # `cb(err, val)` where `val` is the value at `path`
  get: (path, cb) ->
    if val = @_memory.get path
      @_touch ns + '.' + id
      return cb null, val, @version
    [ns, id, pathToAttr] = triplet path
    @_db.get ns, id, pathToAttr, (err, val, ver) =>
      @_touch ns + '.' + id
      cb err, val, ver

  # `cb(err, origDoc, newDoc)` where `newDoc` is the result of applying
  # `method` and `args` where `args` includes the path to `oldDoc`
  update: (method, args, cb) ->
    path = args[0]
    {0: ns, 1: id} = triplet path

    @get ns + '.' + id, (err, origDoc) =>
      return cb err if err
      memory = @_memory
      # TODO Find a way to not pass in memory._data
      try
        memory[method] args..., memory._data
      catch e
        return cb e
      @version = args[args.length-1]
      newDoc = memory.get ns + '.' + id
      toFlushByDocId = @_toFlush[ns] ||= {}
      if @flushWithOplog
        oplog = toFlushByDocId[id] ||= []
        oplog.push [method, args]
      else
        toFlushByDocId[id] = true
      cb null, origDoc, newDoc

  clear: (callback) ->
    @_memory = new Memory

    # Maps doc path -> timestamp
    # to help (eventually) make this a LRU cache
    @_lastTouched = {}

    # Keeps track of the documentations and their cumulative diffs, so we know
    # what to send to the db when it is time to flush the cache to the db.
    # Maps namespace -> id -> [[method, args]...]
    @_toFlush = {}

    if @_interval
      clearInterval @_interval

    callback() if callback

  startFlushDb: ->
    flushDbCb = (err) =>
      @emit 'error', err if err

    @_interval = setInterval =>
      @flushToDb flushDbCb
    , @flushPeriod


  flushToDb: (errback) ->
    db = @_db
    memory = @_memory
    ver = @version
    toFlush = @_toFlush
    if @flushWithOplog
      # We keep conditions outside of hot for loop
      for ns, byId of toFlush
        for docId, oplog of byId
          doc = memory.get ns + '.' + docId
          if doc is undefined
            db.destroy ns, docId, ver, null, errback
          else
            db.update ns, doc, ver, oplog, errback
    else
      for ns, byId of toFlush
        for docId of byId
          doc = memory.get ns + '.' + docId
          if doc is undefined
            doc.destroy ns, docId, ver, null, errback
          else
            db.update ns, doc, ver, null, errback
    @toFlush = {}
    return

  _touch: (pathToDoc) ->
    @_lastTouched[pathToDoc] = +new Date

bufferifyMethods DocumentCache, ['get', 'update', 'flushToDb'],
  await: (onReady) ->
    return onReady() if @version isnt undefined
    @_getVersion (err, ver) =>
      throw err if err
      @version = @_db.version = parseInt(ver, 10)
      return onReady()
