# First argument to query is from, second is as?
query.as('groupTodos').from('todos').byKey('_group.todoIds')
query.from('todos').byKey('_group.todoIds').as('groupTodos')
query('todos').byKey('_group.todoIds').as('groupTodos')
query('todos', 'groupTodos').byKey('_group.todoIds')

# Range
query('topTweetIds').range(0, 9)
# Subscription variables are synced from client to pubSub only
selectedTweetIds = query('topTweetIds').range('$firstTweet', '$lastTweet')

# Can use output of one query as an input to another
query('tweets').byKey(selectedTweetIds).as('selectedTweets')

# Has a property matching a condition
query('todosByTime').where('assigned').equals('$userId').limit(1)
query('todos').where('follower').within('_group.todoIds')
query('todos').where('followers').contains('followerId')
query('todos').where('followers').matches(/^j/i)
query('todos').where('followers').not.matches(/^j/i)

# Subscribe to only certain properties
query('todos').only('red', 'blue', 'green').as('colors')
# Subscribe to all properties except
query('todos').except('yellow').as('colors')

# Todos that have a property 'important' and a property 'blue' or a property 'red'
query('todos').has('important', query.or('blue', 'red')))

store.load 'todos.*', (path, id, done) ->
# Can use a query name in a persistence load handler
store.load query: 'groupTodos', (path, done) ->
