module.exports = Graph = ->
  @_nodesByHash = {} # Maps node.hash() -> node
  @_fromTo = {} # Maps hash of from node -> hash of to node   -> value of edge
  @_toFrom = {} # Mpas hash of to node   -> hash of from node -> value of edge
  return

Graph:: =
  containsNode: (node) -> node.hash() of @_nodesByHash

  addNode: (node) ->
    return node if @containsNode node
    return @_nodesByHash[node.hash()] = node

  addEdge: (fromNode, toNode, val) ->
    unless @containsNode fromNode
      throw new Error 'Does not contain node ' + fromNode
    unless @containsNode toNode
      throw new Error 'Does not contain node ' + toNode
    fromHash = fromNode.hash()
    toHash   = toNode.hash()
    (@_fromTo[fromHash] ||= {})[toHash  ] = val
    (@_toFrom[toHash  ] ||= {})[fromHash] = val
    return val

  nodesPointedToBy: (fromNode) ->
    valsByToHash = @_fromTo[fromNode.hash()]
    @_nodesByHash[hash] for hash of valsByToHash

  nodesPointingTo: (toNode) ->
    valsByFromHash = @_toFrom[toNode.hash()]
    @_nodesByHash[hash] for hash of valsByFromHash

  edgesFrom: (node) ->
    valsByToHash = @_fromTo[node.hash()]
    [@_nodesByHash[hash], val] for hash, val of valsByToHash

  edgesTo: (node) ->
    valsByFromHash = @_toFrom[node.hash()]
    [@_nodesByHash[hash], val] for hash, val of valsByFromHash

  filter: (filterFn) ->
    g = new Graph
    hashesToKeep = {}
    for hash, node of @_nodesByHash
      hashesToKeep[hash] = true if filterFn node

    edgesToAdd = []
    for hash of hashesToKeep
      nodeToKeep = @_nodesByHash[hash]
      g.addNode nodeToKeep
      edgesFromMe = @edgesFrom nodeToKeep
      edgesToMe = @edgesTo nodeToKeep
      for [node, val] in edgesFromMe
        edgesToAdd.push [nodeToKeep, node, val] if node.hash() of hashesToKeep
      for [node, val] in edgesToMe
        edgesToAdd.push [node, nodeToKeep, val] if node.hash() of hashesToKeep
    for [from, to, val] in edgesToAdd
      g.addEdge from, to, val
    return g

  # Returns all nodes that are not pointed to by another node
  rootNodes: ->
    nonRootHashes = Object.keys @_toFrom
    node for hash, node of @_nodesByHash when ! @_toFrom[hash]
