## Questions
1. What is the easiest way for developers to organize shared vs non-shared validation?
2. How to collate validation errors together?
3. If a validation fails, do we include the transaction in the transaction log?
   Do we propagate the transaction to other browsers?

## Other Ideas

It would be useful to define middleware that could be shared by both the Store
and the Model. This could enable shared validation.

Why else would thinking of validation as middleware be useful? TBD.

We should also have contexts to enable context-specific validation. You will
want to validate a user differently during registration than during purchase
checkout.

Here is an idea for using protocoljs to define a routing protocol that
Store and Model can implement differently.

```coffee
router.route store, ['get', '*', -1000], () ->

router.middleware store, ['get', '*'], () ->
```

Here are some ideas for another middleware-like approach:

```coffee
model.defineSteps [
  'validate'
  'logTxn'
  'specEval'
  'commit'
]

model.defineSteps [
  'removeTxn'
  'applyMutation'
]

model.defineSteps ['fetch']

memoryLink = createStepsHandlers
  validate:  (txn, callback, next) ->
    context = transaction.getContext txn
    validators = model._validators[context]
    errors = []
    for validate in validators
      result = validate txn
      errors.push result if isError result
    next(if errors.length then errors else null)

  logTxn:    (txn, callback, next) ->
  specEval:  (txn, callback, next) ->
  commit:    (txn, callback, next) ->

  removeTxn: (txn, next) ->
  applyTxn:  (txn, next) ->

  fetch:
    onUpstream: (target, sendDownstream) ->
    onDownstream: ->

var chain = chainStepsHandlers(memoryLink, localStorageLink, socketioLink)
chain.sendDownstream(x, y, z)
chain.sendUpstream(x, y, z)


model.context 'registration', ->

  model.validator (txn, callback) ->

  model.validator method, (path, val, callback) ->

  model.validator method, path, (val, callback) ->

  # This validate function should have information about the session
  store.validate (txn, callback) ->

  store.validate method, (path, val, callback) ->

  model.before 'txn', (txn) ->

  store.before 'txn', (txn, req, res) ->



  model.before 'set', (path, val) ->

  store.before 'set', (path, val) ->

```
