// TODO Define transaction.getContext and transaction.setContext
var transaction = require('../transaction');

module.exports = {
  events: {
    /**
     * @param {Store|Model} target
     */
    init: function (target) {
      target.eachContext(function (context) {
        context._validators = [];
      });
    }
  }
, proto: {
    /**
     * Kicks off validation on the txn
     */
    _validate: function (txn, callback) {
      var context = transaction.getContext(txn) || 'default'
        , validators = context._validators
        , validateFn
        , errors = []
        , i = validators.length;

      function next (result) {
        if (result !== true) {
          if (Array.isArray(result)) {
            errors = errors.concat(result);
          } else if (typeof result === 'string') {
            errors.push(result);
          }
        }

        if (0 === i--) return callback(errors.length ? errors : null);

        validateFn = validators[i];
        if (validateFn.length === 1) {
          result = validateFn(txn);
          return next(result);
        }
        // If we have an asynchronous validation
        validateFn(txn, next);
      }

      // Kick off all validation
      next(true);
    }

  , validator: function (validationFn) {
      this.currContext._validators.push(validationFn);
      return this;
    }
  }
};
