v0.5 Notes
===========

v0.3.x has a Store server-side that handles all socket.io and pub/sub. It ties
together a bunch of things. In v0.5.x, we can move toward a more modular
architecture, by replacing Store with a number of single responsibility
modules.

Server Components:

- SocketServer
  - Establishes socket connections with the browser
  - Associates the correct session with the socket connection
- Session
- Agent
- ReadController
  - One per socket server
  - Handles fetching and subscribing between server and browser
- WriteController
  - Socket server routes txns to this
- WriteRouter
  - Routes to the correct WriteController instance
  - WriteRouter is sent to AccessController
- ? AccessController ?
- OpLogManager
- OpLog
- PatternPubSubClient
  - #subscribe(pattern, cb)
  - #publish(path, msg, cb)
- QuerySubscriptionClient
  - #subscribe(query, cb)
- PatternExchange (PubSub)
- QueryExchange (PubSub)
  - Routes incoming subscriptions to the proper QueryNode
- QueryNode
  - 2 Kinds
    - PollingQueryNode (dumb)
    - FilterQueryNode (optimized)
  - Uses an OpLogManager to create Doc OpLog

A server-side connection with a browser window should keep around descriptors
of what the client subscription targets and the current metadata of results,
i.e., ns -> id -> {version, fields}

Browser Components:

- Model
  - #fetch(fetchables..., cb) :: * -> World
  - #cleanup(fetchables..., cb) // or maybe World#destroy
  - #subscribe(subscribables..., cb)
  - #unsubscribe(subscribables..., cb)
  - #readStream
    - Streams messages out of the Model
  - #writeStream
    - Streams messages into the Model
  - #filter(ns, opts)
  - #sort(ns, opts)
  - #ref(to, from, key)
  - #refList(to, from, key)
  - #at(path) (or #child(path))
  - #id()
  - #parent()
  - #ancestor(levels)
  - #path(rest)
  - #on(type, pattern, fn)
  - #once(type, pattern, fn)
  - #pass(arg)
  - #context(name)
  - #add(ns, obj)
  - #setNull(k, v)
  - #incr(k, num)
  - @private
    - #_onLocalOp(txn)
    - #_onRemoteOp(txn)
    - _memory
    - _txnRegistry (pending, inflight, remote)
    - _versions
    - _subscriptions
      - didReceiveSnapshot
      - verByDoc
      - model :: ScopedModel
      - target :: readable
    - _fetches
    - broadcaster :: EventEmitter
    - incoming :: EventEmitter
- ServerModel < Model
  - #bundle(fn)
- TransactionRegistry
- Memory
  - #get(k)
  - #set(k, v)
  - #del(k)
  - #push(k, values...)
  - #pop(k)
  - #shift(k)
  - #unshift(k, values...)
  - #insert(k, position, values...)
  - #remove(k, position, howMany)
  - #move(k, fromPosition, toPosition, howMany)
- WorldsManager
  - Manages one writable world and 0+ readable worlds
  - The readable worlds are propagated up to the single writable world
  - #data()
- World
  - WritableWorld
    - Has an oplog
  - ReadableWorld
    - 2 Types?
      - NonListeningWorld (singleton for fetched data)
      - ListeningWorld (Continues listening to the server)
    - Has no oplog

Shared Components:

- Protocols
  - readable
    - subscribe(readable, targets..., cb)
    - fetch(readable, targets..., cb)
    - doesDocMatch(readable, document)
- Transformation functions depending on type
  - These can be optional for now, but will not guarantee eventual consistency.

To Address:

- Different Model behavior on the server
- GC for every kind of object

How do we want to deal with Access Control?
- What does the interface look like now?
- What should it look like in v0.5?
- Whitelisting and nested paths?
- How to deal with access control that depends on pulling down another document
  to compare to one of its attributes?
