
var eq = require('./eq')
  , expect = require('expect.js')

describe('eq.js', function () {

  it('should eval', function () {
    expect(eq('2 + 2'), 4);
  });

  it('should eval with math', function () {
    expect(eq('round(5 / 2)')).to.be(3);
    expect(eq('round(test / 2)', { test: 5 })).to.be(3);
    expect(eq('floor(5 / 2)')).to.be(2);
    expect(eq('cos(PI)')).to.be(-1);
  });

  it('should eval with vars', function () {
    expect(eq('round(cpus / 2)', { cpus: 4 })).to.be(2);
    expect(eq('round(cpUS / cpus)', { cpUS: 4, cpus: 2 })).to.be(2);
  });

  it('should return NaN when it breaks', function () {
    expect(isNaN(eq('sadasdsa'))).to.be(true);
  });

});
