/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.AsyncTask;
import com.couchbase.lite.BlobKey;
import com.couchbase.lite.BlobStore;
import com.couchbase.lite.BlobStoreWriter;
import com.couchbase.lite.Cache;
import com.couchbase.lite.ChangesOptions;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.DatabaseOptions;
import com.couchbase.lite.DatabaseUpgrade;
import com.couchbase.lite.Document;
import com.couchbase.lite.DocumentChange;
import com.couchbase.lite.Manager;
import com.couchbase.lite.Mapper;
import com.couchbase.lite.Misc;
import com.couchbase.lite.Predicate;
import com.couchbase.lite.Query;
import com.couchbase.lite.QueryOptions;
import com.couchbase.lite.QueryRow;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.ReplicationFilterCompiler;
import com.couchbase.lite.Revision;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.SavedRevision;
import com.couchbase.lite.Status;
import com.couchbase.lite.TransactionalTask;
import com.couchbase.lite.ValidationContextImpl;
import com.couchbase.lite.Validator;
import com.couchbase.lite.View;
import com.couchbase.lite.internal.AttachmentInternal;
import com.couchbase.lite.internal.Body;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.replicator.Replication;
import com.couchbase.lite.replicator.ReplicationState;
import com.couchbase.lite.replicator.ReplicationStateTransition;
import com.couchbase.lite.storage.SQLException;
import com.couchbase.lite.store.EncryptableStore;
import com.couchbase.lite.store.StorageValidation;
import com.couchbase.lite.store.Store;
import com.couchbase.lite.store.StoreDelegate;
import com.couchbase.lite.support.Base64;
import com.couchbase.lite.support.FileDirUtils;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.PersistentCookieJar;
import com.couchbase.lite.support.RevisionUtils;
import com.couchbase.lite.support.action.Action;
import com.couchbase.lite.support.action.ActionBlock;
import com.couchbase.lite.support.action.ActionException;
import com.couchbase.lite.support.security.SymmetricKey;
import com.couchbase.lite.support.security.SymmetricKeyException;
import com.couchbase.lite.util.CollectionUtils;
import com.couchbase.lite.util.IOUtils;
import com.couchbase.lite.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

public class Database
implements StoreDelegate {
    public static final String TAG = "Database";
    private static final int MANY_CHANGES_TO_NOTIFY = 5000;
    private static final long kHousekeepingDelayAfterOpening = 3L;
    private static final String DEFAULT_PBKDF2_KEY_SALT = "Salty McNaCl";
    private static final int DEFAULT_PBKDF2_KEY_ROUNDS = 64000;
    private static final String DEFAULT_STORAGE = "SQLite";
    private static final String SQLITE_STORE_CLASS = "com.couchbase.lite.store.SQLiteStore";
    private static final String FORESTDB_STORE_CLASS = "com.couchbase.lite.store.ForestDBStore";
    private static ReplicationFilterCompiler filterCompiler;
    public static int kBigAttachmentLength;
    private static boolean autoCompact;
    public static int DEFAULT_MAX_REVS;
    private Store store = null;
    private final String path;
    private String name;
    private final AtomicBoolean open = new AtomicBoolean(false);
    private Map<String, View> views;
    private Map<String, String> viewDocTypes;
    private Map<String, ReplicationFilter> filters;
    private Map<String, Validator> validations;
    private Map<String, Object> pendingAttachmentsByDigest;
    private final Set<Replication> activeReplicators;
    private final Set<Replication> allReplicators;
    private BlobStore attachments;
    private final Manager manager;
    private final Set<ChangeListener> changeListeners;
    private final Set<DatabaseListener> databaseListeners;
    private final Cache<String, Document> docCache;
    private final List<DocumentChange> changesToNotify;
    private boolean postingChangeNotifications;
    private final Object lockPostingChangeNotifications = new Object();
    private final long startTime;
    private Timer purgeTimer;
    private PersistentCookieJar persistentCookieStore;
    public static String kCBLDatabaseLocalCheckpoint_LocalUUID;
    public static String kLocalCheckpointDocId;

    @InterfaceAudience.Private
    public Database(String path, String name, Manager manager, boolean readOnly) {
        assert (new File(path).isAbsolute());
        this.path = path;
        this.name = name != null ? name : FileDirUtils.getDatabaseNameFromPath(path);
        this.manager = manager;
        this.startTime = System.currentTimeMillis();
        this.changeListeners = new CopyOnWriteArraySet<ChangeListener>();
        this.databaseListeners = Collections.synchronizedSet(new HashSet());
        this.docCache = new Cache();
        this.changesToNotify = Collections.synchronizedList(new ArrayList());
        this.activeReplicators = Collections.synchronizedSet(new HashSet());
        this.allReplicators = Collections.synchronizedSet(new HashSet());
        this.postingChangeNotifications = false;
        this.pendingAttachmentsByDigest = new HashMap<String, Object>();
    }

    @InterfaceAudience.Public
    public static ReplicationFilterCompiler getFilterCompiler() {
        return filterCompiler;
    }

    @InterfaceAudience.Public
    public static void setFilterCompiler(ReplicationFilterCompiler filterCompiler) {
        Database.filterCompiler = filterCompiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Public
    public List<Replication> getAllReplications() {
        ArrayList<Replication> allReplicatorsList = new ArrayList<Replication>();
        Set<Replication> set = this.allReplicators;
        synchronized (set) {
            allReplicatorsList.addAll(this.allReplicators);
        }
        return allReplicatorsList;
    }

    @InterfaceAudience.Public
    public int getDocumentCount() {
        return this.store.getDocumentCount();
    }

    @InterfaceAudience.Public
    public long getLastSequenceNumber() {
        return this.store.getLastSequence();
    }

    @InterfaceAudience.Public
    public Manager getManager() {
        return this.manager;
    }

    @InterfaceAudience.Public
    public String getName() {
        return this.name;
    }

    @InterfaceAudience.Public
    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    @InterfaceAudience.Public
    public void compact() throws CouchbaseLiteException {
        this.store.compact();
        this.garbageCollectAttachments();
    }

    @InterfaceAudience.Public
    public void changeEncryptionKey(final Object newKeyOrPassword) throws CouchbaseLiteException {
        if (!(this.store instanceof EncryptableStore)) {
            throw new CouchbaseLiteException(501);
        }
        SymmetricKey newKey = null;
        if (newKeyOrPassword != null) {
            newKey = this.createSymmetricKey(newKeyOrPassword);
        }
        try {
            Action action = ((EncryptableStore)((Object)this.store)).actionToChangeEncryptionKey(newKey);
            action.add(this.attachments.actionToChangeEncryptionKey(newKey));
            action.add(new ActionBlock(){

                @Override
                public void execute() throws ActionException {
                    Database.this.manager.registerEncryptionKey(newKeyOrPassword, Database.this.name);
                }
            }, null, null);
            action.run();
        }
        catch (ActionException e) {
            throw new CouchbaseLiteException((Throwable)e, 500);
        }
    }

    @InterfaceAudience.Public
    public Query createAllDocumentsQuery() {
        return new Query(this, (View)null);
    }

    @InterfaceAudience.Public
    public Document createDocument() {
        return this.getDocument(Misc.CreateUUID());
    }

    @InterfaceAudience.Public
    public Replication createPullReplication(URL remote) {
        return new Replication(this, remote, Replication.Direction.PULL, null);
    }

    @InterfaceAudience.Public
    public Replication createPushReplication(URL remote) {
        return new Replication(this, remote, Replication.Direction.PUSH, null);
    }

    @InterfaceAudience.Public
    public void delete() throws CouchbaseLiteException {
        if (this.open.get() && !this.close()) {
            throw new CouchbaseLiteException("The database was open, and could not be closed", 500);
        }
        this.manager.forgetDatabase(this);
        if (!this.exists()) {
            return;
        }
        File dir = new File(this.path);
        if (!FileDirUtils.deleteRecursive(dir)) {
            throw new CouchbaseLiteException("Was not able to delete the database directory", 500);
        }
    }

    @InterfaceAudience.Public
    public boolean deleteLocalDocument(String localDocID) throws CouchbaseLiteException {
        return this.putLocalDocument(localDocID, null);
    }

    @InterfaceAudience.Public
    public Document getDocument(String documentId) {
        if (documentId == null || documentId.length() == 0) {
            return null;
        }
        Document doc = this.docCache.get(documentId);
        if (doc == null) {
            doc = new Document(this, documentId);
            if (doc == null) {
                return null;
            }
            this.docCache.put(documentId, doc);
        }
        return doc;
    }

    @InterfaceAudience.Public
    public Document getExistingDocument(String docID) {
        if (docID == null || docID.length() == 0) {
            return null;
        }
        RevisionInternal revisionInternal = this.getDocument(docID, null, true);
        if (revisionInternal == null) {
            return null;
        }
        return this.getDocument(docID);
    }

    @InterfaceAudience.Public
    public Map<String, Object> getExistingLocalDocument(String documentId) {
        RevisionInternal revInt = this.getLocalDocument(Database.makeLocalDocumentId(documentId), null);
        if (revInt == null) {
            return null;
        }
        return revInt.getProperties();
    }

    @InterfaceAudience.Public
    public View getExistingView(String name) {
        View view;
        View view2 = view = this.views != null ? this.views.get(name) : null;
        if (view != null) {
            return view;
        }
        try {
            return this.registerView(new View(this, name, false));
        }
        catch (CouchbaseLiteException e) {
            return null;
        }
    }

    @InterfaceAudience.Public
    public ReplicationFilter getFilter(String filterName) {
        ReplicationFilter result = null;
        if (this.filters != null) {
            result = this.filters.get(filterName);
        }
        if (result == null) {
            ReplicationFilterCompiler filterCompiler = Database.getFilterCompiler();
            if (filterCompiler == null) {
                return null;
            }
            ArrayList<String> outLanguageList = new ArrayList<String>();
            String sourceCode = this.getDesignDocFunction(filterName, "filters", outLanguageList);
            if (sourceCode == null) {
                return null;
            }
            String language = (String)outLanguageList.get(0);
            ReplicationFilter filter = filterCompiler.compileFilterFunction(sourceCode, language);
            if (filter == null) {
                Log.w(TAG, "Filter %s failed to compile", filterName);
                return null;
            }
            this.setFilter(filterName, filter);
            return filter;
        }
        return result;
    }

    @InterfaceAudience.Public
    public Validator getValidation(String name) {
        Validator result = null;
        if (this.validations != null) {
            result = this.validations.get(name);
        }
        return result;
    }

    @InterfaceAudience.Public
    public View getView(String name) {
        View view = null;
        if (this.views != null) {
            view = this.views.get(name);
        }
        if (view != null) {
            return view;
        }
        try {
            return this.registerView(new View(this, name, true));
        }
        catch (CouchbaseLiteException e) {
            Log.w(TAG, "Error in registerView: error=" + e.getLocalizedMessage(), e);
            return null;
        }
    }

    @InterfaceAudience.Public
    public boolean putLocalDocument(String localDocID, Map<String, Object> properties) throws CouchbaseLiteException {
        localDocID = Database.makeLocalDocumentId(localDocID);
        RevisionInternal rev = new RevisionInternal(localDocID, null, properties == null);
        if (properties != null) {
            rev.setProperties(properties);
        }
        return this.store.putLocalRevision(rev, null, false) != null;
    }

    @InterfaceAudience.Public
    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    @InterfaceAudience.Public
    public Future runAsync(final AsyncTask asyncTask) {
        return this.getManager().runAsync(new Runnable(){

            @Override
            public void run() {
                asyncTask.run(Database.this);
            }
        });
    }

    @InterfaceAudience.Public
    public boolean runInTransaction(TransactionalTask task) {
        return this.store.runInTransaction(task);
    }

    @InterfaceAudience.Public
    public void setFilter(String filterName, ReplicationFilter filter) {
        if (this.filters == null) {
            this.filters = new HashMap<String, ReplicationFilter>();
        }
        if (filter != null) {
            this.filters.put(filterName, filter);
        } else {
            this.filters.remove(filterName);
        }
    }

    @InterfaceAudience.Public
    public void setValidation(String name, Validator validator) {
        if (this.validations == null) {
            this.validations = new HashMap<String, Validator>();
        }
        if (validator != null) {
            this.validations.put(name, validator);
        } else {
            this.validations.remove(name);
        }
    }

    @InterfaceAudience.Public
    public void setMaxRevTreeDepth(int maxRevTreeDepth) {
        if (this.store != null) {
            this.store.setMaxRevTreeDepth(maxRevTreeDepth);
        }
    }

    @InterfaceAudience.Public
    public int getMaxRevTreeDepth() {
        return this.store.getMaxRevTreeDepth();
    }

    @InterfaceAudience.Public
    public String toString() {
        return this.getClass().getName() + '[' + this.path + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InterfaceAudience.Private
    public void storageExitedTransaction(boolean committed) {
        if (!committed) {
            List<DocumentChange> list = this.changesToNotify;
            synchronized (list) {
                for (DocumentChange change : this.changesToNotify) {
                    Document doc = this.cachedDocumentWithID(change.getDocumentId());
                    if (doc == null) continue;
                    doc.forgetCurrentRevision();
                }
                this.changesToNotify.clear();
            }
        }
        this.postChangeNotifications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InterfaceAudience.Private
    public void databaseStorageChanged(DocumentChange change) {
        Document doc;
        if (change.getRevisionId() != null) {
            Log.v("CBLite", "---> Added: %s as seq %d", change.getAddedRevision(), change.getAddedRevision().getSequence());
        } else {
            Log.v("CBLite", "---> Purged: docID=%s", change.getDocumentId());
        }
        this.changesToNotify.add(change);
        if (!this.postChangeNotifications() && (doc = this.cachedDocumentWithID(change.getDocumentId())) != null) {
            doc.revisionAdded(change, false);
        }
        if (this.changesToNotify.size() >= 5000) {
            if (this.changesToNotify.size() == 5000) {
                List<DocumentChange> list = this.changesToNotify;
                synchronized (list) {
                    for (DocumentChange c : this.changesToNotify) {
                        c.reduceMemoryUsage();
                    }
                }
            } else {
                change.reduceMemoryUsage();
            }
        }
    }

    @Override
    @InterfaceAudience.Private
    public String generateRevID(byte[] json, boolean deleted, String prevRevID) {
        return RevisionUtils.generateRevID(json, deleted, prevRevID);
    }

    @InterfaceAudience.Private
    public BlobStore getAttachmentStore() {
        return this.attachments;
    }

    private void validateRevision(RevisionInternal newRev, RevisionInternal oldRev, String parentRevID) throws CouchbaseLiteException {
        if (this.validations == null || this.validations.size() == 0) {
            return;
        }
        SavedRevision publicRev = new SavedRevision(this, newRev, parentRevID);
        publicRev.setParentRevisionID(parentRevID);
        ValidationContextImpl context = new ValidationContextImpl(this, oldRev, newRev);
        for (String validationName : this.validations.keySet()) {
            Validator validation = this.getValidation(validationName);
            validation.validate(publicRev, context);
            if (context.getRejectMessage() == null) continue;
            throw new CouchbaseLiteException(context.getRejectMessage(), 403);
        }
    }

    boolean registerAttachmentBodies(final Map<String, Object> attachments, RevisionInternal rev, final Status outStatus) throws CouchbaseLiteException {
        outStatus.setCode(200);
        rev.mutateAttachments(new CollectionUtils.Functor<Map<String, Object>, Map<String, Object>>(){

            @Override
            public Map<String, Object> invoke(Map<String, Object> meta) {
                String name = (String)meta.get("name");
                Object value = attachments.get(name);
                if (value != null) {
                    byte[] data = null;
                    if (value instanceof byte[]) {
                        data = (byte[])value;
                    } else {
                        if (value instanceof URL) {
                            URL url = (URL)value;
                            if ("file".equalsIgnoreCase(url.getProtocol())) {
                                try {
                                    data = IOUtils.toByteArray(url);
                                }
                                catch (IOException e) {
                                    Log.w(Database.TAG, "attachments[\"%s\"] is unable to load", e, name);
                                }
                            } else {
                                Log.w(Database.TAG, "attachments[\"%s\"] is neither byte[] nor file URL", name);
                            }
                        }
                        if (data == null) {
                            outStatus.setCode(491);
                            return null;
                        }
                    }
                    BlobStoreWriter writer = Database.this.getAttachmentWriter();
                    try {
                        writer.appendData(data);
                        writer.finish();
                    }
                    catch (Exception e) {
                        Log.w(Database.TAG, "failed to write attachment data name: %s", e, name);
                        outStatus.setCode(491);
                        return null;
                    }
                    HashMap<String, Object> nuMeta = new HashMap<String, Object>(meta);
                    nuMeta.remove("data");
                    nuMeta.remove("stub");
                    nuMeta.put("follows", true);
                    String digest = (String)meta.get("digest");
                    String sha1Digest = writer.sHA1DigestString();
                    if (digest != null) {
                        if (!digest.equals(sha1Digest) && !digest.equals(writer.mD5DigestString())) {
                            Log.w(Database.TAG, "Attachment '%s' body digest (%s) doesn't match 'digest' property %s", name, sha1Digest, digest);
                            outStatus.setCode(491);
                            return null;
                        }
                    } else {
                        digest = sha1Digest;
                        nuMeta.put("digest", sha1Digest);
                    }
                    Database.this.rememberAttachmentWriter(writer, digest);
                    return nuMeta;
                }
                return meta;
            }
        });
        return outStatus.getCode() == 200;
    }

    private static long smallestLength(Map<String, Object> attachment) {
        long length = 0L;
        Number explicitLength = (Number)attachment.get("length");
        if (explicitLength != null) {
            length = explicitLength.longValue();
        }
        if ((explicitLength = (Number)attachment.get("encoded_length")) != null) {
            length = explicitLength.longValue();
        }
        return length;
    }

    @InterfaceAudience.Private
    public boolean expandAttachments(final RevisionInternal rev, final int minRevPos, final boolean allowFollows, final boolean decodeAttachments, final Status outStatus) {
        outStatus.setCode(200);
        rev.mutateAttachments(new CollectionUtils.Functor<Map<String, Object>, Map<String, Object>>(){

            @Override
            public Map<String, Object> invoke(Map<String, Object> attachment) {
                String name = (String)attachment.get("name");
                int revPos = (Integer)attachment.get("revpos");
                if (revPos < minRevPos && revPos != 0) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("stub", true);
                    map.put("revpos", revPos);
                    return map;
                }
                HashMap<String, Object> expanded = new HashMap<String, Object>();
                expanded.putAll(attachment);
                expanded.remove("stub");
                if (decodeAttachments) {
                    expanded.remove("encoding");
                    expanded.remove("encoded_length");
                }
                if (allowFollows && Database.smallestLength(expanded) >= (long)kBigAttachmentLength) {
                    expanded.put("follows", true);
                    expanded.remove("data");
                } else {
                    byte[] data;
                    expanded.remove("follows");
                    AttachmentInternal attachObj = null;
                    try {
                        attachObj = Database.this.getAttachment(attachment, name);
                    }
                    catch (CouchbaseLiteException e) {
                        outStatus.setCode(e.getCBLStatus().getCode());
                    }
                    if (attachObj == null) {
                        Log.w(Database.TAG, "Can't get attachment '%s' of %s (status %d)", name, rev, outStatus.getCode());
                        return attachment;
                    }
                    byte[] byArray = data = decodeAttachments ? attachObj.getContent() : attachObj.getEncodedContent();
                    if (data == null) {
                        Log.w(Database.TAG, "Can't get binary data of attachment '%s' of %s", name, rev);
                        outStatus.setCode(404);
                        return attachment;
                    }
                    expanded.put("data", Base64.encodeBytes(data));
                }
                return expanded;
            }
        });
        return outStatus.getCode() == 200;
    }

    private boolean processAttachmentsForRevision(final RevisionInternal rev, final List<String> ancestry, final Status outStatus) {
        outStatus.setCode(200);
        Map<String, Object> revAttachments = rev.getAttachments();
        if (revAttachments == null) {
            return true;
        }
        if (rev.isDeleted() || revAttachments.size() == 0) {
            Map<String, Object> body = rev.getProperties();
            body.remove("_attachments");
            rev.setProperties(body);
            return true;
        }
        final String prevRevID = ancestry.size() > 0 ? ancestry.get(0) : null;
        final int generation = Revision.generationFromRevID(prevRevID) + 1;
        final HashMap parentAttachments = new HashMap();
        rev.mutateAttachments(new CollectionUtils.Functor<Map<String, Object>, Map<String, Object>>(){

            @Override
            public Map<String, Object> invoke(Map<String, Object> attachInfo) {
                AttachmentInternal attachment;
                String name = (String)attachInfo.get("name");
                try {
                    attachment = new AttachmentInternal(name, attachInfo);
                }
                catch (CouchbaseLiteException e) {
                    return null;
                }
                if (attachment == null) {
                    return null;
                }
                if (attachment.getEncodedContent() != null) {
                    BlobKey blobKey = new BlobKey();
                    if (!Database.this.attachments.storeBlob(attachment.getEncodedContent(), blobKey)) {
                        outStatus.setCode(592);
                        return null;
                    }
                    attachment.setBlobKey(blobKey);
                } else if (attachInfo.containsKey("follows") && ((Boolean)attachInfo.get("follows")).booleanValue()) {
                    try {
                        Database.this.installAttachment(attachment);
                    }
                    catch (CouchbaseLiteException e) {
                        outStatus.setCode(e.getCBLStatus().getCode());
                        return null;
                    }
                } else if (attachInfo.containsKey("stub") && ((Boolean)attachInfo.get("stub")).booleanValue()) {
                    Map parentAttachment;
                    if (parentAttachments.isEmpty() && prevRevID != null) {
                        Map<String, Object> _parentAttachments = Database.this.getAttachments(rev.getDocID(), prevRevID);
                        if (_parentAttachments == null || _parentAttachments.isEmpty()) {
                            if (Database.this.attachments.hasBlobForKey(attachment.getBlobKey())) {
                                outStatus.setCode(200);
                                return attachInfo;
                            }
                            Map ancestorAttachment = Database.this.findAttachment(name, attachment.getRevpos(), rev.getDocID(), ancestry);
                            if (ancestorAttachment != null) {
                                return ancestorAttachment;
                            }
                            outStatus.setCode(491);
                            return null;
                        }
                        parentAttachments.putAll(_parentAttachments);
                    }
                    if ((parentAttachment = (Map)parentAttachments.get(name)) == null) {
                        outStatus.setCode(491);
                        return null;
                    }
                    return parentAttachment;
                }
                if (attachment.getRevpos() == 0) {
                    attachment.setRevpos(generation);
                } else if (attachment.getRevpos() > generation) {
                    outStatus.setCode(491);
                    return null;
                }
                assert (attachment.isValid());
                return attachment.asStubDictionary();
            }
        });
        return !outStatus.isError();
    }

    private Map<String, Object> findAttachment(String name, long revpos, String docID, List<String> ancestry) {
        for (int i = ancestry.size() - 1; i >= 0; --i) {
            Map<String, Object> attachments;
            String revID = ancestry.get(i);
            if ((long)Revision.generationFromRevID(revID) < revpos || (attachments = this.getAttachments(docID, revID)) == null || !attachments.containsKey(name)) continue;
            return (Map)attachments.get(name);
        }
        return null;
    }

    @Override
    @InterfaceAudience.Private
    public boolean runFilter(ReplicationFilter filter, Map<String, Object> filterParams, RevisionInternal rev) {
        if (filter == null) {
            return true;
        }
        SavedRevision publicRev = new SavedRevision(this, rev);
        return filter.filter(publicRev, filterParams);
    }

    @InterfaceAudience.Private
    public static void setAutoCompact(boolean autoCompact) {
        Database.autoCompact = autoCompact;
    }

    @InterfaceAudience.Private
    public void addDatabaseListener(DatabaseListener listener) {
        this.databaseListeners.add(listener);
    }

    @InterfaceAudience.Private
    public void removeDatabaseListener(DatabaseListener listener) {
        this.databaseListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public List<Replication> getActiveReplications() {
        ArrayList<Replication> replicators = new ArrayList<Replication>();
        Set<Replication> set = this.activeReplicators;
        synchronized (set) {
            replicators.addAll(this.activeReplicators);
        }
        return replicators;
    }

    @InterfaceAudience.Private
    public boolean exists() {
        return new File(this.path).exists();
    }

    @InterfaceAudience.Private
    private Store createStoreInstance(String storageType) {
        String className = Database.getStoreClassName(storageType);
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> ctor = clazz.getDeclaredConstructor(String.class, Manager.class, StoreDelegate.class);
            Store store = (Store)ctor.newInstance(this.path, this.manager, this);
            return store;
        }
        catch (ClassNotFoundException e) {
            Log.d(TAG, "No '%s' class found for the storage type '%s'", className, storageType);
        }
        catch (Exception e) {
            Log.e(TAG, "Cannot create a Store instance of class : %s for the storage type '%s'", e, className, storageType);
        }
        return null;
    }

    @InterfaceAudience.Private
    private static String getStoreClassName(String storageType) {
        if (storageType == null) {
            storageType = DEFAULT_STORAGE;
        }
        if (storageType.equals(DEFAULT_STORAGE)) {
            return SQLITE_STORE_CLASS;
        }
        if (storageType.equals("ForestDB")) {
            return FORESTDB_STORE_CLASS;
        }
        Log.e(TAG, "Invalid storage type: " + storageType);
        return null;
    }

    @InterfaceAudience.Private
    public synchronized void open() throws CouchbaseLiteException {
        this.open(this.manager.getDefaultOptions(this.name));
    }

    @InterfaceAudience.Private
    public synchronized void open(DatabaseOptions options) throws CouchbaseLiteException {
        boolean success;
        File attachmentStorePath;
        String sMaxRevs;
        Object keyOrPassword;
        Store primaryStore;
        String storageType;
        if (this.open.get()) {
            return;
        }
        Log.v(TAG, "Opening %s", this);
        File dir = new File(this.path);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new CouchbaseLiteException("Cannot create database directory", 500);
            }
        } else if (!dir.isDirectory()) {
            throw new CouchbaseLiteException("Database directory is not directory", 500);
        }
        if ((storageType = options.getStorageType()) == null && (storageType = this.manager.getStorageType()) == null) {
            storageType = DEFAULT_STORAGE;
        }
        if ((primaryStore = this.createStoreInstance(storageType)) == null) {
            if (storageType.equals(DEFAULT_STORAGE) || storageType.equals("ForestDB")) {
                Log.w(TAG, "storageType is '%s' but no class implementation found", storageType);
            }
            throw new CouchbaseLiteException("Can't open database in that storage format", 497);
        }
        boolean primarySQLite = DEFAULT_STORAGE.equals(storageType);
        Store otherStore = this.createStoreInstance(primarySQLite ? "ForestDB" : DEFAULT_STORAGE);
        boolean upgrade = false;
        if (options.getStorageType() != null) {
            if (otherStore != null && otherStore.databaseExists(this.path) && !primaryStore.databaseExists(this.path)) {
                upgrade = true;
            }
            if (upgrade && primarySQLite) {
                throw new CouchbaseLiteException("Cannot upgrade to SQLite Storage", 497);
            }
        } else if (otherStore != null && otherStore.databaseExists(this.path)) {
            primaryStore = otherStore;
        }
        this.store = primaryStore;
        this.store.setAutoCompact(autoCompact);
        SymmetricKey encryptionKey = null;
        if (this.store instanceof EncryptableStore && (keyOrPassword = options.getEncryptionKey()) != null) {
            encryptionKey = this.createSymmetricKey(keyOrPassword);
            ((EncryptableStore)((Object)this.store)).setEncryptionKey(encryptionKey);
        }
        this.store.open();
        if (this.privateUUID() == null) {
            if (this.store.setInfo("privateUUID", Misc.CreateUUID()) != 200L) {
                throw new CouchbaseLiteException("Unable to set privateUUID in info", 590);
            }
            if (this.store.setInfo("publicUUID", Misc.CreateUUID()) != 200L) {
                throw new CouchbaseLiteException("Unable to set publicUUID in info", 590);
            }
        }
        int maxRevs = (sMaxRevs = this.store.getInfo("max_revs")) == null ? DEFAULT_MAX_REVS : Integer.parseInt(sMaxRevs);
        this.store.setMaxRevTreeDepth(maxRevs);
        File obsoletedAttachmentStorePath = new File(this.getObsoletedAttachmentStorePath());
        if (obsoletedAttachmentStorePath != null && obsoletedAttachmentStorePath.exists() && obsoletedAttachmentStorePath.isDirectory() && (attachmentStorePath = new File(this.getAttachmentStorePath())) != null && !attachmentStorePath.exists() && !(success = obsoletedAttachmentStorePath.renameTo(attachmentStorePath))) {
            Log.e(TAG, "Could not rename attachment store path");
            this.store.close();
            this.store = null;
            throw new CouchbaseLiteException("Could not rename attachment store path", 500);
        }
        File obsoletedAttachmentStoreParentPath = new File(this.getObsoletedAttachmentStoreParentPath());
        if (obsoletedAttachmentStoreParentPath != null && obsoletedAttachmentStoreParentPath.exists()) {
            obsoletedAttachmentStoreParentPath.delete();
        }
        try {
            if (this.isBlobstoreMigrated() || !this.manager.isAutoMigrateBlobStoreFilename()) {
                this.attachments = new BlobStore(this.manager.getContext(), this.getAttachmentStorePath(), encryptionKey, false);
            } else {
                this.attachments = new BlobStore(this.manager.getContext(), this.getAttachmentStorePath(), encryptionKey, true);
                this.markBlobstoreMigrated();
            }
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Could not initialize attachment store", e);
            this.store.close();
            this.store = null;
            throw new CouchbaseLiteException("Could not initialize attachment store", (Throwable)e, 500);
        }
        this.open.set(true);
        if (upgrade) {
            Log.i(TAG, "Upgrading to %s ...", storageType);
            String dbPath = new File(this.path, "db.sqlite3").getAbsolutePath();
            DatabaseUpgrade upgrader = new DatabaseUpgrade(this.manager, this, dbPath);
            if (!upgrader.importData()) {
                Log.w(TAG, "Upgrade to %s failed", storageType);
                upgrader.backOut();
                this.close();
                throw new CouchbaseLiteException("Cannot upgrade to " + storageType, 590);
            }
            upgrader.deleteSQLiteFiles();
        }
        this.scheduleDocumentExpiration(3L);
    }

    @InterfaceAudience.Private
    SymmetricKey createSymmetricKey(Object keyOrPassword) throws CouchbaseLiteException {
        if (keyOrPassword == null) {
            return null;
        }
        byte[] rawKey = null;
        if (keyOrPassword instanceof String) {
            rawKey = ((EncryptableStore)((Object)this.store)).derivePBKDF2SHA256Key((String)keyOrPassword, DEFAULT_PBKDF2_KEY_SALT.getBytes(), 64000);
        } else if (keyOrPassword instanceof byte[]) {
            rawKey = (byte[])keyOrPassword;
        } else {
            throw new CouchbaseLiteException("Key must be String or byte[32]", 400);
        }
        SymmetricKey symmetricKey = null;
        try {
            symmetricKey = new SymmetricKey(rawKey);
        }
        catch (SymmetricKeyException e) {
            throw new CouchbaseLiteException((Throwable)e, 400);
        }
        return symmetricKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Public
    public boolean close() {
        if (!this.open.get()) {
            this.manager.forgetDatabase(this);
            return false;
        }
        Set<DatabaseListener> set = this.databaseListeners;
        synchronized (set) {
            for (DatabaseListener databaseListener : this.databaseListeners) {
                databaseListener.databaseClosing();
            }
        }
        if (this.views != null) {
            for (View view : this.views.values()) {
                view.close();
            }
        }
        this.views = null;
        boolean stopping = false;
        Set<Replication> set2 = this.activeReplicators;
        synchronized (set2) {
            for (Replication replicator : this.activeReplicators) {
                if (replicator.getStatus() == Replication.ReplicationStatus.REPLICATION_STOPPED) continue;
                replicator.stop();
                stopping = true;
            }
            long l = Replication.DEFAULT_MAX_TIMEOUT_FOR_SHUTDOWN * 1000L;
            long startTime = System.currentTimeMillis();
            while (this.activeReplicators.size() > 0 && stopping && System.currentTimeMillis() - startTime < l) {
                try {
                    this.activeReplicators.wait(l);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.activeReplicators.clear();
        }
        this.allReplicators.clear();
        this.cancelPurgeTimer();
        if (this.store != null) {
            this.store.close();
        }
        this.store = null;
        this.clearDocumentCache();
        this.manager.forgetDatabase(this);
        this.open.set(false);
        return true;
    }

    @InterfaceAudience.Private
    public BlobStoreWriter getAttachmentWriter() {
        return new BlobStoreWriter(this.getAttachmentStore());
    }

    @InterfaceAudience.Private
    public long totalDataSize() {
        long size = 0L;
        for (File f : new File(this.path).listFiles()) {
            size += f.length();
        }
        return size;
    }

    @InterfaceAudience.Private
    public String privateUUID() {
        return this.store.getInfo("privateUUID");
    }

    @InterfaceAudience.Private
    public String publicUUID() {
        return this.store.getInfo("publicUUID");
    }

    @InterfaceAudience.Private
    public RevisionInternal getDocument(String docID, String revID, boolean withBody) {
        return this.store == null ? null : this.store.getDocument(docID, revID, withBody);
    }

    @InterfaceAudience.Private
    public RevisionInternal loadRevisionBody(RevisionInternal rev) throws CouchbaseLiteException {
        return this.store.loadRevisionBody(rev);
    }

    @InterfaceAudience.Private
    public List<String> getPossibleAncestorRevisionIDs(RevisionInternal rev, int limit, AtomicBoolean hasAttachment) {
        return this.store.getPossibleAncestorRevisionIDs(rev, limit, hasAttachment);
    }

    @InterfaceAudience.Private
    public Map<String, Object> getRevisionHistoryDictStartingFromAnyAncestor(RevisionInternal rev, List<String> ancestorRevIDs) {
        List<RevisionInternal> history = this.getRevisionHistory(rev);
        if (ancestorRevIDs != null && ancestorRevIDs.size() > 0 && history != null) {
            for (int i = 0; i < history.size(); ++i) {
                if (!ancestorRevIDs.contains(history.get(i).getRevID())) continue;
                history = history.subList(0, i + 1);
                break;
            }
        }
        return RevisionUtils.makeRevisionHistoryDict(history);
    }

    @InterfaceAudience.Private
    public RevisionList changesSince(long lastSeq, ChangesOptions options, ReplicationFilter filter, Map<String, Object> filterParams) {
        return this.store.changesSince(lastSeq, options, filter, filterParams);
    }

    @InterfaceAudience.Private
    public RevisionList unpushedRevisionsSince(String sequence, ReplicationFilter filter, Map<String, Object> filterParams) {
        long longSequence = 0L;
        if (sequence != null) {
            longSequence = Long.parseLong(sequence);
        }
        ChangesOptions options = new ChangesOptions();
        options.setIncludeConflicts(true);
        return this.changesSince(longSequence, options, filter, filterParams);
    }

    @InterfaceAudience.Private
    public Map<String, Object> getAllDocs(QueryOptions options) throws CouchbaseLiteException {
        long maxSeq;
        long minSeq;
        if (options == null || options.getAllDocsMode() != Query.AllDocsMode.BY_SEQUENCE) {
            return this.store.getAllDocs(options);
        }
        if (options.isDescending()) {
            throw new CouchbaseLiteException(501);
        }
        ChangesOptions changesOpts = new ChangesOptions(options.getLimit(), options.isIncludeDocs(), true, true);
        long startSeq = Database.keyToSequence(options.getStartKey(), 1L);
        long endSeq = Database.keyToSequence(options.getEndKey(), Long.MAX_VALUE);
        if (!options.isInclusiveStart()) {
            ++startSeq;
        }
        if (!options.isInclusiveEnd()) {
            --endSeq;
        }
        if ((minSeq = startSeq) > (maxSeq = endSeq)) {
            return null;
        }
        RevisionList revs = this.store.changesSince(minSeq - 1L, changesOpts, null, null);
        if (revs == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<QueryRow> rows = new ArrayList<QueryRow>();
        Predicate<QueryRow> filter = options.getPostFilter();
        if (options.isDescending()) {
            for (int i = revs.size() - 1; i >= 0; --i) {
                QueryRow row = this.getQueryRow((RevisionInternal)revs.get(i), minSeq, maxSeq, options.getPostFilter());
                if (row == null) continue;
                rows.add(row);
            }
        } else {
            for (int i = 0; i < revs.size(); ++i) {
                QueryRow row = this.getQueryRow((RevisionInternal)revs.get(i), minSeq, maxSeq, options.getPostFilter());
                if (row == null) continue;
                rows.add(row);
            }
        }
        result.put("rows", rows);
        result.put("total_rows", rows.size());
        result.put("offset", options.getSkip());
        return result;
    }

    private QueryRow getQueryRow(RevisionInternal rev, long minSeq, long maxSeq, Predicate<QueryRow> filter) {
        if (rev == null) {
            return null;
        }
        long seq = rev.getSequence();
        if (seq < minSeq || seq > maxSeq) {
            return null;
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("rev", rev.getRevID());
        if (rev.isDeleted()) {
            value.put("deleted", rev.isDeleted() ? Boolean.valueOf(true) : null);
        }
        QueryRow row = new QueryRow(rev.getDocID(), seq, rev.getDocID(), value, rev);
        if (filter == null) {
            return row;
        }
        row.setDatabase(this);
        if (filter.apply(row)) {
            return row;
        }
        return null;
    }

    public AttachmentInternal getAttachment(Map info, String filename) throws CouchbaseLiteException {
        if (info == null) {
            throw new CouchbaseLiteException(404);
        }
        AttachmentInternal attachment = new AttachmentInternal(filename, info);
        attachment.setDatabase(this);
        return attachment;
    }

    @InterfaceAudience.Private
    public URL fileForAttachmentDict(Map<String, Object> attachmentDict) {
        BlobKey key;
        String path;
        String digest = (String)attachmentDict.get("digest");
        if (digest == null) {
            return null;
        }
        Object pending = this.pendingAttachmentsByDigest.get(digest);
        if (pending != null) {
            if (pending instanceof BlobStoreWriter) {
                path = ((BlobStoreWriter)pending).getFilePath();
            } else {
                key = new BlobKey((byte[])pending);
                path = this.attachments.getRawPathForKey(key);
            }
        } else {
            key = new BlobKey(digest);
            path = this.attachments.getRawPathForKey(key);
        }
        URL retval = null;
        try {
            retval = new File(path).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return retval;
    }

    @InterfaceAudience.Private
    public boolean inlineFollowingAttachmentsIn(RevisionInternal rev) {
        return rev.mutateAttachments(new CollectionUtils.Functor<Map<String, Object>, Map<String, Object>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, Object> invoke(Map<String, Object> attachment) {
                byte[] fileData;
                if (!attachment.containsKey("follows")) {
                    return attachment;
                }
                try {
                    BlobStore blobStore = Database.this.getAttachmentStore();
                    String base64Digest = (String)attachment.get("digest");
                    BlobKey blobKey = new BlobKey(base64Digest);
                    InputStream in = blobStore.blobStreamForKey(blobKey);
                    try {
                        fileData = IOUtils.toByteArray(in);
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException e) {
                    Log.e("Sync", "could not retrieve attachment data: %S", e);
                    return null;
                }
                HashMap<String, Object> editedAttachment = new HashMap<String, Object>(attachment);
                editedAttachment.remove("follows");
                editedAttachment.put("data", Base64.encodeBytes(fileData));
                return editedAttachment;
            }
        });
    }

    @InterfaceAudience.Private
    public RevisionInternal updateAttachment(String filename, BlobStoreWriter body, String contentType, AttachmentInternal.AttachmentEncoding encoding, String docID, String oldRevID, URL source) throws CouchbaseLiteException {
        if (filename == null || filename.length() == 0 || body != null && contentType == null || oldRevID != null && docID == null || body != null && docID == null) {
            throw new CouchbaseLiteException(491);
        }
        RevisionInternal oldRev = new RevisionInternal(docID, oldRevID, false);
        if (oldRevID != null) {
            try {
                this.loadRevisionBody(oldRev);
            }
            catch (CouchbaseLiteException e) {
                if (e.getCBLStatus().getCode() == 404 && this.getDocument(docID, null, false) != null) {
                    throw new CouchbaseLiteException(409);
                }
                throw e;
            }
        } else {
            oldRev.setBody(new Body(new HashMap<String, Object>()));
        }
        HashMap<String, Object> attachments = new HashMap<String, Object>();
        if (oldRev.getAttachments() != null) {
            attachments.putAll(oldRev.getAttachments());
        }
        if (body != null) {
            BlobKey key = body.getBlobKey();
            String digest = key.base64Digest();
            HashMap<String, BlobStoreWriter> blobsByDigest = new HashMap<String, BlobStoreWriter>();
            blobsByDigest.put(digest, body);
            this.rememberAttachmentWritersForDigests(blobsByDigest);
            String encodingName = encoding == AttachmentInternal.AttachmentEncoding.AttachmentEncodingGZIP ? "gzip" : null;
            HashMap<String, Object> dict = new HashMap<String, Object>();
            dict.put("digest", digest);
            dict.put("length", body.getLength());
            dict.put("follows", true);
            dict.put("content_type", contentType);
            dict.put("encoding", encodingName);
            attachments.put(filename, dict);
        } else {
            if (oldRevID != null && !attachments.containsKey(filename)) {
                throw new CouchbaseLiteException(404);
            }
            attachments.remove(filename);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.putAll(oldRev.getProperties());
        properties.put("_attachments", attachments);
        Status status = new Status(200);
        RevisionInternal newRev = this.put(docID, properties, oldRevID, false, source, status);
        if (status.isError()) {
            throw new CouchbaseLiteException(status.getCode());
        }
        return newRev;
    }

    @InterfaceAudience.Private
    public void rememberAttachmentWritersForDigests(Map<String, BlobStoreWriter> blobsByDigest) {
        this.pendingAttachmentsByDigest.putAll(blobsByDigest);
    }

    @InterfaceAudience.Private
    public void rememberPendingKey(BlobKey key, String digest) {
        this.pendingAttachmentsByDigest.put(digest, key.getBytes());
    }

    @InterfaceAudience.Private
    public static List<String> parseCouchDBRevisionHistory(Map<String, Object> docProperties) {
        Map revisions = (Map)docProperties.get("_revisions");
        if (revisions == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> revIDs = new ArrayList<String>((List)revisions.get("ids"));
        if (revIDs == null || revIDs.isEmpty()) {
            return new ArrayList<String>();
        }
        Integer start = (Integer)revisions.get("start");
        if (start != null) {
            for (int i = 0; i < revIDs.size(); ++i) {
                String revID = (String)revIDs.get(i);
                Integer n = start;
                Integer n2 = start = Integer.valueOf(start - 1);
                revIDs.set(i, Integer.toString(n) + '-' + revID);
            }
        }
        return revIDs;
    }

    @InterfaceAudience.Private
    public RevisionInternal putRevision(RevisionInternal rev, String prevRevId, boolean allowConflict) throws CouchbaseLiteException {
        Status ignoredStatus = new Status(200);
        return this.putRevision(rev, prevRevId, allowConflict, ignoredStatus);
    }

    @InterfaceAudience.Private
    public RevisionInternal putRevision(RevisionInternal putRev, String inPrevRevID, boolean allowConflict, Status outStatus) throws CouchbaseLiteException {
        return this.put(putRev.getDocID(), putRev.getProperties(), inPrevRevID, allowConflict, null, outStatus);
    }

    public RevisionInternal put(String docID, Map<String, Object> properties, String prevRevID, boolean allowConflict, URL source, Status outStatus) throws CouchbaseLiteException {
        boolean deleting = properties == null || properties.containsKey("_deleted") && (Boolean)properties.get("_deleted") != false;
        Log.v(TAG, "%s _id=%s, _rev=%s (allowConflict=%b)", deleting ? "DELETE" : "PUT", docID, prevRevID, allowConflict);
        if (properties != null && properties.containsKey("_attachments")) {
            RevisionInternal tmpRev = new RevisionInternal(docID, prevRevID, deleting);
            tmpRev.setProperties(properties);
            ArrayList<String> ancestry = new ArrayList<String>();
            if (prevRevID != null) {
                ancestry.add(prevRevID);
            }
            if (!this.processAttachmentsForRevision(tmpRev, ancestry, outStatus)) {
                return null;
            }
            properties = tmpRev.getProperties();
        }
        StorageValidation validationBlock = null;
        if (this.validations != null && this.validations.size() > 0) {
            validationBlock = new StorageValidation(){

                @Override
                public Status validate(RevisionInternal newRev, RevisionInternal prevRev, String parentRevID) {
                    try {
                        Database.this.validateRevision(newRev, prevRev, parentRevID);
                    }
                    catch (CouchbaseLiteException e) {
                        return new Status(403);
                    }
                    return new Status(200);
                }
            };
        }
        return this.store.add(docID, prevRevID, properties, deleting, allowConflict, validationBlock, outStatus);
    }

    @InterfaceAudience.Private
    public void forceInsert(RevisionInternal inRev, List<String> history, URL source) throws CouchbaseLiteException {
        Log.v(TAG, "INSERT %s, history[%d]", inRev, history == null ? 0 : history.size());
        String docID = inRev.getDocID();
        String revID = inRev.getRevID();
        if (!Document.isValidDocumentId(docID) || revID == null) {
            throw new CouchbaseLiteException(494);
        }
        int historyCount = 0;
        if (history != null) {
            historyCount = history.size();
        }
        if (historyCount == 0) {
            history = new ArrayList<String>();
            history.add(revID);
        } else if (!history.get(0).equals(revID)) {
            ArrayList<String> nuHistory = new ArrayList<String>(history);
            nuHistory.add(0, revID);
            history = nuHistory;
        }
        Map<String, Object> attachments = inRev.getAttachments();
        if (attachments != null) {
            Status status;
            List<String> ancestry;
            RevisionInternal updatedRev = inRev.copy();
            if (!this.processAttachmentsForRevision(updatedRev, ancestry = history.subList(1, history.size()), status = new Status(200))) {
                throw new CouchbaseLiteException(status);
            }
            inRev = updatedRev;
        }
        StorageValidation validationBlock = null;
        if (this.validations != null && this.validations.size() > 0) {
            validationBlock = new StorageValidation(){

                @Override
                public Status validate(RevisionInternal newRev, RevisionInternal prevRev, String parentRevID) {
                    try {
                        Database.this.validateRevision(newRev, prevRev, parentRevID);
                    }
                    catch (CouchbaseLiteException e) {
                        return new Status(403);
                    }
                    return new Status(200);
                }
            };
        }
        this.store.forceInsert(inRev, history, validationBlock, source);
    }

    @InterfaceAudience.Private
    public String lastSequenceWithCheckpointId(String checkpointId) {
        return this.store.getInfo(Database.checkpointInfoKey(checkpointId));
    }

    @InterfaceAudience.Private
    public boolean setLastSequence(String lastSequence, String checkpointId) {
        return this.store.setInfo(Database.checkpointInfoKey(checkpointId), lastSequence) != -1L;
    }

    private static String checkpointInfoKey(String checkpointID) {
        return "checkpoint/" + checkpointID;
    }

    @InterfaceAudience.Private
    public int findMissingRevisions(RevisionList touchRevs) throws SQLException {
        return this.store.findMissingRevisions(touchRevs);
    }

    @InterfaceAudience.Private
    public Map<String, Object> purgeRevisions(Map<String, List<String>> docsToRevs) {
        return this.store.purgeRevisions(docsToRevs);
    }

    @InterfaceAudience.Private
    public RevisionInternal getLocalDocument(String docID, String revID) {
        return this.store.getLocalDocument(docID, revID);
    }

    @InterfaceAudience.Private
    public long getStartTime() {
        return this.startTime;
    }

    @InterfaceAudience.Private
    public boolean isOpen() {
        return this.open.get();
    }

    @InterfaceAudience.Private
    public void addReplication(Replication replication) {
        this.allReplicators.add(replication);
    }

    @InterfaceAudience.Private
    public void addActiveReplication(Replication replication) {
        replication.addChangeListener(new Replication.ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void changed(Replication.ChangeEvent event) {
                ReplicationStateTransition transition = event.getTransition();
                if (transition != null && transition.getDestination() == ReplicationState.STOPPED) {
                    Set set = Database.this.activeReplicators;
                    synchronized (set) {
                        Database.this.activeReplicators.remove(event.getSource());
                        Database.this.activeReplicators.notifyAll();
                    }
                }
            }
        });
        this.activeReplicators.add(replication);
    }

    @InterfaceAudience.Private
    public PersistentCookieJar getPersistentCookieStore() {
        if (this.persistentCookieStore == null) {
            this.persistentCookieStore = new PersistentCookieJar(this);
        }
        return this.persistentCookieStore;
    }

    protected void clearDocumentCache() {
        this.docCache.clear();
    }

    protected Document getCachedDocument(String documentID) {
        return this.docCache.get(documentID);
    }

    protected void removeDocumentFromCache(Document document) {
        this.docCache.remove(document.getId());
    }

    protected String getAttachmentStorePath() {
        return new File(this.path, "attachments").getPath();
    }

    private String getObsoletedAttachmentStorePath() {
        String attachmentStorePath = this.path;
        int lastDotPosition = attachmentStorePath.lastIndexOf(46);
        if (lastDotPosition > 0) {
            attachmentStorePath = attachmentStorePath.substring(0, lastDotPosition);
        }
        attachmentStorePath = attachmentStorePath + File.separator + "attachments";
        return attachmentStorePath;
    }

    private String getObsoletedAttachmentStoreParentPath() {
        String attachmentStorePath = this.path;
        int lastDotPosition = attachmentStorePath.lastIndexOf(46);
        if (lastDotPosition > 0) {
            attachmentStorePath = attachmentStorePath.substring(0, lastDotPosition);
        }
        return attachmentStorePath;
    }

    private boolean isBlobstoreMigrated() {
        Map<String, Object> props = this.getExistingLocalDocument("_blobstore");
        if (props != null && props.containsKey("blobstoreMigrated")) {
            return (Boolean)props.get("blobstoreMigrated");
        }
        return false;
    }

    private void markBlobstoreMigrated() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("blobstoreMigrated", true);
        try {
            this.putLocalDocument("_blobstore", props);
        }
        catch (CouchbaseLiteException e) {
            Log.e(TAG, e.getMessage());
        }
    }

    protected String getPath() {
        return this.path;
    }

    public Store getStore() {
        return this.store;
    }

    @InterfaceAudience.Private
    public List<RevisionInternal> getRevisionHistory(RevisionInternal rev) {
        return this.store.getRevisionHistory(rev);
    }

    private String getDesignDocFunction(String fnName, String key, List<String> outLanguageList) {
        String[] path = fnName.split("/");
        if (path.length != 2) {
            return null;
        }
        String docId = String.format(Locale.ENGLISH, "_design/%s", path[0]);
        RevisionInternal rev = this.getDocument(docId, null, true);
        if (rev == null) {
            return null;
        }
        String outLanguage = (String)rev.getPropertyForKey("language");
        if (outLanguage != null) {
            outLanguageList.add(outLanguage);
        } else {
            outLanguageList.add("javascript");
        }
        Map container = (Map)rev.getPropertyForKey(key);
        return (String)container.get(path[1]);
    }

    @InterfaceAudience.Private
    protected void setViewDocumentType(String docType, String viewName) {
        if (this.viewDocTypes == null) {
            this.viewDocTypes = new HashMap<String, String>();
        }
        this.viewDocTypes.put(viewName, docType);
    }

    @InterfaceAudience.Private
    protected String getViewDocumentType(String viewName) {
        if (this.viewDocTypes == null) {
            return null;
        }
        return this.viewDocTypes.get(viewName);
    }

    private void removeViewDocumentType(String viewName) {
        if (this.viewDocTypes != null) {
            this.viewDocTypes.remove(viewName);
        }
    }

    protected void forgetView(String name) {
        this.views.remove(name);
        this.removeViewDocumentType(name);
    }

    private View registerView(View view) {
        if (view == null) {
            return null;
        }
        if (this.views == null) {
            this.views = new HashMap<String, View>();
        }
        this.views.put(view.getName(), view);
        return view;
    }

    protected List<QueryRow> queryViewNamed(String viewName, QueryOptions options, List<Long> outLastSequence) throws CouchbaseLiteException {
        long before = System.currentTimeMillis();
        long lastSequence = 0L;
        List<QueryRow> rows = null;
        if (viewName != null && viewName.length() > 0) {
            final View view = this.getView(viewName);
            if (view == null) {
                throw new CouchbaseLiteException(new Status(404));
            }
            lastSequence = view.getLastSequenceIndexed();
            if (options.getStale() == Query.IndexUpdateMode.BEFORE || lastSequence <= 0L) {
                view.updateIndex();
                lastSequence = view.getLastSequenceIndexed();
            } else if (options.getStale() == Query.IndexUpdateMode.AFTER && lastSequence < this.getLastSequenceNumber()) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            view.updateIndex();
                        }
                        catch (CouchbaseLiteException e) {
                            Log.e(Database.TAG, "Error updating view index on background thread", e);
                        }
                    }
                }).start();
            }
            rows = view.query(options);
        } else {
            Map<String, Object> allDocsResult = this.getAllDocs(options);
            rows = (List<QueryRow>)allDocsResult.get("rows");
            lastSequence = this.getLastSequenceNumber();
        }
        outLastSequence.add(lastSequence);
        long delta = System.currentTimeMillis() - before;
        Log.d(TAG, "Query view %s completed in %d milliseconds", viewName, delta);
        return rows;
    }

    protected View makeAnonymousView() {
        int i = 0;
        String name;
        View existing;
        while ((existing = this.getExistingView(name = String.format(Locale.ENGLISH, "anon%d", i))) != null) {
            ++i;
        }
        return this.getView(name);
    }

    protected List<View> getAllViews() {
        List<String> names = this.store.getAllViewNames();
        if (names == null) {
            return null;
        }
        ArrayList<View> views = new ArrayList<View>();
        for (String name : names) {
            View view = this.getExistingView(name);
            if (view == null) continue;
            views.add(view);
        }
        return views;
    }

    private void installAttachment(AttachmentInternal attachment) throws CouchbaseLiteException {
        String digest = attachment.getDigest();
        if (digest == null) {
            throw new CouchbaseLiteException(491);
        }
        Object writer = null;
        if (this.pendingAttachmentsByDigest != null && this.pendingAttachmentsByDigest.containsKey(digest)) {
            writer = this.pendingAttachmentsByDigest.get(digest);
        }
        if (writer != null && writer instanceof BlobStoreWriter) {
            BlobStoreWriter blobStoreWriter = (BlobStoreWriter)writer;
            if (!blobStoreWriter.install()) {
                throw new CouchbaseLiteException(592);
            }
            attachment.setBlobKey(blobStoreWriter.getBlobKey());
            attachment.setPossiblyEncodedLength(blobStoreWriter.getLength());
            this.rememberPendingKey(attachment.getBlobKey(), digest);
            return;
        }
        if (writer == null || !(writer instanceof byte[])) {
            if (this.attachments.hasBlobForKey(attachment.getBlobKey())) {
                return;
            }
            Log.w(TAG, "No pending attachment for getDigest: " + digest);
            throw new CouchbaseLiteException(491);
        }
        attachment.setBlobKey(new BlobKey((byte[])writer));
    }

    void setExpirationDate(Date date, String docID) {
        long unixTime = date != null ? date.getTime() / 1000L : 0L;
        this.store.setExpirationOfDocument(unixTime, docID);
        this.scheduleDocumentExpiration(0L);
    }

    private void scheduleDocumentExpiration(long minimumDelay) {
        if (this.store == null) {
            return;
        }
        long nextExpiration = this.store.nextDocumentExpiry();
        if (nextExpiration > 0L) {
            long delay = Math.max((nextExpiration - System.currentTimeMillis()) / 1000L + 1L, minimumDelay);
            Log.v(TAG, "Scheduling next doc expiration in %d sec", delay);
            this.cancelPurgeTimer();
            this.purgeTimer = new Timer();
            this.purgeTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (Database.this.isOpen()) {
                        Database.this.purgeExpiredDocuments();
                    }
                }
            }, delay * 1000L);
        } else {
            Log.v(TAG, "No pending doc expirations");
        }
    }

    private void purgeExpiredDocuments() {
        if (this.store == null) {
            return;
        }
        int nPurged = this.store.purgeExpiredDocuments();
        Log.v(TAG, "Purged %d expired documents", nPurged);
        this.scheduleDocumentExpiration(1L);
    }

    private void cancelPurgeTimer() {
        if (this.purgeTimer != null) {
            this.purgeTimer.cancel();
            this.purgeTimer = null;
        }
    }

    protected Map<String, Object> getAttachments(String docID, String revID) {
        RevisionInternal mrev = new RevisionInternal(docID, revID, false);
        try {
            RevisionInternal rev = this.loadRevisionBody(mrev);
            return rev.getAttachments();
        }
        catch (CouchbaseLiteException e) {
            Log.w(TAG, "Failed to get attachments for " + mrev);
            return null;
        }
    }

    @InterfaceAudience.Private
    public AttachmentInternal getAttachment(RevisionInternal rev, String filename) throws CouchbaseLiteException {
        assert (filename != null);
        Map<String, Object> attachments = rev.getAttachments();
        if (attachments == null && (attachments = this.getAttachments(rev.getDocID(), rev.getRevID())) == null) {
            return null;
        }
        return this.getAttachment((Map)attachments.get(filename), filename);
    }

    protected void rememberAttachmentWriter(BlobStoreWriter writer) {
        this.pendingAttachmentsByDigest.put(writer.mD5DigestString(), writer);
    }

    protected void rememberAttachmentWriter(BlobStoreWriter writer, String digest) {
        this.pendingAttachmentsByDigest.put(digest, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean postChangeNotifications() {
        Object object = this.lockPostingChangeNotifications;
        synchronized (object) {
            if (this.postingChangeNotifications) {
                return false;
            }
            this.postingChangeNotifications = true;
        }
        try {
            boolean posted = false;
            while (this.store != null && !this.store.inTransaction() && this.open.get() && this.changesToNotify.size() > 0) {
                ArrayList<DocumentChange> outgoingChanges = new ArrayList<DocumentChange>();
                List<DocumentChange> list = this.changesToNotify;
                synchronized (list) {
                    outgoingChanges.addAll(this.changesToNotify);
                    this.changesToNotify.clear();
                }
                boolean isExternal = false;
                for (DocumentChange change : outgoingChanges) {
                    Document doc = this.cachedDocumentWithID(change.getDocumentId());
                    if (doc != null) {
                        doc.revisionAdded(change, true);
                    }
                    if (change.getSource() == null) continue;
                    isExternal = true;
                }
                ChangeEvent changeEvent = new ChangeEvent(this, isExternal, outgoingChanges);
                for (ChangeListener changeListener : this.changeListeners) {
                    if (changeListener == null) continue;
                    try {
                        changeListener.changed(changeEvent);
                    }
                    catch (Exception ex) {
                        Log.e(TAG, "%s got exception posting change notification: %s", ex, this, changeListener);
                    }
                }
                posted = true;
            }
            boolean bl = posted;
            return bl;
        }
        catch (Exception e) {
            Log.e(TAG, "Unknown Exception: %s got exception posting change notifications", e, this);
            boolean bl = false;
            return bl;
        }
        finally {
            Object object2 = this.lockPostingChangeNotifications;
            synchronized (object2) {
                this.postingChangeNotifications = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Replication getActiveReplicator(URL remote, boolean push) {
        Set<Replication> set = this.activeReplicators;
        synchronized (set) {
            try {
                URI remoteUri = remote.toURI();
                for (Replication replicator : this.activeReplicators) {
                    if (!replicator.getRemoteUrl().toURI().equals(remoteUri) || replicator.isPull() != !push || !replicator.isRunning()) continue;
                    return replicator;
                }
            }
            catch (URISyntaxException uriException) {
                Log.e(TAG, "Active replicator found with invalid URI", uriException);
            }
        }
        return null;
    }

    protected Replication getReplicator(URL remote, HttpClientFactory httpClientFactory, boolean push, boolean continuous) {
        Replication result = this.getActiveReplicator(remote, push);
        if (result != null) {
            return result;
        }
        result = push ? new Replication(this, remote, Replication.Direction.PUSH, httpClientFactory) : new Replication(this, remote, Replication.Direction.PULL, httpClientFactory);
        result.setContinuous(continuous);
        return result;
    }

    private static String makeLocalDocumentId(String documentId) {
        return String.format(Locale.ENGLISH, "_local/%s", documentId);
    }

    protected Query slowQuery(Mapper map) {
        return new Query(this, map);
    }

    protected RevisionInternal getParentRevision(RevisionInternal rev) {
        return this.store.getParentRevision(rev);
    }

    protected boolean replaceUUIDs() {
        if (this.store.setInfo("publicUUID", Misc.CreateUUID()) == -1L) {
            return false;
        }
        return this.store.setInfo("privateUUID", Misc.CreateUUID()) != -1L;
    }

    protected void setName(String name) {
        this.name = name;
    }

    private Document cachedDocumentWithID(String documentId) {
        return this.docCache.resourceWithCacheKeyDontRecache(documentId);
    }

    private boolean garbageCollectAttachments() throws CouchbaseLiteException {
        Log.v(TAG, "Scanning database revisions for attachments...");
        Set<BlobKey> keys = this.store.findAllAttachmentKeys();
        if (keys == null) {
            return false;
        }
        Log.v(TAG, "    ...found %d attachments", keys.size());
        ArrayList<BlobKey> keysToKeep = new ArrayList<BlobKey>(keys);
        int deleted = this.attachments.deleteBlobsExceptWithKeys(keysToKeep);
        Log.v(TAG, "    ... deleted %d obsolete attachment files.", deleted);
        return deleted >= 0;
    }

    protected boolean saveLocalUUIDInLocalCheckpointDocument() {
        return this.putLocalCheckpointDocumentWithKey(kCBLDatabaseLocalCheckpoint_LocalUUID, this.privateUUID());
    }

    protected boolean putLocalCheckpointDocumentWithKey(String key, Object value) {
        if (key == null || value == null) {
            return false;
        }
        Map<String, Object> localCheckpointDoc = this.getLocalCheckpointDocument();
        HashMap<Object, Object> document = localCheckpointDoc != null ? new HashMap<String, Object>(localCheckpointDoc) : new HashMap();
        document.put(key, value);
        boolean result = false;
        try {
            result = this.putLocalDocument(kLocalCheckpointDocId, document);
            if (!result) {
                Log.w(TAG, "CBLDatabase: Could not create a local checkpoint document with an error");
            }
        }
        catch (CouchbaseLiteException e) {
            Log.w(TAG, "CBLDatabase: Could not create a local checkpoint document with an error", e);
        }
        return result;
    }

    protected Object getLocalCheckpointDocumentPropertyValueForKey(String key) {
        return this.getLocalCheckpointDocument().get(key);
    }

    protected Map<String, Object> getLocalCheckpointDocument() {
        return this.getExistingLocalDocument(kLocalCheckpointDocId);
    }

    private static long keyToSequence(Object key, long dflt) {
        return key instanceof Number ? ((Number)key).longValue() : dflt;
    }

    static {
        kBigAttachmentLength = 2048;
        autoCompact = true;
        DEFAULT_MAX_REVS = 20;
        kCBLDatabaseLocalCheckpoint_LocalUUID = "localUUID";
        kLocalCheckpointDocId = "CBL_LocalCheckpoint";
    }

    @InterfaceAudience.Private
    public static interface DatabaseListener {
        public void databaseClosing();
    }

    @InterfaceAudience.Public
    public static interface ChangeListener {
        public void changed(ChangeEvent var1);
    }

    @InterfaceAudience.Public
    public static class ChangeEvent {
        private Database source;
        private boolean isExternal;
        private List<DocumentChange> changes;

        public ChangeEvent(Database source, boolean isExternal, List<DocumentChange> changes) {
            this.source = source;
            this.isExternal = isExternal;
            this.changes = changes;
        }

        public Database getSource() {
            return this.source;
        }

        public boolean isExternal() {
            return this.isExternal;
        }

        public List<DocumentChange> getChanges() {
            return this.changes;
        }
    }
}

