/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.BlobKey;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Manager;
import com.couchbase.lite.Status;
import com.couchbase.lite.TransactionalTask;
import com.couchbase.lite.internal.AttachmentInternal;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.storage.Cursor;
import com.couchbase.lite.storage.SQLiteStorageEngine;
import com.couchbase.lite.storage.SQLiteStorageEngineFactory;
import com.couchbase.lite.support.FileDirUtils;
import com.couchbase.lite.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class DatabaseUpgrade {
    private static String TAG = "Database";
    private Manager manager;
    private Database db;
    private String path;
    private int numDocs = 0;
    private int numRevs = 0;
    private boolean canRemoveOldAttachmentsDir = true;
    private SQLiteStorageEngine storageEngine = null;

    protected DatabaseUpgrade(Manager manager, Database db, String sqliteFile) {
        this.manager = manager;
        this.db = db;
        this.path = sqliteFile;
        this.numDocs = 0;
        this.numRevs = 0;
        this.canRemoveOldAttachmentsDir = true;
        this.storageEngine = null;
    }

    protected int getNumDocs() {
        return this.numDocs;
    }

    protected int getNumRevs() {
        return this.numRevs;
    }

    protected boolean canRemoveOldAttachmentsDir() {
        return this.canRemoveOldAttachmentsDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean importData() {
        try {
            SQLiteStorageEngineFactory factory = this.manager.getContext().getSQLiteStorageEngineFactory();
            try {
                this.storageEngine = factory.createStorageEngine();
            }
            catch (CouchbaseLiteException e) {
                Log.e(TAG, "Upgrade failed: Unable to create a storage engine", e);
                boolean bl = false;
                if (this.storageEngine != null && this.storageEngine.isOpen()) {
                    this.storageEngine.close();
                }
                return bl;
            }
            if (this.storageEngine == null) {
                Log.e(TAG, "Upgrade failed: Unable to create a storage engine");
                boolean e = false;
                return e;
            }
            if (!this.storageEngine.open(this.path, null)) {
                Log.e(TAG, "Upgrade failed: Couldn't open new db: %s", this.path);
                boolean e = false;
                return e;
            }
            try {
                this.db.open();
            }
            catch (CouchbaseLiteException e) {
                Log.e(TAG, "Upgrade failed:  Couldn't open new db: %s", e, this.db.toString());
                boolean bl = false;
                if (this.storageEngine != null && this.storageEngine.isOpen()) {
                    this.storageEngine.close();
                }
                return bl;
            }
            if (!this.moveAttachmentsDir()) {
                boolean e = false;
                return e;
            }
            String sql = "SELECT doc_id, docid FROM docs";
            String[] args = new String[]{};
            final Cursor cursor = this.storageEngine.rawQuery(sql, args);
            try {
                boolean ret = this.db.runInTransaction(new TransactionalTask(){

                    @Override
                    public boolean run() {
                        cursor.moveToNext();
                        while (!cursor.isAfterLast()) {
                            long docNumericID = cursor.getLong(0);
                            String docID = cursor.getString(1);
                            Status status = DatabaseUpgrade.this.importDoc(docID, docNumericID);
                            if (status.isError()) {
                                return false;
                            }
                            cursor.moveToNext();
                        }
                        return true;
                    }
                });
                if (!ret) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.importLocalDocs();
            this.importInfo();
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.storageEngine != null && this.storageEngine.isOpen()) {
                this.storageEngine.close();
            }
        }
    }

    protected void backOut() {
        File newAttachmentsPath = new File(this.db.getAttachmentStorePath());
        if (newAttachmentsPath.canRead()) {
            File oldAttachmentsPath = new File(FileDirUtils.getPathWithoutExt(this.path) + " attachments");
            if (this.canRemoveOldAttachmentsDir) {
                newAttachmentsPath.renameTo(oldAttachmentsPath);
            }
        }
        try {
            this.db.delete();
        }
        catch (CouchbaseLiteException e) {
            Log.w(TAG, "Failed to delete Database: %s: %s", this.db, e);
        }
    }

    protected void deleteSQLiteFiles() {
        for (String suffix : Arrays.asList("", "-wal", "-shm", "-journal")) {
            File file = new File(this.path + suffix);
            if (!file.exists()) continue;
            file.delete();
        }
    }

    private boolean moveAttachmentsDir() {
        File oldAttachmentsPath = new File(FileDirUtils.getPathWithoutExt(this.path) + " attachments");
        if (!oldAttachmentsPath.canRead()) {
            return true;
        }
        File newAttachmentsPath = new File(this.db.getAttachmentStorePath());
        Log.v(TAG, "Upgrade: Moving '%s' to '%s'", oldAttachmentsPath, newAttachmentsPath);
        FileDirUtils.deleteRecursive(newAttachmentsPath);
        try {
            if (this.canRemoveOldAttachmentsDir) {
                FileDirUtils.copyFolder(oldAttachmentsPath, newAttachmentsPath);
                FileDirUtils.deleteRecursive(oldAttachmentsPath);
            } else {
                FileDirUtils.copyFolder(oldAttachmentsPath, newAttachmentsPath);
            }
        }
        catch (IOException e) {
            Log.w(TAG, "Upgrade failed: Couldn't move attachments: %s", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status importDoc(String docID, long docNumericID) {
        boolean attachmentsTableExists = this.attachmentsTableExists();
        class Pair {
            String revID;
            Long parentSeq;

            Pair(String revID, Long parentSeq) {
                this.revID = revID;
                this.parentSeq = parentSeq;
            }
        }
        HashMap<Long, Pair> tree = new HashMap<Long, Pair>();
        String sql = "SELECT sequence, revid, parent, current, deleted, json, no_attachments FROM revs WHERE doc_id=? ORDER BY sequence";
        String[] args = new String[]{String.valueOf(docNumericID)};
        Cursor cursor = this.storageEngine.rawQuery(sql, args);
        try {
            cursor.moveToNext();
            while (!cursor.isAfterLast()) {
                boolean noAtts;
                long sequence = cursor.getLong(0);
                String revID = cursor.getString(1);
                long parentSeq = cursor.getLong(2);
                boolean current = cursor.getInt(3) != 0;
                boolean bl = noAtts = cursor.getInt(6) != 0;
                if (current) {
                    Status status;
                    boolean deleted = cursor.getInt(4) != 0;
                    byte[] json = cursor.getBlob(5);
                    if (json == null) {
                        json = "{}".getBytes();
                    }
                    if (attachmentsTableExists) {
                        if ((json = this.addAttachmentsToSequence(sequence, json)) == null) {
                            status = new Status(493);
                            return status;
                        }
                    } else if (!noAtts && (json = DatabaseUpgrade.updateAttachmentFollowsInJson(json)) == null) {
                        status = new Status(493);
                        return status;
                    }
                    RevisionInternal rev = new RevisionInternal(docID, revID, deleted);
                    rev.setJSON(json);
                    ArrayList<String> history = new ArrayList<String>();
                    history.add(revID);
                    while (parentSeq > 0L) {
                        Pair ancestor = (Pair)tree.get(parentSeq);
                        history.add(ancestor.revID);
                        parentSeq = ancestor.parentSeq;
                    }
                    try {
                        this.db.forceInsert(rev, history, null);
                    }
                    catch (CouchbaseLiteException ex) {
                        Status status2 = ex.getCBLStatus();
                        if (cursor != null) {
                            cursor.close();
                        }
                        return status2;
                    }
                    ++this.numRevs;
                } else {
                    tree.put(sequence, new Pair(revID, parentSeq));
                }
                cursor.moveToNext();
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        ++this.numDocs;
        return new Status(200);
    }

    private static byte[] updateAttachmentFollowsInJson(byte[] json) {
        Map object = null;
        try {
            object = (Map)Manager.getObjectMapper().readValue(json, Map.class);
        }
        catch (IOException e) {
            return null;
        }
        Map attachments = (Map)object.get("_attachments");
        for (String key : attachments.keySet()) {
            Map attachment = (Map)attachments.get(key);
            attachment.put("follows", true);
            attachment.remove("stub");
        }
        try {
            return Manager.getObjectMapper().writeValueAsBytes((Object)object);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] addAttachmentsToSequence(long sequence, byte[] json) {
        HashMap attachments = new HashMap();
        String sql = "SELECT filename, key, type, length, revpos, encoding, encoded_length FROM attachments WHERE sequence=?";
        String[] args = new String[]{String.valueOf(sequence)};
        Cursor cursor = this.storageEngine.rawQuery(sql, args);
        try {
            cursor.moveToNext();
            while (!cursor.isAfterLast()) {
                String name = cursor.getString(0);
                byte[] key = cursor.getBlob(1);
                String mimeType = cursor.getString(2);
                long length = cursor.getLong(3);
                int revpos = cursor.getInt(4);
                int encoding = cursor.getInt(5);
                long encodingLength = cursor.getLong(6);
                BlobKey blobKey = new BlobKey(key);
                String digest = blobKey.base64Digest();
                HashMap<String, Object> att = new HashMap<String, Object>();
                att.put("content_type", mimeType);
                att.put("digest", digest);
                att.put("length", length);
                att.put("revpos", revpos);
                att.put("follows", true);
                att.put("encoding", AttachmentInternal.AttachmentEncoding.values()[encoding] == AttachmentInternal.AttachmentEncoding.AttachmentEncodingGZIP ? "gzip" : null);
                att.put("encoded_length", AttachmentInternal.AttachmentEncoding.values()[encoding] == AttachmentInternal.AttachmentEncoding.AttachmentEncodingGZIP ? Long.valueOf(encodingLength) : null);
                attachments.put(name, att);
                cursor.moveToNext();
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (attachments.size() > 0) {
            byte[] extraJSON;
            HashMap attachmentsWrapper = new HashMap();
            attachmentsWrapper.put("_attachments", attachments);
            try {
                extraJSON = Manager.getObjectMapper().writeValueAsBytes(attachmentsWrapper);
            }
            catch (IOException e) {
                return null;
            }
            int jsonLength = json.length;
            int extraLength = extraJSON.length;
            if (jsonLength == 2) {
                return extraJSON;
            }
            byte[] newJson = new byte[jsonLength + extraLength - 1];
            System.arraycopy(json, 0, newJson, 0, jsonLength - 1);
            newJson[jsonLength - 1] = 44;
            System.arraycopy(extraJSON, 1, newJson, jsonLength, extraLength - 1);
            return newJson;
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attachmentsTableExists() {
        String sql = "SELECT 1 FROM sqlite_master WHERE type='table' AND name='attachments'";
        Cursor cursor = this.storageEngine.rawQuery(sql, null);
        try {
            if (cursor.moveToNext()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importLocalDocs() {
        String sql = "SELECT docid, json FROM localdocs";
        Cursor cursor = this.storageEngine.rawQuery(sql, null);
        try {
            cursor.moveToNext();
            while (!cursor.isAfterLast()) {
                String docID = cursor.getString(0);
                if (docID.startsWith("_local/")) {
                    docID = docID.substring(7);
                }
                byte[] json = cursor.getBlob(1);
                Log.v(TAG, "Upgrading local doc '%s'", docID);
                try {
                    Map props = (Map)Manager.getObjectMapper().readValue(json, Map.class);
                    if (!this.db.putLocalDocument(docID, props)) {
                        Log.w(TAG, "Couldn't import local doc '%s'", docID);
                    }
                }
                catch (Exception e) {
                    Log.w(TAG, "Couldn't import local doc '%s': '%s'", docID, e);
                }
                cursor.moveToNext();
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    private void importInfo() {
        String sql = "SELECT key, value FROM info";
        Cursor cursor = this.storageEngine.rawQuery(sql, null);
        try {
            cursor.moveToNext();
            while (!cursor.isAfterLast()) {
                this.db.getStore().setInfo(cursor.getString(0), cursor.getString(1));
                cursor.moveToNext();
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }
}

