/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.Attachment;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.DocumentChange;
import com.couchbase.lite.QueryRow;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.SavedRevision;
import com.couchbase.lite.Status;
import com.couchbase.lite.UnsavedRevision;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.util.Log;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class Document {
    public static final String TAG = "Database";
    private Database database;
    private String documentId;
    private SavedRevision currentRevision;
    private final List<ChangeListener> changeListeners = new CopyOnWriteArrayList<ChangeListener>();

    @InterfaceAudience.Private
    public Document(Database database, String documentId) {
        this.database = database;
        this.documentId = documentId;
    }

    @InterfaceAudience.Public
    public Database getDatabase() {
        return this.database;
    }

    @InterfaceAudience.Public
    public String getId() {
        return this.documentId;
    }

    public Date getExpirationDate() {
        long timestamp = this.database.getStore().expirationOfDocument(this.documentId);
        if (timestamp == 0L) {
            return null;
        }
        return new Date(timestamp);
    }

    public void setExpirationDate(Date date) {
        this.database.setExpirationDate(date, this.documentId);
    }

    @InterfaceAudience.Public
    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    @InterfaceAudience.Public
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    @InterfaceAudience.Public
    public boolean isDeleted() {
        try {
            return this.getCurrentRevision() == null && this.getLeafRevisions().size() > 0;
        }
        catch (CouchbaseLiteException e) {
            throw new RuntimeException(e);
        }
    }

    @InterfaceAudience.Public
    public String getCurrentRevisionId() {
        return this.getCurrentRevision() == null ? null : this.getCurrentRevision().getId();
    }

    @InterfaceAudience.Public
    public SavedRevision getCurrentRevision() {
        if (this.currentRevision == null) {
            this.currentRevision = this.getRevision(null);
        }
        return this.currentRevision;
    }

    @InterfaceAudience.Public
    public List<SavedRevision> getRevisionHistory() throws CouchbaseLiteException {
        return this.getCurrentRevision() == null ? null : this.getCurrentRevision().getRevisionHistory();
    }

    @InterfaceAudience.Public
    public List<SavedRevision> getConflictingRevisions() throws CouchbaseLiteException {
        return this.getLeafRevisions(false);
    }

    @InterfaceAudience.Public
    public List<SavedRevision> getLeafRevisions() throws CouchbaseLiteException {
        return this.getLeafRevisions(true);
    }

    @InterfaceAudience.Public
    public Map<String, Object> getProperties() {
        return this.getCurrentRevision() == null ? null : this.getCurrentRevision().getProperties();
    }

    @InterfaceAudience.Public
    public Map<String, Object> getUserProperties() {
        return this.getCurrentRevision() == null ? null : this.getCurrentRevision().getUserProperties();
    }

    @InterfaceAudience.Public
    public boolean delete() throws CouchbaseLiteException {
        return this.getCurrentRevision() == null ? false : this.getCurrentRevision().deleteDocument() != null;
    }

    @InterfaceAudience.Public
    public void purge() throws CouchbaseLiteException {
        HashMap<String, List<String>> docsToRevs = new HashMap<String, List<String>>();
        ArrayList<String> revs = new ArrayList<String>();
        revs.add("*");
        docsToRevs.put(this.documentId, revs);
        this.database.purgeRevisions(docsToRevs);
        this.database.removeDocumentFromCache(this);
    }

    @InterfaceAudience.Public
    public SavedRevision getRevision(String revID) {
        if (revID != null && this.currentRevision != null && revID.equals(this.currentRevision.getId())) {
            return this.currentRevision;
        }
        RevisionInternal revisionInternal = this.database.getDocument(this.getId(), revID, true);
        return this.getRevisionFromRev(revisionInternal);
    }

    @InterfaceAudience.Public
    public UnsavedRevision createRevision() {
        return new UnsavedRevision(this, this.getCurrentRevision());
    }

    @InterfaceAudience.Public
    public Object getProperty(String key) {
        if (this.getCurrentRevision() != null && this.getCurrentRevision().getProperties().containsKey(key)) {
            return this.getCurrentRevision().getProperties().get(key);
        }
        return null;
    }

    @InterfaceAudience.Public
    public SavedRevision putProperties(Map<String, Object> properties) throws CouchbaseLiteException {
        String prevID = (String)properties.get("_rev");
        boolean allowConflict = false;
        return this.putProperties(properties, prevID, allowConflict);
    }

    @InterfaceAudience.Public
    public SavedRevision update(DocumentUpdater updater) throws CouchbaseLiteException {
        int lastErrorCode = -1;
        do {
            UnsavedRevision newRev;
            if (lastErrorCode == 409) {
                this.forgetCurrentRevision();
            }
            if (!updater.update(newRev = this.createRevision())) break;
            try {
                SavedRevision savedRev = newRev.save();
                if (savedRev != null) {
                    return savedRev;
                }
            }
            catch (CouchbaseLiteException e) {
                lastErrorCode = e.getCBLStatus().getCode();
            }
        } while (lastErrorCode == 409);
        return null;
    }

    @InterfaceAudience.Public
    public boolean putExistingRevision(Map<String, Object> properties, Map<String, Object> attachments, List<String> revIDs, URL sourceURL) throws CouchbaseLiteException {
        assert (revIDs != null && revIDs.size() > 0);
        boolean deleted = false;
        if (properties != null) {
            deleted = properties.get("_deleted") != null && (Boolean)properties.get("_deleted") != false;
        }
        RevisionInternal rev = new RevisionInternal(this.documentId, revIDs.get(0), deleted);
        rev.setProperties(this.propertiesToInsert(properties));
        Status status = new Status();
        if (!this.database.registerAttachmentBodies(attachments, rev, status)) {
            return false;
        }
        this.database.forceInsert(rev, revIDs, sourceURL);
        return true;
    }

    @InterfaceAudience.Private
    public static boolean isValidDocumentId(String id) {
        if (id == null || id.length() == 0) {
            return false;
        }
        if (id.charAt(0) == '_') {
            return id.startsWith("_design/");
        }
        return true;
    }

    @InterfaceAudience.Private
    protected List<SavedRevision> getLeafRevisions(boolean includeDeleted) throws CouchbaseLiteException {
        ArrayList<SavedRevision> result = new ArrayList<SavedRevision>();
        RevisionList revs = this.database.getStore().getAllRevisions(this.documentId, true);
        if (revs != null) {
            for (RevisionInternal rev : revs) {
                if (!includeDeleted && rev.isDeleted()) continue;
                result.add(this.getRevisionFromRev(rev));
            }
        }
        return Collections.unmodifiableList(result);
    }

    protected Map<String, Object> propertiesToInsert(Map<String, Object> properties) throws CouchbaseLiteException {
        String idProp = null;
        if (properties != null && properties.containsKey("_id")) {
            idProp = (String)properties.get("_id");
        }
        if (idProp != null && !idProp.equalsIgnoreCase(this.getId())) {
            Log.w(TAG, "Trying to put wrong _id to this: %s properties: %s", this, properties);
        }
        HashMap<String, Object> nuProperties = new HashMap<String, Object>(properties);
        Map attachments = null;
        if (properties != null && properties.containsKey("_attachments")) {
            attachments = (Map)properties.get("_attachments");
        }
        if (attachments != null && attachments.size() > 0) {
            Map<String, Object> updatedAttachments = Attachment.installAttachmentBodies(attachments, this.database);
            nuProperties.put("_attachments", updatedAttachments);
        }
        return nuProperties;
    }

    @InterfaceAudience.Private
    protected SavedRevision putProperties(Map<String, Object> properties, String prevID, boolean allowConflict) throws CouchbaseLiteException {
        RevisionInternal newRev;
        boolean hasTrueDeletedProperty = false;
        if (properties != null) {
            hasTrueDeletedProperty = properties.get("_deleted") != null && (Boolean)properties.get("_deleted") != false;
        }
        boolean deleted = properties == null || hasTrueDeletedProperty;
        RevisionInternal rev = new RevisionInternal(this.documentId, null, deleted);
        if (properties != null) {
            rev.setProperties(this.propertiesToInsert(properties));
        }
        if ((newRev = this.database.putRevision(rev, prevID, allowConflict)) == null) {
            return null;
        }
        return new SavedRevision(this, newRev);
    }

    @InterfaceAudience.Private
    protected SavedRevision getRevisionFromRev(RevisionInternal internalRevision) {
        if (internalRevision == null) {
            return null;
        }
        if (this.currentRevision != null && internalRevision.getRevID().equals(this.currentRevision.getId())) {
            return this.currentRevision;
        }
        return new SavedRevision(this, internalRevision);
    }

    @InterfaceAudience.Private
    protected void loadCurrentRevisionFrom(QueryRow row) {
        if (row.getDocumentRevisionId() == null) {
            return;
        }
        String revId = row.getDocumentRevisionId();
        if (this.currentRevision == null || this.revIdGreaterThanCurrent(revId)) {
            this.forgetCurrentRevision();
            Map<String, Object> properties = row.getDocumentProperties();
            if (properties != null) {
                RevisionInternal rev = new RevisionInternal(properties);
                this.currentRevision = new SavedRevision(this, rev);
            }
        }
    }

    @InterfaceAudience.Private
    private boolean revIdGreaterThanCurrent(String revId) {
        return RevisionInternal.CBLCompareRevIDs(revId, this.currentRevision.getId()) > 0;
    }

    @InterfaceAudience.Private
    protected void revisionAdded(DocumentChange change, boolean notify) {
        if (change.getRevisionId() != null) {
            String revID = change.getWinningRevisionID();
            if (revID == null) {
                return;
            }
            if (this.currentRevision != null && !revID.equals(this.currentRevision.getId())) {
                RevisionInternal rev = change.getWinningRevisionIfKnown();
                if (rev == null) {
                    this.forgetCurrentRevision();
                } else {
                    this.currentRevision = rev.isDeleted() ? null : new SavedRevision(this, rev);
                }
            }
        } else {
            this.currentRevision = null;
        }
        if (notify) {
            for (ChangeListener listener : this.changeListeners) {
                listener.changed(new ChangeEvent(this, change));
            }
        }
    }

    @InterfaceAudience.Private
    protected void forgetCurrentRevision() {
        this.currentRevision = null;
    }

    @InterfaceAudience.Public
    public static interface ChangeListener {
        public void changed(ChangeEvent var1);
    }

    @InterfaceAudience.Public
    public static class ChangeEvent {
        private Document source;
        private DocumentChange change;

        public ChangeEvent(Document source, DocumentChange documentChange) {
            this.source = source;
            this.change = documentChange;
        }

        public Document getSource() {
            return this.source;
        }

        public DocumentChange getChange() {
            return this.change;
        }
    }

    @InterfaceAudience.Public
    public static interface DocumentUpdater {
        public boolean update(UnsavedRevision var1);
    }
}

