/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.NetworkReachabilityListener;
import java.util.ArrayList;
import java.util.List;

public abstract class NetworkReachabilityManager {
    protected List<NetworkReachabilityListener> listeners = new ArrayList<NetworkReachabilityListener>();

    public synchronized void addNetworkReachabilityListener(NetworkReachabilityListener listener) {
        int numListenersBeforeAdd = this.listeners.size();
        this.listeners.add(listener);
        if (numListenersBeforeAdd == 0) {
            this.startListening();
        }
    }

    public synchronized void removeNetworkReachabilityListener(NetworkReachabilityListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            this.stopListening();
        }
    }

    public synchronized void notifyListenersNetworkReachable() {
        for (NetworkReachabilityListener listener : this.listeners) {
            listener.networkReachable();
        }
    }

    public synchronized void notifyListenersNetworkUneachable() {
        for (NetworkReachabilityListener listener : this.listeners) {
            listener.networkUnreachable();
        }
    }

    public abstract void startListening();

    public abstract void stopListening();

    public abstract boolean isOnline();
}

