/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.Database;
import com.couchbase.lite.QueryRow;
import com.couchbase.lite.internal.InterfaceAudience;
import java.util.Iterator;
import java.util.List;

public class QueryEnumerator
implements Iterator<QueryRow>,
Iterable<QueryRow> {
    private Database database;
    private List<QueryRow> rows;
    private int nextRow;
    private long sequenceNumber;

    @InterfaceAudience.Private
    QueryEnumerator(Database database, List<QueryRow> rows, long sequenceNumber) {
        this.database = database;
        this.rows = rows;
        this.sequenceNumber = sequenceNumber;
        for (QueryRow row : rows) {
            row.setDatabase(database);
        }
    }

    @InterfaceAudience.Private
    QueryEnumerator(QueryEnumerator other) {
        this.database = other.database;
        this.rows = other.rows;
        this.sequenceNumber = other.sequenceNumber;
    }

    @InterfaceAudience.Public
    public int getCount() {
        return this.rows.size();
    }

    @InterfaceAudience.Public
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    @InterfaceAudience.Public
    public QueryRow next() {
        if (this.nextRow >= this.rows.size()) {
            return null;
        }
        return this.rows.get(this.nextRow++);
    }

    @InterfaceAudience.Public
    public QueryRow getRow(int index) {
        return this.rows.get(index);
    }

    @InterfaceAudience.Public
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryEnumerator that = (QueryEnumerator)o;
        return !(this.rows != null ? !this.rows.equals(that.rows) : that.rows != null);
    }

    @Override
    @InterfaceAudience.Public
    public boolean hasNext() {
        return this.nextRow < this.rows.size();
    }

    @Override
    @InterfaceAudience.Public
    public void remove() {
        throw new UnsupportedOperationException("QueryEnumerator does not allow remove() to be called");
    }

    @InterfaceAudience.Public
    public boolean isStale() {
        return this.sequenceNumber < this.database.getLastSequenceNumber();
    }

    @InterfaceAudience.Public
    public void reset() {
        this.nextRow = 0;
    }

    @Override
    public Iterator<QueryRow> iterator() {
        return this;
    }
}

